/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.kohnert.asugen;

import de.ahrgr.animal.kohnert.asugen.AnimalObject;
import de.ahrgr.animal.kohnert.asugen.AnimalScriptWriter;
import de.ahrgr.animal.kohnert.asugen.Font;
import de.ahrgr.animal.kohnert.asugen.Node;
import java.util.ArrayList;

public class CodeGroup
extends AnimalObject {
    protected ArrayList<String> lines;
    protected Font font;

    public CodeGroup(AnimalScriptWriter w, Node aPosition) {
        super(w);
        this.name = "code" + this.instance_index;
        this.lines = new ArrayList();
        this.position = aPosition;
        this.font = Font.FT_DEFAULT;
    }

    private void doAddCodeLine(String code, String lineID) {
        this.scriptwriter.out.print("addCodeLine \"");
        this.scriptwriter.out.print(code);
        if (lineID != null) {
            this.scriptwriter.out.print("\" name \"");
            this.scriptwriter.out.print(lineID);
        }
        this.scriptwriter.out.print("\" to \"");
        this.scriptwriter.out.print(this.getName());
        this.scriptwriter.out.print("\"");
        this.scriptwriter.out.println();
    }

    public void addCodeLine(String line) {
        this.lines.add(line);
        if (this.registered) {
            this.doAddCodeLine(line, null);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public boolean setFont(Font f) {
        if (!this.registered) {
            this.font = f;
            return true;
        }
        return false;
    }

    @Override
    public void register() {
        super.register();
        if (!this.registered) {
            this.scriptwriter.out.print("codeGroup \"");
            this.scriptwriter.out.print(this.name);
            this.scriptwriter.out.print("\" at ");
            this.position.print();
            this.printColor();
            this.scriptwriter.out.print(" ");
            this.scriptwriter.out.print(this.font.toAnimalString());
            this.timeOffset.print();
            this.scriptwriter.out.println();
            for (String s : this.lines) {
                this.doAddCodeLine(s, null);
            }
            this.registered = true;
        }
    }
}

