/*
 * Decompiled with CFR 0.152.
 */
package avinteraction.patterns;

import avinteraction.patterns.Answer;
import avinteraction.patterns.DocuPanel;
import avinteraction.patterns.FIBPanel;
import avinteraction.patterns.MCPanel;
import avinteraction.patterns.MSPanel;
import avinteraction.patterns.PatternParser;
import avinteraction.patterns.QuestionPanel;
import avinteraction.patterns.TFPanel;
import avinteraction.patterns.XMLPanel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.Vector;
import org.w3c.dom.Element;

public class PatternUpdate {
    private String xmlFile = null;
    private StringBuffer sb = null;
    private PatternParser parser;
    private XMLPanel xml;

    public PatternUpdate(String file) {
        this.xmlFile = file;
        this.parser = new PatternParser("InteractionPatternsSchema.xsd", this.xmlFile);
    }

    public void setXMLPanel(XMLPanel x) {
        this.xml = x;
    }

    private void readFile() {
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(this.xmlFile);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            this.sb = new StringBuffer();
            while ((strLine = br.readLine()) != null) {
                this.sb.append(strLine);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    private void writeFile(StringBuffer sb2) {
        int ende = this.sb.indexOf("</patterns>");
        this.sb.insert(ende, sb2);
        try {
            FileWriter fstream = new FileWriter(this.xmlFile);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(this.sb.toString());
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    private void buildStandard(StringBuffer sb2, QuestionPanel question) {
        sb2.append("<prompt>" + question.getPrompt() + "</prompt>");
        sb2.append("<pointsPossible>" + question.getPointsPossible() + "</pointsPossible>");
        sb2.append("<group>" + question.getGroup() + "</group>");
    }

    public void update(TFPanel question) {
        this.parser.parse();
        if (!this.parser.isUidExisting(question.getUid())) {
            this.readFile();
            StringBuffer sb2 = new StringBuffer();
            sb2.append("<TFQuestion uid=\"" + question.getUid() + "\">");
            this.buildStandard(sb2, question);
            sb2.append("<answerState>" + question.isAnswerState() + "</answerState>");
            sb2.append("<commentTrue>" + question.getCommentTrue() + "</commentTrue>");
            sb2.append("<commentFalse>" + question.getCommentFalse() + "</commentFalse>");
            sb2.append("</TFQuestion>");
            this.writeFile(sb2);
            question.setWarning("");
            question.resetInteraction();
            this.updateXMLPanel();
        } else {
            question.setWarning("<html><font color=\"#FF0000\">Pattern \"" + question.getUid() + "\" already in use. Select another uid</font></html>");
            question.setUid("");
        }
    }

    public void update(FIBPanel question) {
        this.parser.parse();
        if (!this.parser.isUidExisting(question.getUid())) {
            this.readFile();
            StringBuffer sb2 = new StringBuffer();
            sb2.append("<FIBQuestion uid=\"" + question.getUid() + "\">");
            this.buildStandard(sb2, question);
            sb2.append("<answer>" + question.getAnswer() + "</answer>");
            sb2.append("<comment>" + question.getComment() + "</comment>");
            sb2.append("</FIBQuestion>");
            this.writeFile(sb2);
            question.setWarning("");
            question.resetInteraction();
            this.updateXMLPanel();
        } else {
            question.setWarning("<html><font color=\"#FF0000\">Pattern \"" + question.getUid() + "\" already in use. Select another uid</font></html>");
            question.setUid("");
        }
    }

    public void update(MCPanel question) {
        this.parser.parse();
        if (!this.parser.isUidExisting(question.getUid())) {
            this.readFile();
            StringBuffer sb2 = new StringBuffer();
            sb2.append("<MCQuestion uid=\"" + question.getUid() + "\">");
            this.buildStandard(sb2, question);
            Vector<Answer> answerSet = question.getAnswerSet();
            Answer answer = null;
            int i = 0;
            while (i < answerSet.size()) {
                answer = answerSet.elementAt(i);
                sb2.append("<answer>");
                sb2.append("<text>" + answer.getAnswer() + "</text>");
                sb2.append("<points>" + answer.getPoints() + "</points>");
                sb2.append("<comment>" + answer.getComment() + "</comment>");
                sb2.append("<state>" + answer.isState() + "</state>");
                sb2.append("</answer>");
                ++i;
            }
            sb2.append("</MCQuestion>");
            this.writeFile(sb2);
            question.setWarning("");
            question.resetInteraction();
            this.updateXMLPanel();
        } else {
            question.setWarning("<html><font color=\"#FF0000\">Pattern \"" + question.getUid() + "\" already in use. Select another uid</font></html>");
            question.setUid("");
        }
    }

    public void update(MSPanel question) {
        this.parser.parse();
        if (!this.parser.isUidExisting(question.getUid())) {
            this.readFile();
            StringBuffer sb2 = new StringBuffer();
            sb2.append("<MSQuestion uid=\"" + question.getUid() + "\">");
            this.buildStandard(sb2, question);
            Vector<Answer> answerSet = question.getAnswerSet();
            Answer answer = null;
            int i = 0;
            while (i < answerSet.size()) {
                answer = answerSet.elementAt(i);
                sb2.append("<answer>");
                sb2.append("<text>" + answer.getAnswer() + "</text>");
                sb2.append("<points>" + answer.getPoints() + "</points>");
                sb2.append("<comment>" + answer.getComment() + "</comment>");
                sb2.append("<state>" + answer.isState() + "</state>");
                sb2.append("</answer>");
                ++i;
            }
            sb2.append("</MSQuestion>");
            this.writeFile(sb2);
            question.setWarning("");
            question.resetInteraction();
            this.updateXMLPanel();
        } else {
            question.setWarning("<html><font color=\"#FF0000\">Pattern \"" + question.getUid() + "\" already in use. Select another uid</font></html>");
            question.setUid("");
        }
    }

    public void update(DocuPanel question) {
        this.parser.parse();
        if (!this.parser.isUidExisting(question.getUid())) {
            this.readFile();
            StringBuffer sb2 = new StringBuffer();
            sb2.append("<Documentation uid=\"" + question.getUid() + "\">");
            sb2.append("<URL>" + question.getURL() + "</URL>");
            sb2.append("</Documentation>");
            this.writeFile(sb2);
            question.setWarning("");
            question.resetInteraction();
            this.updateXMLPanel();
        } else {
            question.setWarning("<html><font color=\"#FF0000\">Pattern \"" + question.getUid() + "\" already in use. Select another uid</font></html>");
            question.setUid("");
        }
    }

    private void updateXMLPanel() {
        this.xml.update();
    }

    public String[] getUids() {
        this.parser.parse();
        Vector<String> tmp = this.parser.getUids();
        String[] uids = new String[tmp.size()];
        int i = 0;
        while (i < tmp.size()) {
            uids[i] = tmp.get(i);
            ++i;
        }
        return uids;
    }

    public Element getRoot() {
        this.parser.parse();
        return this.parser.getRoot();
    }

    public void delete(String uid) {
        this.parser.parse();
        if (this.parser.isUidExisting(uid)) {
            this.readFile();
            int start = this.sb.indexOf("<" + this.parser.getType(uid) + " uid=\"" + uid + "\">");
            int end = this.sb.indexOf("</" + this.parser.getType(uid) + ">", start);
            end = this.sb.indexOf(">", end);
            StringBuffer sb2 = new StringBuffer();
            sb2.append(this.sb.substring(0, start));
            sb2.append(this.sb.substring(end + 1, this.sb.length()));
            try {
                FileWriter fstream = new FileWriter(this.xmlFile);
                BufferedWriter out = new BufferedWriter(fstream);
                out.write(sb2.toString());
                out.close();
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
            }
        }
    }
}

