/*
 * Decompiled with CFR 0.152.
 */
package avinteraction.patterns;

import avinteraction.patterns.Answer;
import avinteraction.patterns.AnswerPanel;
import avinteraction.patterns.PatternUpdate;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;

public class MCPanel
extends AnswerPanel {
    private Vector<Answer> answerSet = new Vector();
    private JTextArea answers = new JTextArea(10, 20);
    private JScrollPane scrollPane;

    public MCPanel(PatternUpdate updater) {
        super(updater);
        this.answers.setEditable(false);
        this.scrollPane = new JScrollPane(this.answers);
        JLabel answersL = new JLabel("Saved Answers:");
        this.layout.putConstraint("West", (Component)answersL, 30, "East", (Component)this.uid);
        this.layout.putConstraint("North", (Component)answersL, 0, "North", (Component)this.uid);
        this.layout.putConstraint("West", (Component)this.scrollPane, 30, "East", (Component)this.uid);
        this.layout.putConstraint("North", (Component)this.scrollPane, 5, "South", (Component)this.uid);
        this.panel.add(answersL);
        this.panel.add(this.scrollPane);
    }

    public Vector<Answer> getAnswerSet() {
        return this.answerSet;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String answer;
        Object event = e.getSource();
        if (event.equals(this.answerState)) {
            JComboBox cb = (JComboBox)event;
            String value = (String)cb.getSelectedItem();
            this.state = value.equals("True");
        }
        if (event.equals(this.saveAnswer)) {
            answer = "Answer: " + this.getAnswer() + "\nComment: " + this.getComment() + "\nPoints: " + this.getPoints() + "\nState: " + this.isState() + "\n\n";
            this.answers.append(answer);
            this.answers.setCaretPosition(this.answers.getDocument().getLength());
            this.answerSet.add(new Answer(this.getAnswer(), this.getComment(), this.getPoints(), this.isState()));
            this.reset();
            SpinnerNumberModel model = new SpinnerNumberModel(0, 0, this.answerSet.size() - 1, 1);
            this.delAnswerIndex.setModel(model);
            this.delAnswerIndex.setVisible(true);
            this.delAnswerL.setVisible(true);
            this.deleteAnswer.setVisible(true);
        }
        if (event.equals(this.deleteAnswer)) {
            answer = "";
            Answer tmp = null;
            SpinnerNumberModel model = null;
            this.answerSet.remove(this.getDelAnswerIndex());
            this.answers = new JTextArea(10, 20);
            this.answers.setEditable(false);
            int i = 0;
            while (i < this.answerSet.size()) {
                tmp = this.answerSet.get(i);
                answer = String.valueOf(answer) + "Answer: " + tmp.getAnswer() + "\nComment: " + tmp.getComment() + "\nPoints: " + tmp.getPoints() + "\nState: " + tmp.isState() + "\n\n";
                ++i;
            }
            this.answers.append(answer);
            this.answers.setCaretPosition(this.answers.getDocument().getLength());
            this.scrollPane.setViewportView(this.answers);
            model = this.answerSet.size() == 0 ? new SpinnerNumberModel(0, 0, 0, 1) : new SpinnerNumberModel(0, 0, this.answerSet.size() - 1, 1);
            this.delAnswerIndex.setModel(model);
            if (this.answerSet.size() == 0) {
                this.delAnswerIndex.setVisible(false);
                this.delAnswerL.setVisible(false);
                this.deleteAnswer.setVisible(false);
            }
        }
        if (event.equals(this.applyButton)) {
            this.updater.update(this);
        }
    }

    public void resetInteraction() {
        this.uid.setText("");
        this.promptt.setText("");
        this.group.setText("");
        this.points.setValue(0);
        this.answers.setText("");
        this.reset();
    }
}

