/*
 * Decompiled with CFR 0.152.
 */
package avinteraction.parser;

import avinteraction.InteractionModule;
import avinteraction.parser.BadSyntaxException;
import avinteraction.parser.ParserInterface;
import java.io.IOException;
import java.io.StreamTokenizer;

public class Parser
implements ParserInterface {
    protected static final String EMPTY_STRING = "";
    protected StreamTokenizer stok;
    protected String filename;
    private boolean ignoreCase;
    private char commentChar;
    private char quoteChar;

    public Parser(StreamTokenizer s) {
        this(s, EMPTY_STRING);
    }

    public Parser(StreamTokenizer s, String fname) {
        this.stok = s;
        this.quoteChar = (char)34;
        this.commentChar = (char)35;
        this.filename = fname;
        this.resetParserSettings();
    }

    @Override
    public char getChar() throws IOException, BadSyntaxException {
        this.stok.nextToken();
        if (this.stok.ttype == -3) {
            throw this.generateException("wrongTypeFound", new String[]{InteractionModule.translateMessage("charType"), InteractionModule.translateMessage("wordType")});
        }
        if (this.stok.ttype == -2) {
            throw this.generateException("wrongTypeFound", new String[]{InteractionModule.translateMessage("charType"), InteractionModule.translateMessage("numericType")});
        }
        if (this.stok.ttype == 10) {
            throw this.generateException("wrongTypeFound", new String[]{InteractionModule.translateMessage("charType"), InteractionModule.translateMessage("eolType")});
        }
        if (this.stok.ttype == -1) {
            throw this.generateException("wrongTypeFound", new String[]{InteractionModule.translateMessage("charType"), InteractionModule.translateMessage("eofType")});
        }
        return (char)this.stok.ttype;
    }

    public void setCommentChar(char comment) {
        this.commentChar = comment;
        this.resetParserSettings();
    }

    @Override
    public boolean getEOL() throws IOException, BadSyntaxException {
        this.stok.nextToken();
        if (this.stok.ttype == 13 && this.stok.ttype != 10) {
            this.stok.nextToken();
        }
        if (this.stok.ttype == 10 || this.stok.ttype == 13) {
            return true;
        }
        throw this.generateException("eolExpected");
    }

    @Override
    public boolean getEOX() throws IOException, BadSyntaxException {
        this.stok.nextToken();
        if (this.stok.ttype == 13 && this.stok.ttype != 10) {
            this.stok.nextToken();
        }
        if (this.stok.ttype == 10 || this.stok.ttype == 13) {
            return true;
        }
        if (this.stok.ttype == -1) {
            this.stok.pushBack();
            return true;
        }
        throw this.generateException("eolExpected");
    }

    public void setIgnoreCase(boolean tf) {
        this.ignoreCase = tf;
    }

    @Override
    public boolean getKeyword(String keyword) throws IOException, BadSyntaxException {
        this.stok.nextToken();
        if (this.stok.ttype == -3) {
            if (this.stok.sval.equals(keyword)) {
                return true;
            }
            if (this.stok.sval.equalsIgnoreCase(keyword) && this.ignoreCase) {
                return true;
            }
            throw this.generateException("keywordError", new String[]{keyword, this.stok.sval});
        }
        throw this.generateException("keywordError2");
    }

    @Override
    public int getNumber() throws IOException, BadSyntaxException {
        this.stok.nextToken();
        if (this.stok.ttype == -2) {
            return (int)this.stok.nval;
        }
        throw this.generateException("numberExpected");
    }

    @Override
    public char getOptionalChar() throws IOException {
        this.stok.nextToken();
        int token = this.stok.ttype;
        if (token == -3 || token == -2 || token == 10 || token == -1) {
            this.stok.pushBack();
            return '\u0000';
        }
        return (char)this.stok.ttype;
    }

    @Override
    public boolean getOptionalEOL() throws IOException {
        this.stok.nextToken();
        if (this.stok.ttype == 13 && this.stok.ttype != 10) {
            this.stok.nextToken();
        }
        if (this.stok.ttype == 10 || this.stok.ttype == 13) {
            return true;
        }
        this.stok.pushBack();
        return false;
    }

    @Override
    public boolean getOptionalEOX() throws IOException {
        this.stok.nextToken();
        if (this.stok.ttype == 13 && this.stok.ttype != 10) {
            this.stok.nextToken();
        }
        if (this.stok.ttype == -1 || this.stok.ttype == 13) {
            this.stok.pushBack();
            return true;
        }
        this.stok.pushBack();
        return false;
    }

    @Override
    public boolean getOptionalKeyword(String keyword) throws IOException {
        this.stok.nextToken();
        if (this.stok.ttype == -3) {
            if (this.stok.sval.equals(keyword)) {
                return true;
            }
            if (this.stok.sval.equalsIgnoreCase(keyword) && this.ignoreCase) {
                return true;
            }
            this.stok.pushBack();
            return false;
        }
        this.stok.pushBack();
        return false;
    }

    @Override
    public int getOptionalNumber() throws IOException {
        this.stok.nextToken();
        if (this.stok.ttype == -2) {
            return (int)this.stok.nval;
        }
        return -1;
    }

    @Override
    public String getOptionalQuoted() throws IOException, BadSyntaxException {
        String theString = EMPTY_STRING;
        this.stok.nextToken();
        if (this.stok.ttype == this.quoteChar) {
            this.setQuotedSettings();
            this.stok.nextToken();
            while (this.stok.ttype != this.quoteChar) {
                if (this.stok.ttype == -3) {
                    theString = String.valueOf(theString) + this.stok.sval;
                } else if (this.stok.ttype == -2) {
                    theString = String.valueOf(theString) + (int)this.stok.nval;
                } else {
                    if (this.stok.ttype == -1) {
                        throw this.generateException("endOfQuote");
                    }
                    theString = String.valueOf(theString) + (char)this.stok.ttype;
                }
                this.stok.nextToken();
            }
            this.resetParserSettings();
            return theString;
        }
        this.stok.pushBack();
        return EMPTY_STRING;
    }

    @Override
    public String getOptionalWhitespace() throws IOException {
        String whitespace = EMPTY_STRING;
        this.stok.nextToken();
        if (this.stok.ttype == 32 || this.stok.ttype == 9) {
            while (this.stok.ttype == 32 || this.stok.ttype == 9) {
                whitespace = String.valueOf(whitespace) + (char)this.stok.ttype;
                this.stok.nextToken();
            }
            this.stok.pushBack();
            return whitespace;
        }
        this.stok.pushBack();
        return EMPTY_STRING;
    }

    @Override
    public String getOptionalWord() throws IOException {
        this.stok.nextToken();
        if (this.stok.ttype == -3) {
            return this.stok.sval;
        }
        this.stok.pushBack();
        return EMPTY_STRING;
    }

    public void setQuoteChar(char quote) {
        this.quoteChar = quote;
    }

    @Override
    public String getQuoted() throws IOException, BadSyntaxException {
        String theString = EMPTY_STRING;
        this.stok.nextToken();
        if (this.stok.ttype == this.quoteChar) {
            this.setQuotedSettings();
            this.stok.nextToken();
            while (this.stok.ttype != this.quoteChar) {
                if (this.stok.ttype == -3) {
                    theString = String.valueOf(theString) + this.stok.sval;
                } else if (this.stok.ttype == -2) {
                    theString = String.valueOf(theString) + (int)this.stok.nval;
                } else if (this.stok.ttype == -1) {
                    this.generateException("endOfQuote");
                } else {
                    theString = String.valueOf(theString) + (char)this.stok.ttype;
                }
                this.stok.nextToken();
            }
            this.resetParserSettings();
            return theString;
        }
        throw this.generateException("quotedString");
    }

    public void setQuotedSettings() {
        this.resetParserSettings();
        this.stok.wordChars(48, 57);
    }

    @Override
    public String getWhitespace() throws IOException, BadSyntaxException {
        String whitespace = EMPTY_STRING;
        this.stok.nextToken();
        if (this.stok.ttype == 32 || this.stok.ttype == 9) {
            while (this.stok.ttype == 32 || this.stok.ttype == 9) {
                whitespace = String.valueOf(whitespace) + (char)this.stok.ttype;
                this.stok.nextToken();
            }
            this.stok.pushBack();
            return whitespace;
        }
        this.stok.pushBack();
        throw this.generateException("whitespaceExpected");
    }

    @Override
    public String getWord() throws IOException, BadSyntaxException {
        this.stok.nextToken();
        if (this.stok.ttype == -3) {
            return this.stok.sval;
        }
        throw this.generateException("numberExpected");
    }

    public void resetParserSettings() {
        this.stok.resetSyntax();
        this.stok.wordChars(97, 122);
        this.stok.wordChars(65, 90);
        this.stok.parseNumbers();
        this.stok.eolIsSignificant(true);
        this.stok.ordinaryChar(this.quoteChar);
        this.stok.commentChar(this.commentChar);
    }

    protected BadSyntaxException generateException(String key, Object[] params) {
        return this.generateException(key, params, true);
    }

    protected BadSyntaxException generateException(String key, Object[] params, boolean addLineNo) {
        if (!addLineNo || params == null) {
            return new BadSyntaxException(InteractionModule.translateMessage(key, params));
        }
        int nrElems = params.length;
        Object[] elements = new Object[nrElems + 2];
        System.arraycopy(params, 0, elements, 0, nrElems);
        elements[nrElems] = this.filename;
        elements[nrElems + 1] = String.valueOf(this.stok.lineno());
        return new BadSyntaxException(InteractionModule.translateMessage(key, elements));
    }

    protected BadSyntaxException generateException(String key) {
        return this.generateException(key, new String[]{this.filename, String.valueOf(this.stok.lineno())});
    }

    protected BadSyntaxException generateException(String key, String singleParam) {
        return this.generateException(key, new String[]{singleParam, this.filename, String.valueOf(this.stok.lineno())}, false);
    }
}

