/*
 * Decompiled with CFR 0.152.
 */
package avinteraction.parser;

import algoanim.interactionsupport.DocumentationLink;
import algoanim.interactionsupport.FillInBlanksQuestion;
import algoanim.interactionsupport.MultipleChoiceQuestion;
import algoanim.interactionsupport.MultipleSelectionQuestion;
import algoanim.interactionsupport.TrueFalseQuestion;
import algoanim.primitives.generators.Language;
import avinteraction.patterns.PatternParser;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InteractionFactory {
    private Language lang;
    private PatternParser parser;

    public InteractionFactory(Language l, String xmlFile) {
        this.lang = l;
        this.parser = new PatternParser("InteractionPatternsSchema.xsd", xmlFile);
    }

    public TrueFalseQuestion generateTFQuestion(String patternName, String instanceName, String ... placeholder) {
        String tmp = "";
        Element interaction = this.parser.getInteraction(patternName);
        if (interaction != null) {
            String name = interaction.getNodeName();
            if (name.equals("TFQuestion")) {
                TrueFalseQuestion tfQuestion = new TrueFalseQuestion(this.lang, instanceName);
                NodeList child = interaction.getElementsByTagName("prompt");
                tmp = this.replacePlaceholder(child.item(0).getFirstChild().getNodeValue(), placeholder);
                tfQuestion.setPrompt(tmp);
                child = interaction.getElementsByTagName("pointsPossible");
                tfQuestion.setPointsPossible(Integer.parseInt(child.item(0).getFirstChild().getNodeValue()));
                child = interaction.getElementsByTagName("group");
                tfQuestion.setQuestionGroup(child.item(0).getFirstChild().getNodeValue());
                child = interaction.getElementsByTagName("answerState");
                if (child.item(0).getFirstChild() != null) {
                    tfQuestion.setAnswerStatus(child.item(0).getFirstChild().getNodeValue().equals("true"));
                }
                if ((child = interaction.getElementsByTagName("commentTrue")).item(0).getFirstChild() != null) {
                    tmp = this.replacePlaceholder(child.item(0).getFirstChild().getNodeValue(), placeholder);
                    tfQuestion.setFeedbackForAnswer(true, tmp);
                }
                if ((child = interaction.getElementsByTagName("commentFalse")).item(0).getFirstChild() != null) {
                    tmp = this.replacePlaceholder(child.item(0).getFirstChild().getNodeValue(), placeholder);
                    tfQuestion.setFeedbackForAnswer(false, tmp);
                }
                this.lang.addTFQuestion(tfQuestion);
                this.lang.nextStep();
                return tfQuestion;
            }
            System.err.println("Pattern is not a TFQuestion");
            return null;
        }
        System.err.println("Interaction Pattern not found");
        return null;
    }

    public FillInBlanksQuestion generateFIBQuestion(String patternName, String instanceName, String ... placeholder) {
        String tmp = "";
        Element interaction = this.parser.getInteraction(patternName);
        if (interaction != null) {
            String name = interaction.getNodeName();
            if (name.equals("FIBQuestion")) {
                int points = 0;
                String answer = null;
                String comment = null;
                FillInBlanksQuestion fibQuestion = new FillInBlanksQuestion(this.lang, instanceName);
                NodeList child = interaction.getElementsByTagName("prompt");
                tmp = this.replacePlaceholder(child.item(0).getFirstChild().getNodeValue(), placeholder);
                fibQuestion.setPrompt(tmp);
                child = interaction.getElementsByTagName("group");
                fibQuestion.setQuestionGroup(child.item(0).getFirstChild().getNodeValue());
                child = interaction.getElementsByTagName("pointsPossible");
                if (child.item(0) != null) {
                    points = Integer.parseInt(child.item(0).getFirstChild().getNodeValue());
                }
                if ((child = interaction.getElementsByTagName("answer")).item(0).getFirstChild() != null) {
                    answer = tmp = this.replacePlaceholder(child.item(0).getFirstChild().getNodeValue(), placeholder);
                }
                if ((child = interaction.getElementsByTagName("comment")).item(0).getFirstChild() != null) {
                    comment = tmp = this.replacePlaceholder(child.item(0).getFirstChild().getNodeValue(), placeholder);
                }
                if (answer != null && comment != null) {
                    fibQuestion.addAnswer(answer, comment, points);
                }
                this.lang.addFIBQuestion(fibQuestion);
                this.lang.nextStep();
                return fibQuestion;
            }
            System.err.println("Pattern is not a FIBQuestion");
            return null;
        }
        System.err.println("Interaction Pattern not found");
        return null;
    }

    public MultipleChoiceQuestion generateMCQuestion(String patternName, String instanceName, String ... placeholder) {
        String tmp = "";
        Element interaction = this.parser.getInteraction(patternName);
        if (interaction != null) {
            String name = interaction.getNodeName();
            if (name.equals("MCQuestion")) {
                MultipleChoiceQuestion mcq = new MultipleChoiceQuestion(this.lang, instanceName);
                NodeList child = interaction.getElementsByTagName("prompt");
                tmp = this.replacePlaceholder(child.item(0).getFirstChild().getNodeValue(), placeholder);
                mcq.setPrompt(tmp);
                child = interaction.getElementsByTagName("group");
                mcq.setQuestionGroup(child.item(0).getFirstChild().getNodeValue());
                child = interaction.getElementsByTagName("pointsPossible");
                mcq.setPointsPossible(Integer.parseInt(child.item(0).getFirstChild().getNodeValue()));
                NodeList answers = interaction.getElementsByTagName("answer");
                int i = 0;
                while (i < answers.getLength()) {
                    child = ((Element)answers.item(i)).getElementsByTagName("text");
                    String text = this.replacePlaceholder(child.item(0).getFirstChild().getNodeValue(), placeholder);
                    child = ((Element)answers.item(i)).getElementsByTagName("points");
                    int points = Integer.parseInt(child.item(0).getFirstChild().getNodeValue());
                    child = ((Element)answers.item(i)).getElementsByTagName("comment");
                    String comment = this.replacePlaceholder(child.item(0).getFirstChild().getNodeValue(), placeholder);
                    child = ((Element)answers.item(i)).getElementsByTagName("state");
                    mcq.addAnswerOption(text, child.item(0).getFirstChild().getNodeValue().equals("true"), comment, points);
                    ++i;
                }
                this.lang.addMCQuestion(mcq);
                this.lang.nextStep();
                return mcq;
            }
            System.err.println("Pattern is not a MCQuestion");
            return null;
        }
        System.err.println("Interaction Pattern not found");
        return null;
    }

    public MultipleSelectionQuestion generateMSQuestion(String patternName, String instanceName, String ... placeholder) {
        String tmp = "";
        Element interaction = this.parser.getInteraction(patternName);
        if (interaction != null) {
            String name = interaction.getNodeName();
            if (name.equals("MSQuestion")) {
                MultipleSelectionQuestion msq = new MultipleSelectionQuestion(this.lang, instanceName);
                NodeList child = interaction.getElementsByTagName("prompt");
                tmp = this.replacePlaceholder(child.item(0).getFirstChild().getNodeValue(), placeholder);
                msq.setPrompt(tmp);
                child = interaction.getElementsByTagName("group");
                msq.setQuestionGroup(child.item(0).getFirstChild().getNodeValue());
                child = interaction.getElementsByTagName("pointsPossible");
                msq.setPointsPossible(Integer.parseInt(child.item(0).getFirstChild().getNodeValue()));
                NodeList answers = interaction.getElementsByTagName("answer");
                int i = 0;
                while (i < answers.getLength()) {
                    child = ((Element)answers.item(i)).getElementsByTagName("text");
                    String text = this.replacePlaceholder(child.item(0).getFirstChild().getNodeValue(), placeholder);
                    child = ((Element)answers.item(i)).getElementsByTagName("points");
                    int points = Integer.parseInt(child.item(0).getFirstChild().getNodeValue());
                    child = ((Element)answers.item(i)).getElementsByTagName("comment");
                    String comment = this.replacePlaceholder(child.item(0).getFirstChild().getNodeValue(), placeholder);
                    child = ((Element)answers.item(i)).getElementsByTagName("state");
                    msq.addAnswerOption(text, child.item(0).getFirstChild().getNodeValue().equals("true"), comment, points);
                    ++i;
                }
                this.lang.addMSQuestion(msq);
                this.lang.nextStep();
                return msq;
            }
            System.err.println("Pattern is not a MSQuestion");
            return null;
        }
        System.err.println("Interaction Pattern not found");
        return null;
    }

    public void generateDocumentation(String patternName, String instanceName, String ... placeholder) {
        Element interaction = this.parser.getInteraction(patternName);
        if (interaction != null) {
            String name = interaction.getNodeName();
            if (name.equals("Documentation")) {
                DocumentationLink link = new DocumentationLink(this.lang, instanceName);
                NodeList child = interaction.getElementsByTagName("URL");
                link.setLinkAddress(child.item(0).getFirstChild().getNodeValue());
                this.lang.addDocumentationLink(link);
                this.lang.nextStep();
                return;
            }
            System.err.println("Pattern is not a Documentation");
            return;
        }
        System.err.println("Interaction Pattern not found");
    }

    private String replacePlaceholder(String tmp, String[] placeholder) {
        String placeHolder = tmp;
        int index = -1;
        int pos = placeHolder.indexOf("{");
        String placeholderIndex = "";
        while (pos != -1) {
            placeholderIndex = placeHolder.substring(pos + 1, pos + 2);
            try {
                index = Integer.parseInt(placeholderIndex);
                if (index < placeholder.length) {
                    placeHolder = placeHolder.replace("{" + placeholderIndex + "}", placeholder[index]);
                } else {
                    System.err.println("There is no parameter given for the placeholder {" + index + "}");
                }
            }
            catch (NumberFormatException e) {
                System.err.println("{" + placeholderIndex + "} is not a valid placeholder");
            }
            pos = placeHolder.indexOf("{", pos + 2);
        }
        return placeHolder;
    }
}

