/*
 * Decompiled with CFR 0.152.
 */
package avinteraction;

import avinteraction.FIBQuestionInterface;
import avinteraction.InteractionModule;
import avinteraction.Question;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FIBQuestion
extends Question
implements FIBQuestionInterface,
ActionListener {
    private static final long serialVersionUID = 1158564530027926630L;
    protected JTextField answerInput;
    protected Vector<String> correctAnswers;
    private String theComment;

    public FIBQuestion(String id, String group) {
        this.objectID = id;
        this.groupID = group;
        this.correctAnswers = new Vector();
        this.questionText = "";
    }

    @Override
    public void setComment(String c) {
        this.theComment = c;
    }

    @Override
    public String getComment() {
        if (!this.correct) {
            return this.theComment;
        }
        return "";
    }

    @Override
    public void setQuestion(String question) {
        this.questionText = question;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int i = 0;
        this.achievedPoints = 0;
        this.correct = false;
        String answerFromBlank = this.answerInput.getText().trim();
        this.submitButton.setEnabled(false);
        while (!this.correct && i < this.correctAnswers.size()) {
            if (answerFromBlank.equalsIgnoreCase(this.correctAnswers.elementAt(i).trim())) {
                this.correct = true;
                this.achievedPoints = this.points;
            }
            ++i;
        }
        this.handler.processQuestion(this.objectID, this);
    }

    @Override
    public void addAnswer(String answer) {
        this.correctAnswers.addElement(answer.trim());
    }

    @Override
    public void makeGUI() {
        this.setLayout(new BorderLayout());
        ImageIcon fibIcon = new ImageIcon("FIBGraphic.gif");
        JLabel headlineLabel = new JLabel(fibIcon, 0);
        this.mainPanel = new JPanel(new GridLayout(4, 1, 5, 5));
        this.questionOutput = new JTextArea(this.questionText);
        this.questionOutput.setEditable(false);
        this.questionOutput.setWrapStyleWord(true);
        this.questionOutput.setLineWrap(true);
        JScrollPane questionScroller = new JScrollPane(this.questionOutput, 20, 31);
        this.answerInput = new JTextField();
        JPanel fieldPanel = new JPanel(new GridLayout(2, 1));
        fieldPanel.add(new JLabel(InteractionModule.translateMessage("enterHere")));
        fieldPanel.add(this.answerInput);
        this.mainPanel.add(questionScroller);
        this.mainPanel.add(fieldPanel);
        this.submitButton = new JButton(InteractionModule.translateMessage("submit"));
        this.submitButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.submitButton);
        this.setFeedback(InteractionModule.translateMessage("noAnswerYet"));
        this.setFeedbackRed();
        JPanel bottomPanel = new JPanel(new GridLayout(2, 1));
        bottomPanel.add(buttonPanel);
        this.mainPanel.add(bottomPanel);
        this.mainPanel.add(this.feedbackScroller);
        this.add("North", headlineLabel);
        this.add("Center", this.mainPanel);
        this.guiBuilt = true;
    }

    @Override
    public void rebuildQuestion() {
        this.answerInput.setText("");
        this.setFeedback("");
        this.submitButton.setEnabled(true);
    }
}

