/*
 * Decompiled with CFR 0.152.
 */
package animalscript.extensions;

import animal.misc.ColorChoice;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animalscript.core.AnimalParseSupport;
import animalscript.core.AnimalScriptInterface;
import animalscript.core.BasicParser;
import animalscript.extensions.GridProducer;
import animalscript.extensions.MatrixProducer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.regex.Pattern;

public class GridSupport
extends BasicParser
implements AnimalScriptInterface {
    static final Pattern cellIdentifierPattern = Pattern.compile("[a-zA-Z@_][a-zA-Z0-9@_]*\\s*\\[\\s*\\d*\\s*\\]\\s*\\[\\s*\\d*\\s*\\]");

    public static Color parseAndSetColorOrDefault(StreamTokenizer aStok, String objectType, String propertyName, Color defaultColor) throws IOException {
        if (ParseSupport.parseOptionalWord(aStok, String.valueOf(propertyName) + " tag for " + objectType, propertyName)) {
            int token = aStok.nextToken();
            aStok.pushBack();
            String colorName = null;
            if (token == -3) {
                colorName = ParseSupport.parseWord(aStok, String.valueOf(objectType) + ' ' + propertyName);
                if (colorName.equalsIgnoreCase("light")) {
                    colorName = String.valueOf(colorName) + " " + ParseSupport.parseWord(aStok, String.valueOf(objectType) + ' ' + propertyName);
                }
                if (colorName == null || !ColorChoice.validColorName(colorName)) {
                    colorName = null;
                    return null;
                }
            } else {
                Color targetColor = ParseSupport.parseColorRaw(aStok, propertyName);
                if (targetColor != null) {
                    colorName = ColorChoice.getColorName(targetColor);
                }
            }
            return ColorChoice.getColor(colorName);
        }
        return defaultColor;
    }

    public GridSupport() {
        this.handledKeywords = new Hashtable();
        this.handledKeywords.put("grid", "parseGridInput");
        this.handledKeywords.put("setgridvalue", "parseSetGridValue");
        this.handledKeywords.put("setgridfont", "parseSetGridFont");
        this.handledKeywords.put("setgridcolor", "parseSetGridColor");
        this.handledKeywords.put("swapgridvalues", "parseSwapGridValues");
        this.handledKeywords.put("highlightgridcell", "parseHighlightGridCell");
        this.handledKeywords.put("unhighlightgridcell", "parseUnhighlightGridCell");
        this.handledKeywords.put("aligngridvalue", "parseAlignGridValue");
    }

    private boolean validateCellIdentifier(String cellIdentifier) {
        return cellIdentifierPattern.matcher(cellIdentifier).matches();
    }

    private String extractNameFromCellIdentifier(String cellIdentifier) {
        return cellIdentifier.split("\\s*\\[\\s*\\d*\\s*\\]\\s*\\[\\s*\\d*\\s*\\]")[0];
    }

    private int[] extractLocationFromCellIdentifier(String cellIdentifier) {
        String[] coordinates = cellIdentifier.split("[a-zA-Z@_][a-zA-Z0-9@_]*");
        coordinates = coordinates[1].split("[\\]\\[]");
        int[] cell = new int[]{-1, -1};
        if (coordinates.length > 1 && !coordinates[1].trim().equals("")) {
            cell[0] = Integer.parseInt(coordinates[1].trim());
        }
        if (coordinates.length > 3 && !coordinates[3].trim().equals("")) {
            cell[1] = Integer.parseInt(coordinates[3].trim());
        }
        return cell;
    }

    @Override
    public boolean generateNewStep(String currentCommand) {
        return !sameStep;
    }

    public void parseGridInput() throws IOException {
        int cellWidth = -1;
        int maxCellWidth = -1;
        int cellHeight = -1;
        int maxCellHeight = -1;
        boolean fixedCellSize = false;
        Color genericColor = GridProducer.DEFAULT_COLOR;
        Color borderColor = GridProducer.DEFAULT_COLOR;
        Color textColor = GridProducer.DEFAULT_COLOR;
        Color fillColor = GridProducer.DEFAULT_COLOR;
        Color hTextColor = GridProducer.DEFAULT_COLOR;
        Color hFillColor = GridProducer.DEFAULT_COLOR;
        Color hBorderColor = GridProducer.DEFAULT_COLOR;
        int alignment = -1;
        int style = -1;
        int depth = -1;
        int delay = -1;
        int duration = -1;
        String unit = GridProducer.DEFAULT_UNIT;
        String first = ParseSupport.parseWord(stok, "type").toLowerCase();
        String gridName = AnimalParseSupport.parseText(stok, "Grid object name");
        String basicFeedbackTag = String.valueOf(first) + " '" + gridName + "' ";
        Point location = AnimalParseSupport.parseNodeInfo(stok, "location", null);
        ParseSupport.parseMandatoryWord(stok, String.valueOf(basicFeedbackTag) + "Keyword 'lines'", "lines");
        int nLines = ParseSupport.parseInt(stok, String.valueOf(basicFeedbackTag) + "#lines", 1);
        ParseSupport.parseMandatoryWord(stok, String.valueOf(basicFeedbackTag) + "Keyword 'columns'", "columns");
        int nCols = ParseSupport.parseInt(stok, String.valueOf(basicFeedbackTag) + "#columns", 1);
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "opt. Keyword 'style'", "style")) {
            String parsedStyle = ParseSupport.parseWord(stok, String.valueOf(basicFeedbackTag) + "'style'");
            if (parsedStyle.equalsIgnoreCase("plain")) {
                style = 0;
            } else if (parsedStyle.equalsIgnoreCase("matrix")) {
                style = 1;
            } else if (parsedStyle.equalsIgnoreCase("table")) {
                style = 2;
            } else {
                MessageDisplay.errorMsg("ParseError line " + stok.lineno() + ": Invalid value for attribute 'style':" + parsedStyle + "\n Valid styles are 'plain', 'matrix' or 'table'", 4);
            }
        }
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "opt. Keyword 'cellwidth'", "cellwidth")) {
            cellWidth = ParseSupport.parseInt(stok, String.valueOf(basicFeedbackTag) + "'cellWidth'", 1);
        }
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "opt. Keyword 'maxcellwidth'", "maxcellwidth")) {
            maxCellWidth = ParseSupport.parseInt(stok, String.valueOf(basicFeedbackTag) + "'maxcellwidth'", 0);
        }
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "opt. Keyword 'cellheight'", "cellheight")) {
            cellHeight = ParseSupport.parseInt(stok, String.valueOf(basicFeedbackTag) + "'cellHeight'", 1);
        }
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "opt. Keyword 'maxcellheight'", "maxcellheight")) {
            maxCellHeight = ParseSupport.parseInt(stok, String.valueOf(basicFeedbackTag) + "'maxcellheight'", 0);
        }
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "opt. Flag 'fixedcellsize'", "fixedcellsize")) {
            fixedCellSize = true;
        }
        genericColor = GridSupport.parseAndSetColorOrDefault(stok, gridName, "color", GridProducer.DEFAULT_COLOR);
        textColor = GridSupport.parseAndSetColorOrDefault(stok, gridName, "textcolor", GridProducer.DEFAULT_COLOR);
        fillColor = GridSupport.parseAndSetColorOrDefault(stok, gridName, "fillcolor", GridProducer.DEFAULT_COLOR);
        borderColor = GridSupport.parseAndSetColorOrDefault(stok, gridName, "bordercolor", GridProducer.DEFAULT_COLOR);
        hTextColor = GridSupport.parseAndSetColorOrDefault(stok, gridName, "highlightTextColor", GridProducer.DEFAULT_COLOR);
        hFillColor = GridSupport.parseAndSetColorOrDefault(stok, gridName, "highlightFillColor", GridProducer.DEFAULT_COLOR);
        hBorderColor = GridSupport.parseAndSetColorOrDefault(stok, gridName, "highlightBorderColor", GridProducer.DEFAULT_COLOR);
        Font font = AnimalParseSupport.parseFontInfo(stok, "opt. Keyword font");
        if (ParseSupport.parseOptionalWord(stok, "opt. Keyword 'alignment'", "align")) {
            String alignmentValue = ParseSupport.parseWord(stok, "Alignmentvalue");
            if (alignmentValue.equalsIgnoreCase("left")) {
                alignment = 110;
            } else if (alignmentValue.equalsIgnoreCase("right")) {
                alignment = 112;
            } else if (alignmentValue.equalsIgnoreCase("center")) {
                alignment = 111;
            } else {
                MessageDisplay.errorMsg("ParseError Invalid argument for alignment: " + alignment + "\n  should be 'left', 'center' or 'right'", 4);
                System.err.println("Invalid alignment: " + alignment + "\n  should be 'left', 'center' or 'right'");
                return;
            }
        }
        if (ParseSupport.parseOptionalWord(stok, "keyword 'depth'", "depth")) {
            depth = ParseSupport.parseInt(stok, "depth value", 2);
        }
        if (ParseSupport.parseOptionalWord(stok, "keyword 'after'", "after")) {
            delay = ParseSupport.parseInt(stok, "offset value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        if (ParseSupport.parseOptionalWord(stok, "keyword 'within'", "within")) {
            duration = ParseSupport.parseInt(stok, "duration value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        GridProducer.makeGrid(gridName, location, nLines, nCols, cellWidth, maxCellWidth, cellHeight, maxCellHeight, fixedCellSize, genericColor, textColor, fillColor, borderColor, hTextColor, hFillColor, hBorderColor, style, font, alignment, depth, delay, duration, unit);
    }

    public void parseSetGridValue() throws IOException {
        int duration = 0;
        int offset = 0;
        boolean refresh = false;
        String unit = "ticks";
        ParseSupport.parseWord(stok, "type").toLowerCase();
        String gridCell = ParseSupport.parseText(stok, "GridCell");
        String gridCellValue = AnimalParseSupport.parseText(stok, "GridCellValue");
        if (ParseSupport.parseOptionalWord(stok, "keyword 'refresh'", "refresh")) {
            refresh = true;
        }
        if (ParseSupport.parseOptionalWord(stok, "keyword 'after'", "after")) {
            offset = ParseSupport.parseInt(stok, "offset value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        if (ParseSupport.parseOptionalWord(stok, "keyword 'within'", "within")) {
            duration = ParseSupport.parseInt(stok, "offset value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        if (this.validateCellIdentifier(gridCell)) {
            String gridName = this.extractNameFromCellIdentifier(gridCell);
            int[] cell = this.extractLocationFromCellIdentifier(gridCell);
            GridProducer.setGridValue(gridName, cell[0], cell[1], gridCellValue, currentStep, duration, offset, unit, refresh);
        } else {
            MessageDisplay.errorMsg("ParseError line " + stok.lineno() + ": setGridValue, Invalid Gridcell: " + gridCell + "\n  should be like \"gridcell[1][1]\"", 4);
        }
    }

    public void parseSetGridColor() throws IOException {
        int duration = 0;
        int offset = 0;
        String unit = "ticks";
        Color genericColor = GridProducer.DEFAULT_COLOR;
        Color borderColor = GridProducer.DEFAULT_COLOR;
        Color textColor = GridProducer.DEFAULT_COLOR;
        Color fillColor = GridProducer.DEFAULT_COLOR;
        Color highlightTextColor = GridProducer.DEFAULT_COLOR;
        Color highlightFillColor = GridProducer.DEFAULT_COLOR;
        Color highlightBorderColor = GridProducer.DEFAULT_COLOR;
        ParseSupport.parseWord(stok, "type").toLowerCase();
        String gridCell = ParseSupport.parseText(stok, "GridCell");
        genericColor = GridSupport.parseAndSetColorOrDefault(stok, gridCell, "color", GridProducer.DEFAULT_COLOR);
        textColor = GridSupport.parseAndSetColorOrDefault(stok, gridCell, "textcolor", GridProducer.DEFAULT_COLOR);
        fillColor = GridSupport.parseAndSetColorOrDefault(stok, gridCell, "fillcolor", GridProducer.DEFAULT_COLOR);
        borderColor = GridSupport.parseAndSetColorOrDefault(stok, gridCell, "bordercolor", GridProducer.DEFAULT_COLOR);
        highlightTextColor = GridSupport.parseAndSetColorOrDefault(stok, gridCell, "highlightTextColor", GridProducer.DEFAULT_COLOR);
        highlightFillColor = GridSupport.parseAndSetColorOrDefault(stok, gridCell, "highlightFillColor", GridProducer.DEFAULT_COLOR);
        highlightBorderColor = GridSupport.parseAndSetColorOrDefault(stok, gridCell, "highlightBorderColor", GridProducer.DEFAULT_COLOR);
        if (ParseSupport.parseOptionalWord(stok, "keyword 'after'", "after")) {
            offset = ParseSupport.parseInt(stok, "offset value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        if (ParseSupport.parseOptionalWord(stok, "keyword 'within'", "within")) {
            duration = ParseSupport.parseInt(stok, "offset value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        if (this.validateCellIdentifier(gridCell)) {
            String gridName = this.extractNameFromCellIdentifier(gridCell);
            int[] cell = this.extractLocationFromCellIdentifier(gridCell);
            MatrixProducer.setGridColor(gridName, cell[0], cell[1], genericColor, textColor, fillColor, borderColor, highlightTextColor, highlightFillColor, highlightBorderColor, currentStep, duration, offset, unit);
        } else {
            MessageDisplay.errorMsg("ParseError line " + stok.lineno() + ": setGridValue, Invalid Gridcell: " + gridCell + "\n  should be like \"gridcell[1][1]\"", 4);
        }
    }

    public void parseSwapGridValues() throws IOException {
        int duration = 0;
        int offset = 0;
        boolean refresh = false;
        String unit = "ticks";
        ParseSupport.parseWord(stok, "type").toLowerCase();
        String cellID1 = AnimalParseSupport.parseText(stok, "Gridcell");
        ParseSupport.parseMandatoryWord(stok, "fill word 'and'", "and");
        String cellID2 = AnimalParseSupport.parseText(stok, "Gridcell");
        if (ParseSupport.parseOptionalWord(stok, "keyword 'refresh'", "refresh")) {
            refresh = true;
        }
        if (ParseSupport.parseOptionalWord(stok, "keyword 'after'", "after")) {
            offset = ParseSupport.parseInt(stok, "offset value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        if (ParseSupport.parseOptionalWord(stok, "keyword 'within'", "within")) {
            duration = ParseSupport.parseInt(stok, "offset value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        if (this.validateCellIdentifier(cellID1) && this.validateCellIdentifier(cellID2)) {
            String gridName1 = this.extractNameFromCellIdentifier(cellID1);
            String gridName2 = this.extractNameFromCellIdentifier(cellID2);
            int[] location1 = this.extractLocationFromCellIdentifier(cellID1);
            int[] location2 = this.extractLocationFromCellIdentifier(cellID2);
            GridProducer.swapGridValues(gridName1, location1[0], location1[1], gridName2, location2[0], location2[1], currentStep, duration, offset, unit, refresh);
        } else {
            MessageDisplay.errorMsg("ParseError line " + stok.lineno() + ": swapGridValues, invalid Gridcell: " + cellID1 + " and " + cellID2 + "\n  should be like \"gridcell[1][1]\"", 4);
        }
    }

    public void parseHighlightGridElem() throws IOException {
        int duration = 0;
        int offset = 0;
        String unit = "ticks";
        ParseSupport.parseWord(stok, "type").toLowerCase();
        String gridElem = AnimalParseSupport.parseText(stok, "GridElem");
        if (ParseSupport.parseOptionalWord(stok, "keyword 'after'", "after")) {
            offset = ParseSupport.parseInt(stok, "offset value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        if (ParseSupport.parseOptionalWord(stok, "keyword 'within'", "within")) {
            duration = ParseSupport.parseInt(stok, "offset value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        if (this.validateCellIdentifier(gridElem)) {
            String gridName = this.extractNameFromCellIdentifier(gridElem);
            int[] cell = this.extractLocationFromCellIdentifier(gridElem);
            GridProducer.highlightGridElem(gridName, cell[0], cell[1], currentStep, duration, offset, unit);
        } else {
            MessageDisplay.errorMsg("ParseError line " + stok.lineno() + ": Invalid GridElem: " + gridElem + "\n  should be like gridElem[1][1]", 4);
        }
    }

    public void parseHighlightGridCell() throws IOException {
        int duration = 0;
        int offset = 0;
        String unit = "ticks";
        ParseSupport.parseWord(stok, "type").toLowerCase();
        String gridCell = AnimalParseSupport.parseText(stok, "GridCell");
        if (ParseSupport.parseOptionalWord(stok, "keyword 'after'", "after")) {
            offset = ParseSupport.parseInt(stok, "offset value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        if (ParseSupport.parseOptionalWord(stok, "keyword 'within'", "within")) {
            duration = ParseSupport.parseInt(stok, "offset value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        if (this.validateCellIdentifier(gridCell)) {
            String gridName = this.extractNameFromCellIdentifier(gridCell);
            int[] cell = this.extractLocationFromCellIdentifier(gridCell);
            GridProducer.highlightGridCell(gridName, cell[0], cell[1], currentStep, duration, offset, unit);
        } else {
            MessageDisplay.errorMsg("ParseError line " + stok.lineno() + ": Invalid Gridcell: " + gridCell + "\n  should be like gridcell[1][1]", 4);
        }
    }

    public void parseUnhighlightGridCell() throws IOException {
        int duration = 0;
        int offset = 0;
        String unit = "ticks";
        ParseSupport.parseWord(stok, "type").toLowerCase();
        String gridCell = AnimalParseSupport.parseText(stok, "GridCell");
        if (ParseSupport.parseOptionalWord(stok, "keyword 'after'", "after")) {
            offset = ParseSupport.parseInt(stok, "offset value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        if (ParseSupport.parseOptionalWord(stok, "keyword 'within'", "within")) {
            duration = ParseSupport.parseInt(stok, "offset value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        if (this.validateCellIdentifier(gridCell)) {
            String gridName = this.extractNameFromCellIdentifier(gridCell);
            int[] cell = this.extractLocationFromCellIdentifier(gridCell);
            GridProducer.unhighlightGridCell(gridName, cell[0], cell[1], currentStep, duration, offset, unit);
        } else {
            MessageDisplay.errorMsg("ParseError line " + stok.lineno() + ": Invalid Gridcell: " + gridCell + "\n  should be like gridcell[1][1]", 4);
        }
    }

    public void parseAlignGridValue() throws IOException {
        int alignment = -1;
        int duration = 0;
        int offset = 0;
        String unit = "ticks";
        ParseSupport.parseWord(stok, "type").toLowerCase();
        String gridCell = AnimalParseSupport.parseText(stok, "GridCell");
        String align = ParseSupport.parseWord(stok, "alignment").toLowerCase();
        if (ParseSupport.parseOptionalWord(stok, "keyword 'after'", "after")) {
            offset = ParseSupport.parseInt(stok, "offset value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        if (ParseSupport.parseOptionalWord(stok, "keyword 'within'", "within")) {
            duration = ParseSupport.parseInt(stok, "offset value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        if (this.validateCellIdentifier(gridCell)) {
            String gridName = this.extractNameFromCellIdentifier(gridCell);
            int[] cell = this.extractLocationFromCellIdentifier(gridCell);
            if (align.equalsIgnoreCase("left")) {
                alignment = 110;
            } else if (align.equalsIgnoreCase("center")) {
                alignment = 111;
            } else if (align.equalsIgnoreCase("right")) {
                alignment = 112;
            } else {
                MessageDisplay.errorMsg("ParseError Invalid argument for alignment: " + align + "\n  should be 'left', 'center' or 'right'", 4);
                System.err.println("Invalid alignment: " + align + "\n  should be 'left', 'center' or 'right'");
                return;
            }
            GridProducer.alignGridValue(gridName, cell[0], cell[1], alignment, currentStep, duration, offset, unit);
        } else {
            MessageDisplay.errorMsg("ParseError line " + stok.lineno() + ": Invalid Gridcell: " + gridCell + "\n  should be like gridcell[1][1]", 4);
        }
    }

    public void parseSetGridFont() throws IOException {
        int duration = 0;
        int offset = 0;
        String unit = "ticks";
        boolean refresh = false;
        ParseSupport.parseWord(stok, "type").toLowerCase();
        String gridCell = AnimalParseSupport.parseText(stok, "GridCell");
        Font newFont = AnimalParseSupport.parseFontInfo(stok, "Gridcell");
        if (ParseSupport.parseOptionalWord(stok, "keyword 'refresh'", "refresh")) {
            refresh = true;
        }
        if (ParseSupport.parseOptionalWord(stok, "keyword 'after'", "after")) {
            offset = ParseSupport.parseInt(stok, "offset value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        if (ParseSupport.parseOptionalWord(stok, "keyword 'within'", "within")) {
            duration = ParseSupport.parseInt(stok, "offset value", 0);
            unit = ParseSupport.parseWord(stok, "unit");
        }
        if (this.validateCellIdentifier(gridCell)) {
            String gridName = this.extractNameFromCellIdentifier(gridCell);
            int[] cell = this.extractLocationFromCellIdentifier(gridCell);
            GridProducer.setGridFont(gridName, cell[0], cell[1], newFont, currentStep, duration, offset, unit, refresh);
        } else {
            MessageDisplay.errorMsg("ParseError line " + stok.lineno() + ": Invalid Gridcell: " + gridCell + "\n  should be like gridcell[1][1]", 4);
        }
    }
}

