/*
 * Decompiled with CFR 0.152.
 */
package animalscript.core;

import animal.animator.ColorChanger;
import animal.animator.Move;
import animal.animator.MoveBase;
import animal.animator.Rotate;
import animal.animator.TimedShow;
import animal.graphics.PTArc;
import animal.graphics.PTBoxPointer;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.AnimalParseSupport;
import animalscript.core.AnimalScriptInterface;
import animalscript.core.BasicParser;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class BaseAnimatorParser
extends BasicParser
implements AnimalScriptInterface {
    public BaseAnimatorParser() {
        this.handledKeywords = new Hashtable();
        this.rulesHash = new XProperties();
        this.handledKeywords.put("clone", "parseCloning");
        this.rulesHash.put("clone", "# object 'id' is cloned as 'newID' at the chosen position\n# (default: point of origin) and using the timing given.");
        this.handledKeywords.put("color", "parseColorChange");
        this.handledKeywords.put("fillcolor", "parseColorChange");
        this.rulesHash.put("color", "# change the color of the object(s) to 'colorname'\n# using the timing info and the optional type");
        this.handledKeywords.put("setlink", "parseListOperation");
        this.rulesHash.put("setlink", "# set the link of the object to the target list element");
        this.handledKeywords.put("clearlink", "parseListOperation");
        this.rulesHash.put("clearlink", "# reset the pointer of the target object to null");
        this.handledKeywords.put("move", "parseMove");
        this.handledKeywords.put("translate", "parseMove");
        this.handledKeywords.put("jump", "parseMove");
        this.rulesHash.put("move", "# move the object(s) by move method 'subtype' using the timing...: \n# * move along the 'via' object, must be arc / polyline\n# * move along a line of the given nodes\n# * move along arc nodes: center, radius x, radius y, start / end angle\n# * move along circle: center, radius, start / end angle\n# * set target position to given node\n# * move to target position");
        this.rulesHash.put("translate", "# see rule for 'move'");
        this.rulesHash.put("jump", "# see rule for 'move'");
        this.handledKeywords.put("rotate", "parseRotate");
        this.rulesHash.put("rotate", "# rotate object(s) around the given center; must be a point,\n# * or rotate object(s) around center node by given degrees");
        this.handledKeywords.put("show", "parseShowHide");
        this.rulesHash.put("show", "# show object(s) using timing");
        this.handledKeywords.put("hide", "parseShowHide");
        this.rulesHash.put("hide", "# hide object(s) using timing");
        this.handledKeywords.put("hideall", "parseShowHide");
        this.rulesHash.put("hideall", "# hide all objects using timing");
        this.handledKeywords.put("hideallbut", "parseShowHide");
        this.rulesHash.put("hideallbut", "# hide all objects except the given ID(s)using timing");
        this.rulesHash.put("timing", "# operate after the given offset; operation takes time given after 'within'");
    }

    @Override
    public boolean generateNewStep(String command) {
        return !sameStep;
    }

    public void parseCloning() throws IOException {
        ParseSupport.parseMandatoryWord(stok, "clone keyword 'clone'", "clone");
        String originalObject = AnimalParseSupport.parseText(stok, "Clone base object name");
        int[] targetOIDs = BaseAnimatorParser.getObjectIDs().getIntArrayProperty(originalObject);
        StringBuilder cloneIDs = new StringBuilder(targetOIDs.length << 3);
        ParseSupport.parseMandatoryWord(stok, "clone keyword 'as'", "as");
        String targetName = AnimalParseSupport.parseText(stok, "clone target name");
        PTGraphicObject orig = animState.getCloneByNum(targetOIDs[0]);
        PTGraphicObject go = null;
        Point basePoint = orig.getBoundingBox().getLocation();
        BaseAnimatorParser.getObjectProperties().put("Polyline.lastNode", basePoint);
        ParseSupport.parseOptionalWord(stok, "clone target location keyword 'at'", "at");
        Point targetPoint = AnimalParseSupport.parseNodeInfo(stok, "target location for cloned objects", null);
        if (currentNodeMode != 4) {
            targetPoint = new Point(targetPoint.x - basePoint.x, targetPoint.y - basePoint.y);
        }
        String localTargetName = targetName;
        int i = 0;
        while (i < targetOIDs.length) {
            orig = animState.getCloneByNum(targetOIDs[i]);
            go = (PTGraphicObject)orig.clone();
            go.clonePropertiesFrom(orig.getProperties(), true);
            if (go != null) {
                go.resetNum();
                go.translate(targetPoint.x, targetPoint.y);
                cloneIDs.append(go.getNum(true)).append(" ");
                localTargetName = i > 0 ? String.valueOf(orig.getObjectName()) + ".clone" : targetName;
                go.setObjectName(localTargetName);
                BaseAnimatorParser.getObjectIDs().put(localTargetName, go.getNum(false));
                BasicParser.addGraphicObject(go, anim);
            }
            ++i;
        }
        BaseAnimatorParser.getObjectIDs().put(targetName, cloneIDs.toString());
        AnimalParseSupport.showComponents(stok, cloneIDs.toString(), "clone", true);
    }

    public void parseColorChange() throws IOException {
        String colorType = ParseSupport.parseWord(stok, "color change operation");
        ColorChanger colChanger = null;
        Color c = null;
        int[] targetOIDs = ParseSupport.parseOIDNames(stok, BaseAnimatorParser.getObjectIDs(), anim.getNextGraphicObjectNum());
        if (colorType.equals("color")) {
            colorType = AnimalParseSupport.parseMethod(stok, "color change", "type", "color");
        }
        c = AnimalParseSupport.parseColor(stok, String.valueOf(colorType) + " animator");
        colChanger = new ColorChanger(currentStep, targetOIDs, 0, colorType, c);
        AnimalParseSupport.parseTiming(stok, colChanger, "Color");
        BasicParser.addAnimatorToAnimation(colChanger, anim);
    }

    public void parseListOperation() throws IOException {
        String localType = ParseSupport.parseWord(stok, "list operation keyword");
        String targetIDName = AnimalParseSupport.parseText(stok, "index marker name");
        int[] targetOIDs = BaseAnimatorParser.getObjectIDs().getIntArrayProperty(targetIDName);
        PTPolyline moveLine = null;
        PTGraphicObject ptgo = animState.getCloneByNum(targetOIDs[0]);
        int ptrNr = 1;
        boolean pointerNumberGiven = false;
        if (ParseSupport.parseOptionalWord(stok, "link nr.", "link")) {
            ptrNr = ParseSupport.parseInt(stok, "link nr", 1, ((PTBoxPointer)ptgo).getPointerCount());
            pointerNumberGiven = true;
        }
        Point currentPoint = ((PTBoxPointer)ptgo).getTip(ptrNr - 1);
        Point[] movePoints = new Point[2];
        int[] oid = new int[]{ptgo.getNum(false)};
        movePoints[0] = currentPoint;
        if (localType.equalsIgnoreCase("setLink")) {
            if (ParseSupport.parseOptionalWord(stok, "index marker keyword 'to'", "to")) {
                String targetElement = AnimalParseSupport.parseText(stok, "target list element");
                int targetID = BaseAnimatorParser.getObjectIDs().getIntProperty(targetElement);
                PTGraphicObject targetObject = animState.getCloneByNum(targetID);
                Rectangle boundingBox = ((PTBoxPointer)targetObject).getBoundingBoxWithoutPointers();
                Rectangle firstBBox = ((PTBoxPointer)ptgo).getBoundingBoxWithoutPointers();
                movePoints[1] = firstBBox.x < boundingBox.x ? new Point(boundingBox.x, ((PTBoxPointer)targetObject).getTipOrigin((int)(ptrNr - 1)).y) : new Point(boundingBox.x + boundingBox.width, ((PTBoxPointer)targetObject).getTipOrigin((int)(ptrNr - 1)).y);
            } else {
                movePoints[1] = AnimalParseSupport.parseNodeInfo(stok, "list pointer target location", null);
            }
        } else if (localType.equalsIgnoreCase("clearLink")) {
            Rectangle boundingBox = ((PTBoxPointer)ptgo).getBoundingBoxWithoutPointers();
            movePoints[1] = new Point(boundingBox.x + (ptrNr % 2 == 1 ? boundingBox.width - 5 : 5), ((PTBoxPointer)ptgo).getTipOrigin((int)0).y);
        }
        moveLine = new PTPolyline(movePoints);
        moveLine.setObjectName("moveLine4");
        BaseAnimatorParser.getObjectTypes().put(moveLine, (Object)BaseAnimatorParser.getTypeIdentifier("polyline"));
        BasicParser.addGraphicObject(moveLine, anim);
        int moveBaseNum = moveLine.getNum(false);
        String methodName = pointerNumberGiven ? "setTip #" + ptrNr : "setTip";
        Move move = new Move(currentStep, oid, 0, methodName, moveBaseNum);
        AnimalParseSupport.parseTiming(stok, move, "List element link");
        BasicParser.addAnimatorToAnimation(move, anim);
    }

    public void parseMove() throws IOException {
        String direction;
        int dir;
        String localType = ParseSupport.parseWord(stok, "move subtype");
        int[] targetOIDs = ParseSupport.parseOIDNames(stok, BaseAnimatorParser.getObjectIDs(), anim.getNextGraphicObjectNum());
        int moveBaseNum = -1;
        int i = 0;
        boolean moveAlongArc = false;
        boolean moveViaMode = false;
        PTGraphicObject ptgo = null;
        PTGraphicObject moveLine = null;
        if (ParseSupport.parseOptionalWord(stok, "Move keyword 'corner'", "corner") && (dir = compass.getIntProperty(direction = ParseSupport.parseWord(stok, "move border coordinate").toLowerCase())) == -1) {
            MessageDisplay.errorMsg("Invalid offset direction in line " + stok.lineno() + " changed to 'CENTER'", 4);
            dir = 8;
        }
        String methodName = AnimalParseSupport.parseMethod(stok, "move type", "type", "translate");
        if (ParseSupport.parseOptionalWord(stok, "Move keyword 'via'", "via")) {
            moveViaMode = true;
            String s = AnimalParseSupport.parseText(stok, "OID to move along");
            moveBaseNum = BaseAnimatorParser.getObjectIDs().getIntProperty(s, -1);
            if (moveBaseNum > -1) {
                ptgo = animState.getCloneByNum(moveBaseNum);
            }
            if (moveBaseNum == -1 || ptgo == null || !(ptgo instanceof MoveBase)) {
                throw new IOException("OID for move path not found in line " + stok.lineno());
            }
        } else {
            Point targetPoint;
            if (ParseSupport.parseOptionalWord(stok, "Move keyword 'along'", "along")) {
                moveAlongArc = ParseSupport.parseOptionalWord(stok, "Move keyword 'along arc'", "arc") || ParseSupport.parseOptionalWord(stok, "Move keyword 'along ellipse'", "ellipse") || ParseSupport.parseOptionalWord(stok, "Move keyword 'along ellipseseg'", "ellipseseg") || ParseSupport.parseOptionalWord(stok, "Move keyword 'along ellipseseg'", "ellipsesegment") || ParseSupport.parseOptionalWord(stok, "Move keyword 'along circle'", "circle") || ParseSupport.parseOptionalWord(stok, "Move keyword 'along circleseg'", "circleseg") || ParseSupport.parseOptionalWord(stok, "Move keyword 'along circlesegment'", "circlesegment");
                String localtype = null;
                if (!moveAlongArc && BaseAnimatorParser.stok.ttype == 40) {
                    localType = "line";
                } else {
                    localtype = BaseAnimatorParser.stok.sval.toLowerCase();
                }
                if (moveAlongArc) {
                    int xRadius = 0;
                    int yRadius = 0;
                    Point center = AnimalParseSupport.parseNodeInfo(stok, "first arc move point", null);
                    xRadius = ParseSupport.parseInt(stok, String.valueOf(localType) + " x radius <int>", 1);
                    moveLine = new PTArc();
                    ((PTArc)moveLine).setCenter(center);
                    if (localtype.equals("circle") || localtype.equals("circleseg")) {
                        ((PTArc)moveLine).setRadius(xRadius);
                        ((PTArc)moveLine).setCircle(true);
                    } else {
                        ((PTArc)moveLine).setXRadius(xRadius);
                        yRadius = ParseSupport.parseInt(stok, String.valueOf(localType) + " y radius <int>");
                        ((PTArc)moveLine).setYRadius(yRadius);
                        ((PTArc)moveLine).setCircle(false);
                    }
                    int startAngle = ParseSupport.parseInt(stok, String.valueOf(localType) + " start angle <int>");
                    ((PTArc)moveLine).setStartAngle(startAngle);
                    int arcAngle = ParseSupport.parseInt(stok, String.valueOf(localType) + " end angle <int>");
                    ((PTArc)moveLine).setTotalAngle(arcAngle);
                } else {
                    ParseSupport.parseOptionalWord(stok, "move keyword 'line/polyline'", "line");
                    ParseSupport.parseOptionalWord(stok, "move keyword 'line/polyline'", "polyline");
                    moveLine = new PTPolyline();
                    while (stok.nextToken() == 40) {
                        stok.pushBack();
                        ((PTPolyline)moveLine).addNode(new PTPoint(AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + " node " + ++i, null)));
                    }
                    stok.pushBack();
                }
            } else if (ParseSupport.parseOptionalWord(stok, "Move keyword 'to'", "to")) {
                targetPoint = AnimalParseSupport.parseNodeInfo(stok, "move destination", null);
                animState.setStep(currentStep - 1, false);
                PTGraphicObject targetObject = animState.getCloneByNum(targetOIDs[0]);
                Rectangle boundingBox = targetObject.getBoundingBox();
                int[] targetXCoords = new int[]{boundingBox.x, targetPoint.x};
                int[] targetYCoords = new int[]{boundingBox.y, targetPoint.y};
                int minX = Integer.MAX_VALUE;
                int minY = Integer.MAX_VALUE;
                i = 0;
                while (i < targetOIDs.length) {
                    ptgo = animState.getCloneByNum(targetOIDs[i]);
                    if (ptgo != null) {
                        Rectangle r = ptgo.getBoundingBox();
                        if (minX > r.x) {
                            minX = r.x;
                        }
                        if (minY > r.y) {
                            minY = r.y;
                        }
                    }
                    targetXCoords[0] = minX;
                    targetYCoords[0] = minY;
                    ++i;
                }
                moveLine = new PTPolyline(targetXCoords, targetYCoords);
            } else {
                targetPoint = AnimalParseSupport.parseStartPosition(stok, "move");
                Rectangle currentBB = animState.getCloneByNum(targetOIDs[0]).getBoundingBox();
                int[] xCoords = new int[]{currentBB.x, targetPoint.x};
                int[] yCoords = new int[]{currentBB.y, targetPoint.y};
                moveLine = new PTPolyline(xCoords, yCoords);
            }
            if (!moveViaMode) {
                moveLine.setObjectName("moveLine");
                BasicParser.addGraphicObject(moveLine, anim);
                moveBaseNum = moveLine.getNum(false);
            }
            BaseAnimatorParser.getObjectIDs().put("tmpPoint" + moveBaseNum, moveBaseNum);
            BaseAnimatorParser.getObjectTypes().put("tmpPoint" + moveBaseNum, BaseAnimatorParser.getTypeIdentifier("polyline"));
        }
        Move move = new Move(currentStep, targetOIDs, 0, methodName, moveBaseNum);
        AnimalParseSupport.parseTiming(stok, move, "Move");
        if (localType.equalsIgnoreCase("jump") && move.getDuration() != 0) {
            MessageDisplay.message("'jump' can not have a duration - use 'move' instead in line " + stok.lineno());
            move.setDuration(0);
        }
        BasicParser.addAnimatorToAnimation(move, anim);
    }

    public void parseRotate() throws IOException {
        String rotationType = ParseSupport.parseWord(stok, "rotation operation");
        int centerID = 0;
        int degrees = 360;
        int[] targetOIDs = ParseSupport.parseOIDNames(stok, BaseAnimatorParser.getObjectIDs(), anim.getNextGraphicObjectNum());
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(rotationType) + " keyword 'around'", "around")) {
            String centerPointName = AnimalParseSupport.parseText(stok, String.valueOf(rotationType) + " center point");
            centerID = BaseAnimatorParser.getObjectIDs().getIntProperty(centerPointName, -1);
            if (centerID == -1 || !(animState.getCloneByNum(centerID) instanceof PTPoint)) {
                ParseSupport.formatException("Rotation center point '" + centerPointName + "' " + (centerID == -1 ? "does not exist" : "is no point"), stok);
            }
        } else if (ParseSupport.parseOptionalWord(stok, String.valueOf(rotationType) + " keyword 'center'", "center")) {
            PTPoint p = new PTPoint(AnimalParseSupport.parseNodeInfo(stok, String.valueOf(rotationType) + " center node", null));
            BasicParser.addGraphicObject(p, anim);
            centerID = p.getNum(false);
        } else {
            ParseSupport.formatException("Unknow command for rotation.", stok);
        }
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(rotationType) + " keyword 'degrees'", "degrees")) {
            degrees = ParseSupport.parseInt(stok, String.valueOf(rotationType) + " degrees");
        }
        Rotate rotation = new Rotate(currentStep, targetOIDs, 0, centerID, degrees);
        AnimalParseSupport.parseTiming(stok, rotation, rotationType);
        BasicParser.addAnimatorToAnimation(rotation, anim);
    }

    public void parseShowHide() throws IOException {
        String value;
        Enumeration<String> e;
        StringBuilder sb;
        String localType = ParseSupport.parseWord(stok, "show/hide type");
        boolean isShow = localType.equalsIgnoreCase("show");
        int[] ids = null;
        if (localType.equalsIgnoreCase("hideAll")) {
            sb = new StringBuilder(300);
            e = BaseAnimatorParser.getCurrentlyVisible().keys();
            while (e.hasMoreElements()) {
                value = e.nextElement();
                if (!"true".equalsIgnoreCase(BaseAnimatorParser.getCurrentlyVisible().get(value))) continue;
                sb.append(' ').append(value);
            }
            ids = ParseSupport.parseOIDsFromString(sb.toString());
            sb = null;
        } else {
            ids = ParseSupport.parseOIDNames(stok, BaseAnimatorParser.getObjectIDs(), anim.getNextGraphicObjectNum());
        }
        if (localType.equalsIgnoreCase("hideAllBut")) {
            sb = new StringBuilder(300);
            e = BaseAnimatorParser.getCurrentlyVisible().keys();
            while (e.hasMoreElements()) {
                value = e.nextElement();
                int elemNr = new Integer(value);
                if (!"true".equalsIgnoreCase(BaseAnimatorParser.getCurrentlyVisible().get(value)) || this.includedIn(elemNr, ids)) continue;
                sb.append(' ').append(value);
            }
            ids = ParseSupport.parseOIDsFromString(sb.toString());
            sb = null;
        }
        String methodName = AnimalParseSupport.parseMethod(stok, String.valueOf(localType) + " type", "type", localType.toLowerCase());
        if (localType.equalsIgnoreCase("hideAll") && localType.equalsIgnoreCase(methodName)) {
            methodName = "hide";
        }
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " 'after' keyword", "after")) {
            stok.pushBack();
            TimedShow ts = new TimedShow(currentStep, ids, 0, methodName, isShow);
            AnimalParseSupport.parseTiming(stok, ts, "Timed Show");
            BasicParser.addAnimatorToAnimation(ts, anim);
        } else {
            TimedShow showAnimator = new TimedShow(currentStep, ids, 0, methodName, isShow);
            BasicParser.addAnimatorToAnimation(showAnimator, anim);
        }
        int i = 0;
        while (i < ids.length) {
            BaseAnimatorParser.getCurrentlyVisible().put(String.valueOf(ids[i]), String.valueOf(isShow));
            ++i;
        }
    }

    public boolean includedIn(int value, int[] array) {
        if (array == null || array.length == 0) {
            return false;
        }
        int i = 0;
        while (i < array.length && value != array[i]) {
            ++i;
        }
        return i < array.length;
    }
}

