/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

public class PageLoader
extends Component
implements Runnable {
    private static final long serialVersionUID = 5461026355920719407L;
    private Cursor cursor;
    private JEditorPane editorPane;
    private URL url;

    public PageLoader(URL u, Cursor c, JEditorPane htmlPane) {
        this.url = u;
        this.cursor = c;
        this.editorPane = htmlPane;
    }

    @Override
    public void run() {
        if (this.url == null) {
            this.editorPane.setCursor(this.cursor);
            Container parent = this.editorPane.getParent();
            parent.repaint();
        } else {
            Document doc = this.editorPane.getDocument();
            try {
                try {
                    this.editorPane.setPage(this.url);
                }
                catch (IOException ioe) {
                    this.editorPane.setDocument(doc);
                    this.getToolkit().beep();
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
            finally {
                this.url = null;
                SwingUtilities.invokeLater(this);
            }
        }
    }
}

