/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

public class NumericIDs {
    private int[] ids;

    public NumericIDs(int id) {
        this.ids = new int[1];
        this.ids[0] = id;
    }

    public NumericIDs(int[] targetIDs) {
        this.setIDs(targetIDs);
    }

    public int getIDAt(int index) {
        if (this.ids == null || index < 0 || index > this.ids.length) {
            return -1;
        }
        return this.ids[index];
    }

    public int[] getIDs() {
        return this.ids;
    }

    public int[] getIDSlice(int start, int end) {
        if (this.ids == null || start < 0 || start > end || start > this.ids.length || end > this.ids.length) {
            return null;
        }
        int[] slice = new int[end - start + 1];
        System.arraycopy(this.ids, start, slice, 0, end - start + 1);
        return slice;
    }

    public void setIDAt(int id, int index) {
        if (this.ids != null && index > -1 && index < this.ids.length) {
            this.ids[index] = id;
        }
    }

    public void setIDs(int[] targetIDs) {
        this.ids = new int[targetIDs.length];
        System.arraycopy(targetIDs, 0, this.ids, 0, this.ids.length);
    }

    public int size() {
        return this.ids != null ? this.ids.length : 0;
    }

    public String toString() {
        if (this.ids == null || this.ids[0] == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.ids.length - 1) {
            sb.append(this.ids[i]).append(' ');
            ++i;
        }
        sb.append(this.ids[i]);
        return sb.toString();
    }
}

