/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class AnimalFileFilter
extends FileFilter {
    private Hashtable<String, AnimalFileFilter> filters = new Hashtable();
    private String description = null;
    private String fullDescription = null;
    private String extension = null;
    private boolean useExtensionsInDescription = true;
    private boolean requiresPrefixAndDirectory = false;
    private String directory = null;
    private String prefix = null;

    public AnimalFileFilter() {
    }

    public AnimalFileFilter(String anExtension) {
        this(anExtension, null);
    }

    public AnimalFileFilter(String anExtension, String aDescription) {
        this();
        if (anExtension != null) {
            this.addExtension(anExtension);
        }
        this.extension = anExtension;
        if (aDescription != null) {
            this.setDescription(aDescription);
        }
    }

    public AnimalFileFilter(String mandatoryDirectory, String mandatoryPrefix, String aDescription) {
        this();
        this.directory = mandatoryDirectory;
        this.prefix = mandatoryPrefix;
        this.setDescription(aDescription);
        this.fullDescription = aDescription;
        this.requiresPrefixAndDirectory = true;
    }

    public AnimalFileFilter(String[] filterSettings) {
        this(filterSettings, null);
    }

    public AnimalFileFilter(String[] filterSettings, String aDescription) {
        this();
        int i = 0;
        while (i < filterSettings.length) {
            this.addExtension(filterSettings[i]);
            ++i;
        }
        if (aDescription != null) {
            this.setDescription(aDescription);
        }
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            if (this.requiresPrefixAndDirectory) {
                if (this.prefix != null && !f.getName().startsWith(this.prefix)) {
                    return false;
                }
                return this.directory == null || f.getPath().endsWith(this.directory);
            }
            String anExtension = this.getExtension(f);
            if (anExtension != null && this.filters.get(this.getExtension(f)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public String getExtension() {
        return this.extension;
    }

    public void addExtension(String anExtension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(anExtension.toLowerCase(), this);
        this.fullDescription = null;
    }

    public String getShortDescription() {
        return this.description;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? " (" : String.valueOf(this.description) + "(";
                Enumeration<String> extensions = this.filters.keys();
                if (extensions != null) {
                    this.fullDescription = String.valueOf(this.fullDescription) + "." + extensions.nextElement();
                    while (extensions.hasMoreElements()) {
                        this.fullDescription = String.valueOf(this.fullDescription) + ", " + extensions.nextElement();
                    }
                }
                this.fullDescription = String.valueOf(this.fullDescription) + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }
}

