/*
 * Decompiled with CFR 0.152.
 */
package animal.main;

import animal.gui.AnimalMainWindow;
import animal.gui.GraphicVector;
import animal.gui.GraphicVectorEntry;
import animal.main.AnimalConfiguration;
import animal.main.AnimationCanvasMouseListener;
import animal.main.AnimationWindow;
import animal.misc.ScalableGraphics;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.ScrollPane;
import javax.swing.JPanel;

public class AnimationCanvas
extends JPanel {
    private static final long serialVersionUID = 5520674258993937191L;
    private Image image = null;
    private GraphicVector objects = null;
    private Dimension oldSize = new Dimension(0, 0);
    private Dimension referenceSize = this.initSize();
    private Dimension internalSize = new Dimension(this.referenceSize);
    private ScalableGraphics sg = new ScalableGraphics();
    private Color backgroundColor = Color.lightGray;
    private Image backgroundImage = null;
    private Dimension explicitSize = null;

    public AnimationCanvas() {
        this.addMouseListener(new AnimationCanvasMouseListener(this));
        this.setVisible(true);
    }

    public void setMagnification(double mag) {
        this.sg.setMagnification(mag);
        this.internalSize.setSize((int)((double)this.referenceSize.width * mag) + 20, (int)((double)this.referenceSize.height * mag) + 20);
        ScrollPane sp = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false).getScrollPane();
        Dimension size = new Dimension(this.internalSize.width, this.internalSize.height);
        if (size.width < this.getSize().width) {
            size.width = this.getSize().width;
        }
        if (size.height < this.getSize().height) {
            size.height = this.getSize().height;
        }
        this.image = this.createImage(size.width, size.height);
        if (sp != null) {
            sp.doLayout();
        }
        this.repaintNow();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public double getMagnification() {
        if (this.sg != null) {
            return this.sg.getMagnification();
        }
        return 1.0;
    }

    public void setBackgroundColor(Color c) {
        this.backgroundColor = c;
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image anImage) {
        this.backgroundImage = anImage;
    }

    @Override
    public void paint(Graphics g) {
        Dimension size = null;
        size = this.internalSize = this.initSize();
        Graphics ig = null;
        if (this.image == null || !size.equals(this.oldSize)) {
            this.image = this.createImage(this.internalSize.width, this.internalSize.height);
            this.oldSize = size;
        }
        if (this.image != null) {
            Graphics where;
            ig = this.image.getGraphics();
            if (this.getBackgroundImage() == null) {
                ig.setColor(this.backgroundColor);
                ig.fillRect(0, 0, size.width, size.height);
            } else {
                ig.drawImage(this.getBackgroundImage(), 0, 0, size.width, size.height, this.getBackgroundColor(), this);
            }
            if (this.sg.getMagnification() == 1.0) {
                where = ig;
            } else {
                where = ig;
                if (where instanceof Graphics2D) {
                    ((Graphics2D)where).scale(this.sg.getMagnification(), this.sg.getMagnification());
                }
            }
            if (this.objects != null && this.objects.getSize() > 0) {
                int gveSize = this.objects.getSize();
                GraphicVectorEntry[] gves = this.objects.convertToArray();
                this.objects.heapsort(gves);
                int a = gveSize - 1;
                while (a >= 0) {
                    if (!gves[a].isTemporary()) {
                        gves[a].go.paint(where);
                    }
                    --a;
                }
            }
            g.drawImage(this.image, 0, 0, this);
            ig.dispose();
        }
    }

    void repaintNow() {
        this.paint(this.getGraphics());
    }

    public Dimension getCurrentSize() {
        return this.internalSize;
    }

    public Dimension initSize() {
        if (this.explicitSize != null) {
            return this.explicitSize;
        }
        XProperties animalProperties = AnimalConfiguration.getDefaultConfiguration().getProperties();
        Dimension targetSize = new Dimension(animalProperties.getIntProperty("animationCanvas.width", 640), animalProperties.getIntProperty("animationCanvas.width", 480));
        AnimationWindow aWin = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false);
        if (aWin != null && aWin.getScrollPane() != null) {
            Dimension canvasScreenSize = aWin.getScrollPane().getSize();
            if (canvasScreenSize.width != targetSize.width) {
                targetSize.width = canvasScreenSize.width;
            }
            if (canvasScreenSize.height != targetSize.height) {
                targetSize.height = canvasScreenSize.height;
            }
        }
        if (this.getMagnification() > 1.0) {
            targetSize.width = (int)((double)targetSize.width * this.getMagnification());
            targetSize.height = (int)((double)targetSize.height * this.getMagnification());
        }
        return targetSize;
    }

    void setObjects(GraphicVector graphicalObjects) {
        this.objects = graphicalObjects;
    }

    GraphicVector getObjects() {
        return this.objects;
    }

    void getProperties(XProperties props) {
        props.put("animationCanvas.BackgroundColor", this.getBackgroundColor());
    }

    void setProperties(XProperties props) {
        this.setBackgroundColor(props.getColorProperty("animationCanvas.BackgroundColor", Color.white));
    }

    public Image getCurrentImage() {
        return this.image;
    }

    public void invalidateImage() {
        this.image = null;
    }

    public void setExplicitSize(Dimension d) {
        this.explicitSize = d;
        this.setSize(this.explicitSize);
    }

    public void clearExplicitSize() {
        this.explicitSize = null;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.internalSize;
    }
}

