/*
 * Decompiled with CFR 0.152.
 */
package animal.handler;

import animal.graphics.PTGraphicObject;
import animal.graphics.PTOpenEllipseSegment;
import animal.handler.GraphicObjectHandler;
import animal.misc.MSMath;
import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.util.Vector;

public class OpenEllipseSegmentHandler
extends GraphicObjectHandler {
    @Override
    public Vector<String> getMethods(PTGraphicObject ptgo, Object obj) {
        Vector<String> result = new Vector<String>();
        if (!(ptgo instanceof PTOpenEllipseSegment)) {
            return result;
        }
        if (obj instanceof Point) {
            result.addElement("translate");
        }
        if (obj instanceof Color) {
            result.addElement("color");
        }
        if (obj instanceof Boolean) {
            result.addElement("show");
            result.addElement("hide");
        }
        if (obj instanceof String) {
            result.addElement("fwArrow");
            result.addElement("bwArrow");
            result.addElement("noFwArrow");
            result.addElement("noBwArrow");
        }
        this.addExtensionMethodsFor(ptgo, obj, result);
        return result;
    }

    @Override
    public void propertyChange(PTGraphicObject ptgo, PropertyChangeEvent e) {
        String what;
        PTOpenEllipseSegment shape = null;
        if (ptgo instanceof PTOpenEllipseSegment) {
            shape = (PTOpenEllipseSegment)ptgo;
        }
        if ("translate".equalsIgnoreCase(what = e.getPropertyName())) {
            Point old = (Point)e.getOldValue();
            Point now = (Point)e.getNewValue();
            Point diff = MSMath.diff(now, old);
            shape.translate(diff.x, diff.y);
        } else if (what.equalsIgnoreCase("color")) {
            shape.setColor((Color)e.getNewValue());
        } else if (what.equalsIgnoreCase("fwArrow")) {
            shape.setFWArrow(true);
        } else if (what.equalsIgnoreCase("noFwArrow")) {
            shape.setFWArrow(true);
        } else if (what.equalsIgnoreCase("bwArrow")) {
            shape.setBWArrow(true);
        } else if (what.equalsIgnoreCase("noBwArrow")) {
            shape.setBWArrow(true);
        } else {
            super.propertyChange(ptgo, e);
        }
    }
}

