/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.gui.AnimalMainWindow;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.main.Animation;
import animal.misc.AnimalFileChooser;
import animal.misc.MessageDisplay;
import animalscript.core.AnimalScriptParser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.zip.GZIPOutputStream;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import translator.AnimalTranslator;

public class AnimalScriptInputWindow
implements ActionListener {
    private AbstractButton scriptingInputClear;
    private AbstractButton scriptingInputOK;
    private AbstractButton scriptingInputSave;
    private JTextArea scriptingInputArea;
    private JFrame scriptingInputFrame;
    private String lastScriptingInput = null;
    private Animal animalInstance = null;
    private AnimalScriptParser scriptParser = null;

    public AnimalScriptInputWindow(Animal animal) {
        this.animalInstance = animal;
        if (this.animalInstance == null) {
            this.animalInstance = Animal.get();
        }
    }

    public void initScriptingGUI() {
        if (this.scriptingInputArea == null) {
            this.scriptingInputArea = new JTextArea(20, 60);
        }
        if (this.lastScriptingInput != null) {
            this.scriptingInputArea.setText(this.lastScriptingInput);
        }
        if (this.scriptingInputSave == null) {
            this.scriptingInputSave = AnimalTranslator.getGUIBuilder().generateJButton("save");
            this.scriptingInputSave.addActionListener(this);
        }
        if (this.scriptingInputOK == null) {
            this.scriptingInputOK = AnimalTranslator.getGUIBuilder().generateJButton("GenericEditor.ok");
            this.scriptingInputOK.addActionListener(this);
        }
        if (this.scriptingInputClear == null) {
            this.scriptingInputClear = AnimalTranslator.getGUIBuilder().generateJButton("clear");
            this.scriptingInputClear.addActionListener(this);
        }
        if (this.scriptingInputFrame == null) {
            this.scriptingInputFrame = AnimalTranslator.getGUIBuilder().generateJFrame("scriptSourcePane");
        }
        JPanel p = new JPanel();
        this.scriptingInputFrame.getContentPane().add("Center", new JScrollPane(this.scriptingInputArea));
        p.add(this.scriptingInputSave);
        p.add(this.scriptingInputClear);
        p.add(this.scriptingInputOK);
        this.scriptingInputFrame.getContentPane().add("South", p);
        this.scriptingInputFrame.pack();
    }

    private void saveScriptingInput(String input) {
        String theInput = input;
        AnimalFileChooser fileChooser = Animal.getFileChooser();
        fileChooser.setAnimalScriptingFilters();
        String filename = fileChooser.openForSave(this.animalInstance);
        if (filename != null) {
            String type = fileChooser.getExtension();
            if (!filename.endsWith("." + type)) {
                filename = String.valueOf(filename) + "." + type;
            }
            try {
                long timeTaken = System.currentTimeMillis();
                FilterOutputStream out = new BufferedOutputStream(new FileOutputStream(filename));
                if (type.equals("asc")) {
                    out = new GZIPOutputStream(out);
                }
                PrintWriter pw = new PrintWriter(out);
                if (!theInput.endsWith("\n")) {
                    theInput = String.valueOf(theInput) + " \n";
                }
                pw.print(theInput);
                pw.close();
                ((OutputStream)out).close();
                StringBuilder sb = new StringBuilder(180);
                sb.append(this.animalInstance.getTime());
                if (type.equals("ac")) {
                    sb.append("compressed ");
                }
                sb.append("AnimalScript");
                File f = new File(filename);
                sb.append("(").append(f.length()).append(" Bytes, ");
                sb.append(timeTaken).append(" ms).");
                f = null;
                MessageDisplay.message(sb.toString());
                sb = null;
            }
            catch (IOException e) {
                MessageDisplay.errorMsg("scriptSaveFailed", e.getMessage(), 16);
            }
        }
    }

    public void setScriptingContent(String content) {
        this.scriptingInputArea.setText(content);
        this.scriptingInputArea.setCaretPosition(0);
    }

    protected void setVisible(boolean isVisible) {
        this.scriptingInputFrame.setVisible(isVisible);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.scriptingInputClear) {
            this.scriptingInputArea.setText(null);
        } else if (e.getSource() == this.scriptingInputSave) {
            this.saveScriptingInput(this.scriptingInputArea.getText());
        } else if (e.getSource() == this.scriptingInputOK) {
            this.lastScriptingInput = this.scriptingInputArea.getText();
            if (this.lastScriptingInput != null) {
                long timeNow = System.currentTimeMillis();
                this.scriptParser = new AnimalScriptParser();
                this.scriptParser.generateStreamTokenizer(this.lastScriptingInput, false);
                Animation tmpAnim = this.scriptParser.importAnimationFrom(new StringReader(this.lastScriptingInput), true);
                timeNow = timeNow > System.currentTimeMillis() ? (timeNow -= System.currentTimeMillis()) : System.currentTimeMillis() - timeNow;
                if (this.animalInstance.setAnimation(tmpAnim)) {
                    this.animalInstance.getAnimation().resetChange();
                    MessageDisplay.message("parsedInternalScripting", (int)timeNow);
                    this.animalInstance.setFilename("localBuffer");
                    AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).setTitle("Draw Window - " + AnimalConfiguration.getDefaultConfiguration().getCurrentFilename());
                    this.scriptingInputFrame.setVisible(false);
                }
            }
        }
    }
}

