/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics.meta;

import animal.graphics.PTPoint;
import animal.graphics.meta.ArrowablePrimitive;
import animal.graphics.meta.LineBasedShape;
import animal.main.AnimalConfiguration;
import animal.misc.MSMath;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import translator.AnimalTranslator;

public abstract class OpenLineBasedShape
extends LineBasedShape
implements ArrowablePrimitive {
    protected boolean hasBackwardArrow;
    protected boolean hasForwardArrow;

    public void drawArrows(Graphics g) {
        if (this.getNodeCount() < 2) {
            return;
        }
        if (this.hasForwardArrow && this.getLastNode() != null) {
            OpenLineBasedShape.drawArrow(g, this.getLastNode().toPoint(), this.getNodeAsPoint(this.getNodeCount() - 2));
        }
        if (this.hasBackwardArrow && this.getFirstNode() != null) {
            OpenLineBasedShape.drawArrow(g, this.getFirstNode().toPoint(), this.getNodeAsPoint(1));
        }
    }

    public static void drawArrow(Graphics g, PTPoint tip, PTPoint tail) {
        if (tip != null && tail != null) {
            OpenLineBasedShape.drawArrow(g, tip.toPoint(), tail.toPoint());
        }
    }

    public static void drawArrow(Graphics g, Point tip, Point tail) {
        if (tip == null || tail == null) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("internalError", new String[]{"tip / tail null", "PTLine.drawArrow"}), 16);
            return;
        }
        int xDiff = tail.x - tip.x;
        int yDiff = tail.y - tip.y;
        int dist = MSMath.dist(tip, tail);
        if (dist > 0) {
            if (dist < 20) {
                dist = 20;
            }
            xDiff = xDiff * 20 / dist;
            yDiff = yDiff * 20 / dist;
            int[] x = new int[]{tip.x, tip.x + yDiff / 2 + xDiff, tip.x + xDiff / 2, tip.x - yDiff / 2 + xDiff};
            int[] y = new int[]{tip.y, tip.y - xDiff / 2 + yDiff, tip.y + yDiff / 2, tip.y + xDiff / 2 + yDiff};
            g.fillPolygon(x, y, 4);
        }
    }

    public PTPoint getFirstNode() {
        return this.getNodeAt(0);
    }

    public PTPoint getLastNode() {
        return this.getNodeAt(this.getNodeCount() - 1);
    }

    @Override
    public boolean hasBWArrow() {
        return this.hasBackwardArrow;
    }

    @Override
    public boolean hasFWArrow() {
        return this.hasForwardArrow;
    }

    @Override
    public void initializeWithDefaults(String primitiveName) {
        super.initializeWithDefaults(primitiveName);
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.hasBackwardArrow = config.getDefaultBooleanValue(primitiveName, "bwArrow", false);
        this.hasForwardArrow = config.getDefaultBooleanValue(primitiveName, "fwArrow", false);
    }

    @Override
    public void setBWArrow(boolean shallHaveBackwardArrow) {
        this.hasBackwardArrow = shallHaveBackwardArrow;
    }

    public void setFirstNode(int x, int y) {
        this.setNode(0, x, y);
    }

    public void setFirstNode(Point p) {
        this.setNode(0, p);
    }

    public void setFirstNode(PTPoint p) {
        if (p != null) {
            this.setFirstNode(p.getX(), p.getY());
        }
    }

    public void setLastNode(int x, int y) {
        this.nodes.set(this.getNodeCount() - 1, new PTPoint(x, y));
    }

    public void setLastNode(Point p) {
        if (p != null) {
            this.setLastNode(p.x, p.y);
        }
    }

    public void setLastNode(PTPoint p) {
        if (p != null) {
            this.setLastNode(p.getX(), p.getY());
        }
    }

    @Override
    public void setFWArrow(boolean shallHaveForwardArrow) {
        this.hasForwardArrow = shallHaveForwardArrow;
    }

    protected String toString(String objectName) {
        StringBuilder result = new StringBuilder(256);
        result.append(objectName).append(" ");
        if (this.getObjectName() != null) {
            result.append("\"").append(this.getObjectName()).append("\" ");
        }
        int i = 0;
        int nrNodes = this.getNodeCount();
        while (i < nrNodes) {
            PTPoint currentNode = this.getNodeAt(i);
            result.append("(").append(currentNode.getX()).append(", ");
            result.append(currentNode.getY()).append(")");
            if (i < nrNodes - 1) {
                result.append(", ");
            }
            ++i;
        }
        return result.toString();
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".bwArrow", this.hasBWArrow());
        defaultProperties.put(String.valueOf(this.getType()) + ".fwArrow", this.hasFWArrow());
    }

    @Override
    public void useAsMoveBase() {
        this.setFWArrow(true);
        this.setBWArrow(false);
    }

    @Override
    public void paint(Graphics g) {
        Polygon poly = this.toPolygon();
        g.setColor(this.getColor());
        g.drawPolyline(poly.xpoints, poly.ypoints, poly.xpoints.length);
        int nrNodes = this.getNodeCount();
        if (this.hasForwardArrow) {
            OpenLineBasedShape.drawArrow(g, this.getNodeAsPoint(nrNodes - 1), this.getNodeAsPoint(nrNodes - 2));
        }
        if (this.hasBackwardArrow) {
            OpenLineBasedShape.drawArrow(g, this.getNodeAsPoint(0), this.getNodeAsPoint(1));
        }
    }

    @Override
    public void scale(double scaleX, double scaleY) {
        int maxIndex = this.getNodeCount();
        int nodeNr = 0;
        while (nodeNr < maxIndex) {
            if (this.nodes.elementAt(nodeNr) != null) {
                ((PTPoint)this.nodes.elementAt(nodeNr)).scale(scaleX, scaleY);
            }
            ++nodeNr;
        }
    }

    public void shear(double shearX, double shearY) {
        int maxIndex = this.getNodeCount();
        int nodeNr = 0;
        while (nodeNr < maxIndex) {
            if (this.nodes.elementAt(nodeNr) != null) {
                ((PTPoint)this.nodes.elementAt(nodeNr)).shear(shearX, shearY);
            }
            ++nodeNr;
        }
    }

    public void translate(int aNum, int deltaX, int deltaY) {
        ((PTPoint)this.nodes.elementAt(aNum)).translate(deltaX, deltaY);
    }

    @Override
    protected void cloneCommonFeaturesInto(OpenLineBasedShape targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setFWArrow(this.hasForwardArrow);
        targetShape.setBWArrow(this.hasBackwardArrow);
    }
}

