/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics.meta;

import animal.graphics.PTPoint;
import animal.graphics.meta.ArcBasedShape;
import animal.graphics.meta.ArrowablePrimitive;
import animal.main.AnimalConfiguration;
import animal.misc.MSMath;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Graphics;
import java.awt.Point;
import translator.AnimalTranslator;

public abstract class OpenArcBasedShape
extends ArcBasedShape
implements ArrowablePrimitive {
    protected boolean hasBackwardArrow;
    protected boolean hasForwardArrow;
    protected boolean isClockwise = false;
    protected int startAngle = 0;
    protected int totalAngle = 45;

    protected void drawArrow(Graphics g, double angle, int xRadius, int yRadius, boolean clockwise) {
        double before = angle + (double)(clockwise ? 1 : -1) * 1.0 / 100.0;
        double tipX = (double)this.center.x + (double)xRadius * Math.cos(angle);
        double tipY = (double)this.center.y - (double)yRadius * Math.sin(angle);
        double inclinationX = (double)this.center.x + (double)xRadius * Math.cos(before) - tipX;
        double inclinationY = (double)this.center.y - (double)yRadius * Math.sin(before) - tipY;
        double length = Math.sqrt(inclinationX * inclinationX + inclinationY * inclinationY);
        Point from = new Point((int)(tipX + inclinationX * (double)xRadius / length), (int)(tipY + inclinationY * (double)yRadius / length));
        this.drawArrow(g, new Point((int)tipX, (int)tipY), from);
    }

    protected void drawArrow(Graphics g, Point tip, Point tail) {
        if (tip == null || tail == null) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("internalError", new String[]{"tip / tail null", "PTPolyline.drawArrow"}), 16);
            return;
        }
        int xDiff = tail.x - tip.x;
        int yDiff = tail.y - tip.y;
        int dist = MSMath.dist(tip, tail);
        if (dist > 0) {
            if (dist < 20) {
                dist = 20;
            }
            xDiff = xDiff * 20 / dist;
            yDiff = yDiff * 20 / dist;
            int[] x = new int[]{tip.x, tip.x + yDiff / 2 + xDiff, tip.x + xDiff / 2, tip.x - yDiff / 2 + xDiff};
            int[] y = new int[]{tip.y, tip.y - xDiff / 2 + yDiff, tip.y + yDiff / 2, tip.y + xDiff / 2 + yDiff};
            g.fillPolygon(x, y, 4);
        }
    }

    @Override
    public int getLength() {
        return Math.abs(this.getTotalAngle());
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public int getTotalAngle() {
        return this.totalAngle;
    }

    @Override
    public boolean hasBWArrow() {
        return this.hasBackwardArrow;
    }

    @Override
    public boolean hasFWArrow() {
        return this.hasForwardArrow;
    }

    @Override
    public void initializeWithDefaults(String primitiveName) {
        super.initializeWithDefaults(primitiveName);
        this.center = new Point(0, 0);
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.hasBackwardArrow = config.getDefaultBooleanValue(primitiveName, "bwArrow", false);
        this.isClockwise = config.getDefaultBooleanValue(this.getType(), "clockwise", false);
        this.hasForwardArrow = config.getDefaultBooleanValue(primitiveName, "fwArrow", false);
    }

    public boolean isClockwise() {
        return this.isClockwise;
    }

    public void setClockwise(boolean isOrientationClockwise) {
        if (this.isClockwise != isOrientationClockwise) {
            if (isOrientationClockwise) {
                this.setTotalAngle((this.getTotalAngle() - 360) % 360);
            } else {
                this.setTotalAngle((360 + this.getTotalAngle()) % 360);
            }
        }
        this.isClockwise = isOrientationClockwise;
    }

    @Override
    public void setBWArrow(boolean shallHaveBackwardArrow) {
        this.hasBackwardArrow = shallHaveBackwardArrow;
    }

    @Override
    public void setFWArrow(boolean shallHaveForwardArrow) {
        this.hasForwardArrow = shallHaveForwardArrow;
    }

    public void setStartAngle(int angle) {
        this.startAngle = angle;
    }

    public void setTotalAngle(int angle) {
        this.totalAngle = angle;
    }

    protected void cloneCommonFeaturesInto(OpenArcBasedShape targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setBWArrow(this.hasBackwardArrow);
        targetShape.setClockwise(this.isClockwise);
        targetShape.setFWArrow(this.hasForwardArrow);
        targetShape.setStartAngle(this.getStartAngle());
        targetShape.setTotalAngle(this.getTotalAngle());
    }

    protected void paint(Graphics g, int rx, int ry) {
        double angle;
        if (this.center == null) {
            return;
        }
        g.setColor(this.color);
        g.drawArc(this.center.x - rx, this.center.y - ry, rx * 2, ry * 2, this.startAngle, this.totalAngle);
        if (this.hasFWArrow()) {
            angle = (double)(this.startAngle + this.totalAngle) * Math.PI / 180.0;
            this.drawArrow(g, angle, rx, ry, this.isClockwise());
        }
        if (this.hasBWArrow()) {
            angle = (double)this.startAngle * Math.PI / 180.0;
            this.drawArrow(g, angle, rx, ry, !this.isClockwise);
        }
    }

    public void rotate(double angle) {
        PTPoint centerNode = new PTPoint(this.center);
        centerNode.rotate(angle);
        this.center = centerNode.toPoint();
        this.setStartAngle((int)((long)this.getStartAngle() + Math.round(angle * 180.0 / Math.PI)));
    }

    public void rotate(double angle, PTPoint centerPoint) {
        this.translate(-centerPoint.getX(), -centerPoint.getY());
        this.rotate(angle);
        this.translate(centerPoint.getX(), centerPoint.getY());
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".bwArrow", this.hasBWArrow());
        defaultProperties.put(String.valueOf(this.getType()) + ".clockwise", this.isClockwise());
        defaultProperties.put(String.valueOf(this.getType()) + ".fwArrow", this.hasFWArrow());
        defaultProperties.put(String.valueOf(this.getType()) + ".startAngle", this.getStartAngle());
        defaultProperties.put(String.valueOf(this.getType()) + ".totalAngle", this.getTotalAngle());
    }

    @Override
    public void useAsMoveBase() {
    }

    protected String toString(String typeName, boolean isCircular, int rx, int ry) {
        StringBuilder sb = new StringBuilder(256);
        sb.append(typeName).append(" ");
        if (this.getObjectName() != null) {
            sb.append("\"").append(this.getObjectName()).append("\" ");
        }
        sb.append("center=(");
        sb.append(this.center.x).append(", ").append(this.center.y).append("), radius");
        if (isCircular) {
            sb.append("=").append(rx);
        } else {
            sb.append(" (").append(rx).append(", ").append(ry).append(")");
        }
        sb.append(" starts at ");
        sb.append(this.getStartAngle()).append(", angle=").append(this.getTotalAngle());
        if (this.isClockwise) {
            sb.append(" clockwise");
        }
        if (this.hasForwardArrow) {
            sb.append(" fwArrow");
        }
        if (this.hasBackwardArrow) {
            sb.append(" bwArrow");
        }
        return sb.toString();
    }
}

