/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics.meta;

import animal.animator.MoveBase;
import animal.graphics.PTGraphicObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class ArcBasedShape
extends PTGraphicObject
implements MoveBase {
    protected Point center;

    protected int getAngle(Point p, int xRadius, int yRadius) {
        if (p == null || xRadius == 0 || yRadius == 0) {
            return -1;
        }
        int xdist = p.x - this.center.x;
        int ydist = p.y - this.center.y;
        int angle = (int)(MSMath.getAngle(this.center, new Point(this.center.x + xdist * 100 / xRadius, this.center.y + ydist * 100 / yRadius)) * 180.0 / Math.PI);
        if (angle < 0) {
            angle += 360;
        }
        return angle;
    }

    protected Rectangle getBoundingBox(int rx, int ry) {
        return new Rectangle(this.center.x - rx, this.center.y - ry, rx * 2, ry * 2);
    }

    public Point getCenter() {
        if (this.center == null) {
            this.center = new Point(10, 10);
        }
        return this.center;
    }

    protected Point getPointAtLength(int alpha, int rx, int ry) {
        double x = (double)alpha * Math.PI / 180.0;
        return new Point((int)((double)this.center.x + (double)rx * Math.cos(x)), (int)((double)this.center.y - (double)ry * Math.sin(x)));
    }

    public void setCenter(int x, int y) {
        this.center = new Point(x, y);
    }

    public void setCenter(Point localCenter) {
        this.setCenter(localCenter.x, localCenter.y);
    }

    @Override
    public void translate(int x, int y) {
        this.center.translate(x, y);
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".center", this.getCenter());
    }

    protected void cloneCommonFeaturesInto(ArcBasedShape targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setCenter(this.getCenter().x, this.getCenter().y);
    }
}

