/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.meta.ImmediateTextContainer;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.misc.XProperties;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class PTText
extends PTGraphicObject
implements ImmediateTextContainer {
    public static final String TEXT_TYPE = "Text";
    private static final long serialVersionUID = 5149137629030065454L;
    protected Font font = null;
    protected Point position = new Point(0, 0);
    protected double rotationAngle = 0.0;
    protected double scalingFactorX = 1.0;
    protected double scalingFactorY = 1.0;
    protected String text = "";

    public PTText() {
        this.initializeWithDefaults(this.getType());
    }

    public PTText(String textValue, Point targetPosition) {
        this(textValue, targetPosition, PTText.getDefaultFont());
    }

    public PTText(String textValue, Font targetFont) {
        this(textValue, new Point(50, 50), targetFont);
    }

    public PTText(String textValue, Point targetPosition, Font targetFont) {
        this();
        this.setText(textValue);
        this.setPosition(targetPosition);
        this.setFont(targetFont);
    }

    public static Font getDefaultFont() {
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        return config.getDefaultFontValue(TEXT_TYPE, "font");
    }

    @Override
    public void initializeWithDefaults(String primitiveName) {
        super.initializeWithDefaults(primitiveName);
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.font = config.getDefaultFontValue(primitiveName, "font");
    }

    @Override
    public int getFileVersion() {
        return 2;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public Point getPosition() {
        return this.position;
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public double getScalingFactorX() {
        return this.scalingFactorX;
    }

    public double getScalingFactorY() {
        return this.scalingFactorX;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getType() {
        return TEXT_TYPE;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{TEXT_TYPE};
    }

    @Override
    public void setFont(Font f) {
        if (f != null) {
            this.font = f;
        }
    }

    public void setPosition(Point p) {
        if (p != null) {
            this.setPosition(p.x, p.y);
        }
    }

    public void setPosition(int x, int y) {
        if (this.position != null) {
            this.position.setLocation(x, y);
        } else {
            this.position = new Point(x, y);
        }
    }

    public void setRotationAngle(double newAngle) {
        this.rotationAngle = newAngle;
    }

    public void setScalingFactorX(double scaleX) {
        this.scalingFactorX = scaleX;
    }

    public void setScalingFactorY(double scaleY) {
        this.scalingFactorY = scaleY;
    }

    @Override
    public void setText(String newText) {
        this.text = newText == null ? "" : newText;
    }

    @Override
    public void paint(Graphics g) {
        boolean use2D;
        boolean bl = use2D = g instanceof Graphics2D && (this.rotationAngle != 0.0 || this.scalingFactorX != 1.0 || this.scalingFactorY != 1.0);
        if (this.getText() != null && this.position != null) {
            g.setColor(this.getColor());
            g.setFont(this.getFont());
            if (use2D) {
                ((Graphics2D)g).rotate(this.rotationAngle, this.position.x, this.position.y);
                ((Graphics2D)g).scale(this.scalingFactorX, this.scalingFactorY);
            }
            g.drawString(this.getText(), this.position.x, this.position.y);
            if (use2D) {
                ((Graphics2D)g).rotate(-this.rotationAngle);
            }
        }
    }

    public void rotate(double angle) {
        this.setRotationAngle(angle);
    }

    public void rotate(double angle, PTPoint center) {
        this.translate(-center.getX(), -center.getY());
        this.rotate(angle);
        this.translate(center.getX(), center.getY());
    }

    public void scale(double scaleX, double scaleY) {
        this.setScalingFactorX(scaleX);
        this.setScalingFactorY(scaleY);
    }

    @Override
    public void translate(int x, int y) {
        this.position.translate(x, y);
    }

    @Override
    public Object clone() {
        PTText targetShape = new PTText();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTText targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setFont(new Font(this.getFont().getFamily(), this.getFont().getStyle(), this.getFont().getSize()));
        targetShape.setPosition(this.getPosition().x, this.getPosition().y);
        targetShape.setRotationAngle(this.rotationAngle);
        targetShape.setScalingFactorX(this.scalingFactorX);
        targetShape.setScalingFactorY(this.scalingFactorY);
        targetShape.setText(new String(this.text));
    }

    @Override
    public Rectangle getBoundingBox() {
        int width = Animal.getStringWidth(this.getText(), this.getFont());
        FontMetrics fm = Animal.getConcreteFontMetrics(this.getFont());
        return new Rectangle(this.position.x, this.position.y - fm.getAscent(), width, fm.getAscent() + fm.getDescent());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(30 + this.getText().length());
        sb.append("Text ");
        if (this.getObjectName() != null) {
            sb.append("\"").append(this.getObjectName()).append("\" ");
        }
        sb.append("{ '").append(this.text).append("' at (").append(this.position.x);
        sb.append(", ").append(this.position.y).append(") }");
        return sb.toString();
    }

    public static String escapeText(String input) {
        if (input.indexOf("\"") == -1) {
            return new String(input);
        }
        StringBuilder sb = new StringBuilder(input.length() + 30);
        int start = 0;
        int end = input.indexOf("\"", start);
        while (end >= 0) {
            sb.append(input.substring(start, end));
            sb.append("\\\"");
            start = end + 1;
            end = input.indexOf("\"", start);
        }
        if (start < input.length()) {
            sb.append(input.substring(start));
        }
        return sb.toString();
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        Font f = this.getFont();
        defaultProperties.put(String.valueOf(this.getType()) + ".bold", f.isBold());
        defaultProperties.put(String.valueOf(this.getType()) + ".font", f);
        defaultProperties.put(String.valueOf(this.getType()) + ".fontName", f.getFamily());
        defaultProperties.put(String.valueOf(this.getType()) + ".fontSize", f.getSize());
        defaultProperties.put(String.valueOf(this.getType()) + ".italic", f.isItalic());
        defaultProperties.put(String.valueOf(this.getType()) + ".text", this.getText());
    }

    @Override
    public void discard() {
        super.discard();
        this.position = null;
        this.font = null;
        this.text = null;
    }
}

