/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTPoint;
import animal.graphics.meta.PolygonalShape;
import animal.misc.XProperties;
import java.awt.Dimension;
import java.awt.Point;

public class PTRectangle
extends PolygonalShape {
    public static final String RECTANGLE_TYPE = "Rectangle";
    private static final long serialVersionUID = 5793164474737251118L;
    private int height;
    private int width;

    public PTRectangle() {
        this(10, 10, 2, 2);
    }

    public PTRectangle(Point node1, Point node2) {
        this(node1.x, node1.y, node2.x - node1.x, node2.y - node1.y);
    }

    public PTRectangle(int x, int y, int targetWidth, int targetHeight) {
        this.initializeWithDefaults(this.getType());
        this.fillNodesVector(4);
        this.width = targetWidth;
        this.height = targetHeight;
        this.setStartNode(x, y);
    }

    public Point getEndNode() {
        PTPoint endPoint = this.getNodeAt(2);
        if (endPoint == null) {
            this.updateShape();
            endPoint = this.getNodeAt(2);
        }
        return endPoint.toPoint();
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    public int getHeight() {
        return this.height;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public Point getStartNode() {
        PTPoint endPoint = this.getNodeAt(0);
        if (endPoint == null) {
            return new Point(0, 0);
        }
        return endPoint.toPoint();
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public String getType() {
        return RECTANGLE_TYPE;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{RECTANGLE_TYPE};
    }

    public void setHeight(int newHeight) {
        this.height = newHeight;
        this.updateShape();
    }

    public void setSize(Dimension newSize) {
        if (newSize == null) {
            this.width = 0;
            this.height = 0;
        } else {
            this.width = newSize.width;
            this.height = newSize.height;
        }
        this.updateShape();
    }

    public void setStartNode(int x, int y) {
        this.nodes.set(0, new PTPoint(x, y));
        this.updateShape();
    }

    public void setStartNode(Point p) {
        if (p != null) {
            this.setStartNode(p.x, p.y);
        }
    }

    public void setWidth(int newWidth) {
        this.width = newWidth;
        this.updateShape();
    }

    @Override
    protected void updateShape() {
        Point node = this.getNodeAsPoint(0);
        if (node == null) {
            node = new Point(0, 0);
        }
        int x = node.x;
        int y = node.y;
        this.nodes.set(1, new PTPoint(x + this.width, y));
        this.nodes.set(2, new PTPoint(x + this.width, y + this.height));
        this.nodes.set(3, new PTPoint(x, y + this.height));
    }

    @Override
    public void scale(double scaleX, double scaleY) {
        super.scale(scaleX, scaleY);
        this.width = (int)((double)this.width * scaleX);
        this.height = (int)((double)this.height * scaleY);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(120);
        result.append("PTRectangle ");
        if (this.getObjectName() != null) {
            result.append("\"").append(this.getObjectName()).append("\" ");
        }
        result.append(this.nodeToString(this.getNodeAsPoint(0)));
        result.append("size (").append(this.width).append(", ").append(this.height);
        result.append(")");
        return result.toString();
    }

    @Override
    public Object clone() {
        PTRectangle rectangle = new PTRectangle();
        this.cloneCommonFeaturesInto(rectangle);
        return rectangle;
    }

    protected void cloneCommonFeaturesInto(PTRectangle targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setHeight(this.getHeight());
        targetShape.setWidth(this.getWidth());
    }

    @Override
    public int getLength() {
        return this.width + this.height << 1;
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".height", this.getHeight());
        defaultProperties.put(String.valueOf(this.getType()) + ".width", this.getWidth());
    }
}

