/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTPoint;
import animal.graphics.meta.PolygonalShape;
import java.awt.Point;
import java.util.Vector;

public class PTPolygon
extends PolygonalShape {
    public static final String POLYGON_TYPE = "Polygon";
    private static final long serialVersionUID = 5793164474737251118L;

    public PTPolygon() {
        this(new PTPoint[0]);
    }

    public PTPolygon(int[] xCoords, int[] yCoords) {
        this.initializeWithDefaults(this.getType());
        this.nodes = new Vector(20, 10);
        if (xCoords != null && yCoords != null && xCoords.length == yCoords.length) {
            this.nodes.ensureCapacity(xCoords.length);
            int nrNodes = xCoords.length;
            int nodeNr = 0;
            while (nodeNr < nrNodes) {
                this.nodes.add(new PTPoint(xCoords[nodeNr], yCoords[nodeNr]));
                ++nodeNr;
            }
        }
    }

    public PTPolygon(Point[] edges) {
        this.initializeWithDefaults(this.getType());
        int size = 20;
        if (edges != null) {
            size = edges.length;
        }
        this.nodes = new Vector(size, 10);
        int i = 0;
        while (i < edges.length) {
            this.nodes.add(new PTPoint(edges[i]));
            ++i;
        }
    }

    public PTPolygon(PTPoint[] edges) {
        this.initializeWithDefaults(this.getType());
        int size = 20;
        if (edges != null) {
            size = edges.length;
        }
        this.nodes = new Vector(size, 10);
        int i = 0;
        while (i < edges.length) {
            this.nodes.add(edges[i]);
            ++i;
        }
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    public Vector<PTPoint> getNodes() {
        return this.nodes;
    }

    @Override
    public String getType() {
        return POLYGON_TYPE;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{POLYGON_TYPE};
    }

    public void shear(double shearX, double shearY) {
        int maxIndex = this.getNodeCount();
        int nodeNr = 0;
        while (nodeNr < maxIndex) {
            if (this.nodes.elementAt(nodeNr) != null) {
                ((PTPoint)this.nodes.elementAt(nodeNr)).shear(shearX, shearY);
            }
            ++nodeNr;
        }
    }

    public void translate(int index, int deltaX, int deltaY) {
        if (index >= 0 && this.nodes.size() >= index && this.nodes.get(index) != null) {
            ((PTPoint)this.nodes.elementAt(index)).translate(deltaX, deltaY);
        }
    }

    public void translate(boolean[] moveTheseOnly, int deltaX, int deltaY) {
        int maxIndex = this.getNodeCount();
        int nodeNr = 0;
        while (nodeNr < maxIndex) {
            if (this.nodes.elementAt(nodeNr) != null && moveTheseOnly[nodeNr]) {
                ((PTPoint)this.nodes.elementAt(nodeNr)).translate(deltaX, deltaY);
            }
            ++nodeNr;
        }
    }

    public String toString() {
        return this.toString("PTPolygon");
    }

    void removeNodes() {
        if (this.nodes == null) {
            this.nodes = new Vector(20, 10);
        } else {
            this.nodes.clear();
        }
    }

    public void removeNode(int index) {
        this.nodes.removeElementAt(index);
    }

    @Override
    public Object clone() {
        PTPolygon targetShape = new PTPolygon();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    @Override
    public boolean operationRequiresSpecialSelector(String operation) {
        return operation != null && operation.indexOf("Nodes") != -1;
    }

    @Override
    public String baseOperationName(String methodName) {
        if (methodName.endsWith("...")) {
            return methodName.substring(0, methodName.indexOf(46));
        }
        if (methodName.indexOf("Nodes") != 0) {
            return methodName.substring(0, methodName.indexOf(32));
        }
        return methodName;
    }

    @Override
    public boolean enableMultiSelectionFor(String operation) {
        return operation != null && operation.indexOf("Nodes") != -1;
    }

    public boolean compatibleMethod(String method) {
        return method != null && method.indexOf("Nodes") != -1;
    }
}

