/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.meta.EllipsoidShape;
import animal.graphics.meta.OpenArcBasedShape;
import animal.misc.XProperties;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class PTOpenEllipseSegment
extends OpenArcBasedShape
implements EllipsoidShape {
    public static final String OPEN_ELLIPSE_SEGMENT_TYPE = "OpenEllipseSegment";
    private static final long serialVersionUID = 4711724437159551059L;
    private Point radius;

    public PTOpenEllipseSegment() {
        this.initializeWithDefaults(this.getType());
    }

    public int getAngle(Point p) {
        return this.getAngle(p, this.radius.x, this.radius.y);
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.getBoundingBox(this.radius.x, this.radius.y);
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public Point getPointAtLength(int alpha) {
        return this.getPointAtLength(this.getStartAngle() + (this.isClockwise ? -alpha : alpha), this.radius.x, this.radius.y);
    }

    @Override
    public Point getRadius() {
        return this.radius;
    }

    @Override
    public String getType() {
        return OPEN_ELLIPSE_SEGMENT_TYPE;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{OPEN_ELLIPSE_SEGMENT_TYPE};
    }

    @Override
    public void setRadius(Point r) {
        if (r != null) {
            this.setRadius(r.x, r.y);
        }
    }

    @Override
    public void setRadius(int x, int y) {
        this.radius = new Point(x, y);
    }

    public String toString() {
        return this.toString(this.getType(), false, this.radius.x, this.radius.y);
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".radius", this.getRadius());
    }

    @Override
    public void paint(Graphics g) {
        this.paint(g, this.radius.x, this.radius.y);
    }

    @Override
    public Object clone() {
        PTOpenEllipseSegment targetShape = new PTOpenEllipseSegment();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTOpenEllipseSegment targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setRadius(new Point(this.getRadius().x, this.getRadius().y));
    }
}

