/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.meta.ClosedArcBasedShape;
import animal.graphics.meta.EllipsoidShape;
import animal.misc.XProperties;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class PTEllipse
extends ClosedArcBasedShape
implements EllipsoidShape {
    public static final String ELLIPSE_TYPE = "Ellipse";
    private static final long serialVersionUID = 4711724437359551059L;
    private Point radius = new Point(0, 0);

    public PTEllipse() {
        this.initializeWithDefaults(this.getType());
    }

    public int getAngle(Point p) {
        return this.getAngle(p, this.getXRadius(), this.getYRadius());
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.getBoundingBox(this.getXRadius(), this.getYRadius());
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public int getLength() {
        return 360;
    }

    public Point getPointAtAngle(int alpha) {
        Point localCenter = this.getCenter();
        double x = (double)alpha * Math.PI / 180.0;
        return new Point((int)((double)localCenter.x + (double)this.getXRadius() * Math.cos(x)), (int)((double)localCenter.y - (double)this.getYRadius() * Math.sin(x)));
    }

    @Override
    public Point getPointAtLength(int alpha) {
        return this.getPointAtLength(alpha, this.radius.x, this.radius.y);
    }

    @Override
    public Point getRadius() {
        return this.radius;
    }

    @Override
    public String getType() {
        return ELLIPSE_TYPE;
    }

    public int getXRadius() {
        return this.getRadius().x;
    }

    public int getYRadius() {
        return this.getRadius().y;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{ELLIPSE_TYPE};
    }

    @Override
    public void setRadius(Point targetRadius) {
        if (targetRadius != null) {
            this.setRadius(targetRadius.x, targetRadius.y);
        } else {
            this.setRadius(0, 0);
        }
    }

    @Override
    public void setRadius(int radiusX, int radiusY) {
        this.radius = new Point(radiusX, radiusY);
    }

    public void setXRadius(int r) {
        this.setRadius(r, this.getYRadius());
    }

    public void setYRadius(int r) {
        this.setRadius(this.getXRadius(), r);
    }

    public String toString() {
        return this.toString("PTEllipse", false, this.getXRadius(), this.getYRadius());
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".radius", this.getRadius());
    }

    @Override
    public void paint(Graphics g) {
        this.paint(g, this.getXRadius(), this.getYRadius(), 0, 360);
    }

    @Override
    public Object clone() {
        PTEllipse targetShape = new PTEllipse();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTEllipse targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setRadius(this.getXRadius(), this.getYRadius());
    }

    @Override
    public void discard() {
        super.discard();
        this.radius = null;
    }
}

