/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTPoint;
import animal.graphics.meta.ClosedArcBasedShape;
import animal.graphics.meta.EllipsoidShape;
import animal.main.AnimalConfiguration;
import animal.misc.XProperties;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class PTClosedEllipseSegment
extends ClosedArcBasedShape
implements EllipsoidShape {
    public static final String CLOSED_ELLIPSE_SEGMENT_TYPE = "ClosedEllipseSegment";
    private static final long serialVersionUID = 4711724437159551079L;
    private boolean isClockwise = false;
    private Point radius = new Point(0, 0);
    private int startAngle = 0;
    private int totalAngle = 45;

    public PTClosedEllipseSegment() {
        this.initializeWithDefaults(this.getType());
    }

    @Override
    public void paint(Graphics g) {
        this.paint(g, this.radius.x, this.radius.y, this.startAngle, this.totalAngle);
        if (this.totalAngle % 360 != 0) {
            Point a = this.getPointAtLength(this.startAngle);
            g.drawLine(this.center.x, this.center.y, a.x, a.y);
            a = this.getPointAtLength(this.startAngle + this.totalAngle);
            g.drawLine(this.center.x, this.center.y, a.x, a.y);
        }
    }

    public void rotate(double angle) {
        PTPoint centerNode = new PTPoint(this.center);
        centerNode.rotate(angle);
        this.center = centerNode.toPoint();
    }

    public void rotate(double angle, PTPoint centerPoint) {
        this.translate(-centerPoint.getX(), -centerPoint.getY());
        this.rotate(angle);
        this.translate(centerPoint.getX(), centerPoint.getY());
    }

    public int getAngle(Point p) {
        return this.getAngle(p, this.radius.x, this.radius.y);
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.getBoundingBox(this.radius.x, this.radius.y);
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public int getLength() {
        return Math.abs(this.getTotalAngle());
    }

    @Override
    public Point getPointAtLength(int alpha) {
        return this.getPointAtLength(this.getStartAngle() + (this.isClockwise ? -alpha : alpha), this.radius.x, this.radius.y);
    }

    @Override
    public Point getRadius() {
        return this.radius;
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public int getTotalAngle() {
        return this.totalAngle;
    }

    @Override
    public String getType() {
        return CLOSED_ELLIPSE_SEGMENT_TYPE;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{CLOSED_ELLIPSE_SEGMENT_TYPE};
    }

    @Override
    public void initializeWithDefaults(String primitiveName) {
        super.initializeWithDefaults(primitiveName);
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.isClockwise = config.getDefaultBooleanValue(this.getType(), "clockwise", false);
    }

    public boolean isClockwise() {
        return this.isClockwise;
    }

    public void setClockwise(boolean isOrientationClockwise) {
        if (this.isClockwise != isOrientationClockwise) {
            if (isOrientationClockwise) {
                this.setTotalAngle(this.getTotalAngle() - 360);
            } else {
                this.setTotalAngle(360 + this.getTotalAngle());
            }
        }
        this.isClockwise = isOrientationClockwise;
    }

    @Override
    public void setRadius(Point r) {
        if (r != null) {
            this.setRadius(r.x, r.y);
        }
    }

    @Override
    public void setRadius(int x, int y) {
        this.radius = new Point(Math.abs(x), Math.abs(y));
    }

    public void setStartAngle(int angle) {
        this.startAngle = angle;
    }

    public void setTotalAngle(int angle) {
        this.totalAngle = angle;
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".clockwise", this.isClockwise());
        defaultProperties.put(String.valueOf(this.getType()) + ".radius", this.getRadius());
        defaultProperties.put(String.valueOf(this.getType()) + ".startAngle", this.getStartAngle());
        defaultProperties.put(String.valueOf(this.getType()) + ".totalAngle", this.getTotalAngle());
    }

    @Override
    public Object clone() {
        PTClosedEllipseSegment targetShape = new PTClosedEllipseSegment();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTClosedEllipseSegment targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setClockwise(this.isClockwise());
        targetShape.setRadius(new Point(this.getRadius().x, this.getRadius().y));
        targetShape.setStartAngle(this.getStartAngle());
        targetShape.setTotalAngle(this.getTotalAngle());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        String prefix = this.toString(this.getType(), false, this.radius.x, this.radius.y);
        sb.append(prefix);
        sb.append(", starts at ").append(this.getStartAngle());
        sb.append(", angle=").append(this.getTotalAngle());
        if (this.isClockwise) {
            sb.append(" clockwise");
        }
        return sb.toString();
    }
}

