/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTPoint;
import animal.graphics.meta.CircularShape;
import animal.graphics.meta.ClosedArcBasedShape;
import animal.main.AnimalConfiguration;
import animal.misc.XProperties;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class PTClosedCircleSegment
extends ClosedArcBasedShape
implements CircularShape {
    public static final String CLOSED_CIRCLE_SEGMENT_TYPE = "ClosedCircleSegment";
    private static final long serialVersionUID = 4711724437159551057L;
    private boolean isClockwise = false;
    private int radius;
    private int startAngle = 0;
    private int totalAngle = 45;

    public PTClosedCircleSegment() {
        this.initializeWithDefaults(this.getType());
    }

    @Override
    public void paint(Graphics g) {
        this.paint(g, this.radius, this.radius, this.startAngle, this.totalAngle);
        if (this.totalAngle % 360 != 0) {
            Point a = this.getPointAtLength(this.startAngle);
            g.drawLine(this.center.x, this.center.y, a.x, a.y);
            a = this.getPointAtLength(this.startAngle + this.totalAngle);
            g.drawLine(this.center.x, this.center.y, a.x, a.y);
        }
    }

    public void rotate(double angle) {
        PTPoint centerNode = new PTPoint(this.center);
        centerNode.rotate(angle);
        this.center = centerNode.toPoint();
    }

    public void rotate(double angle, PTPoint centerPoint) {
        this.translate(-centerPoint.getX(), -centerPoint.getY());
        this.rotate(angle);
        this.translate(centerPoint.getX(), centerPoint.getY());
    }

    public int getAngle(Point p) {
        return this.getAngle(p, this.getRadius(), this.getRadius());
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.getBoundingBox(this.radius, this.radius);
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public int getLength() {
        return Math.abs(this.getTotalAngle());
    }

    @Override
    public Point getPointAtLength(int alpha) {
        return this.getPointAtLength(this.getStartAngle() + (this.isClockwise ? -alpha : alpha), this.radius, this.radius);
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public int getTotalAngle() {
        return this.totalAngle;
    }

    @Override
    public String getType() {
        return CLOSED_CIRCLE_SEGMENT_TYPE;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{CLOSED_CIRCLE_SEGMENT_TYPE};
    }

    @Override
    public void initializeWithDefaults(String primitiveName) {
        super.initializeWithDefaults(primitiveName);
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.isClockwise = config.getDefaultBooleanValue(this.getType(), "clockwise", false);
        this.startAngle = config.getDefaultIntValue(this.getType(), "startAngle", 0);
        this.totalAngle = config.getDefaultIntValue(this.getType(), "totalAngle", 90);
    }

    public boolean isClockwise() {
        return this.isClockwise;
    }

    public void setClockwise(boolean isOrientationClockwise) {
        if (this.isClockwise != isOrientationClockwise) {
            if (isOrientationClockwise) {
                this.setTotalAngle((this.getTotalAngle() - 360) % 360);
            } else {
                this.setTotalAngle((360 + this.getTotalAngle()) % 360);
            }
        }
        this.isClockwise = isOrientationClockwise;
    }

    @Override
    public void setRadius(int r) {
        this.radius = Math.abs(r);
    }

    public void setStartAngle(int angle) {
        this.startAngle = angle;
    }

    public void setTotalAngle(int angle) {
        this.totalAngle = angle;
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".clockwise", this.isClockwise());
        defaultProperties.put(String.valueOf(this.getType()) + ".radius", this.getRadius());
        defaultProperties.put(String.valueOf(this.getType()) + ".startAngle", this.getStartAngle());
        defaultProperties.put(String.valueOf(this.getType()) + ".totalAngle", this.getTotalAngle());
    }

    @Override
    public Object clone() {
        PTClosedCircleSegment targetShape = new PTClosedCircleSegment();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTClosedCircleSegment targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setClockwise(this.isClockwise);
        targetShape.setRadius(this.getRadius());
        targetShape.setStartAngle(this.getStartAngle());
        targetShape.setTotalAngle(this.totalAngle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        String prefix = this.toString(this.getType(), false, this.radius, this.radius);
        sb.append(prefix);
        sb.append(", starts at ").append(this.getStartAngle());
        sb.append(", angle=").append(this.getTotalAngle());
        if (this.isClockwise) {
            sb.append(" clockwise");
        }
        return sb.toString();
    }
}

