/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.xaal;

import animal.exchange.xaal.Exporter;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.meta.FillablePrimitive;
import java.awt.Color;
import java.awt.Point;
import java.io.PrintWriter;
import java.util.HashMap;

public abstract class PTGraphicObjectExporter
implements Exporter {
    public abstract void exportTo(PrintWriter var1, PTGraphicObject var2);

    public abstract void gatherGraphicSettingsTo(PTGraphicObject var1, HashMap<String, String> var2);

    public void exportColor(PrintWriter pw, Color color) {
        this.exportColor(pw, color, "color");
    }

    public void exportColor(PrintWriter pw, Color color, String key) {
        pw.print(key);
        pw.print(" (");
        pw.print(color.getRed());
        pw.print(",");
        pw.print(color.getGreen());
        pw.print(",");
        pw.print(color.getBlue());
        pw.print(") ");
    }

    public void exportCommonEndAttributesTo(PrintWriter pw, PTGraphicObject shape, String tag) {
        pw.print("    <depth value=\"");
        pw.print(shape.getDepth());
        pw.println("\"/>");
        pw.print("  </");
        pw.print(tag);
        pw.println(">");
    }

    public void exportCommonStartAttributesTo(PrintWriter pw, PTGraphicObject shape, String tag) {
        pw.print("<");
        pw.print(tag);
        pw.print(" id=\"");
        pw.print(shape.getNum(false));
        pw.print("\" hidden=\"false\">");
    }

    public void exportFillSettings(PrintWriter pw, FillablePrimitive shape) {
        if (shape.isFilled()) {
            pw.print("filled ");
            this.exportColor(pw, shape.getFillColor(), "fillColor");
        }
    }

    public void exportNode(PrintWriter pw, Point node) {
        pw.print("x=\"");
        pw.print(node.x);
        pw.print("\" y=\"");
        pw.print(node.y);
        pw.print("\"");
    }

    public void exportNode(PrintWriter pw, PTPoint node) {
        if (node != null) {
            this.exportNode(pw, node.toPoint());
        }
    }

    public void exportNode(PrintWriter pw, Point node, String key) {
        pw.print("<");
        pw.print(key);
        this.exportNode(pw, node);
        pw.println(" />");
    }

    public void exportNode(PrintWriter pw, PTPoint node, String key) {
        pw.print("<");
        pw.print(key);
        pw.print(' ');
        this.exportNode(pw, node);
        pw.println(" />");
    }
}

