/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalscript2;

import algoanim.exceptions.NotEnoughNodesException;
import algoanim.primitives.Polygon;
import algoanim.primitives.generators.Language;
import algoanim.properties.PolygonProperties;
import algoanim.util.Node;
import algoanim.util.Timing;
import animal.exchange.animalscript2.PTGraphicObjectExporter;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolygon;
import java.util.Vector;

public class PTPolygonExporter
extends PTGraphicObjectExporter {
    @Override
    public void export(Language lang, PTGraphicObject ptgo, boolean isVisible, int offset, int duration, boolean timeUnitIsTicks) {
        PTPolygon shape = (PTPolygon)ptgo;
        if (PTPolygonExporter.getExportStatus(shape)) {
            lang.addLine("# previously exported: '" + shape.getNum(false) + "/" + shape.getObjectName());
        }
        Node[] vertices = new Node[shape.getNodeCount()];
        Vector<PTPoint> nodes = shape.getNodes();
        int pos = 0;
        for (PTPoint node : nodes) {
            vertices[pos++] = Node.convertToNode(node.toPoint());
        }
        PolygonProperties pp = new PolygonProperties();
        this.installStandardProperties(pp, shape, isVisible);
        pp.set("filled", shape.isFilled());
        if (shape.isFilled()) {
            pp.set("fillColor", shape.getFillColor());
        }
        Timing t = this.createTiming(lang, offset, timeUnitIsTicks);
        Polygon result = null;
        try {
            result = lang.newPolygon(vertices, shape.getObjectName(), t, pp);
            hasBeenExported.put(shape.getNum(false), result);
        }
        catch (NotEnoughNodesException nee) {
            lang.addLine("# could not export, not enough nodes: " + shape.getNodeCount());
        }
    }
}

