/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalscript2;

import algoanim.primitives.Arc;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArcProperties;
import algoanim.util.Coordinates;
import algoanim.util.Node;
import algoanim.util.Timing;
import animal.exchange.animalscript2.PTGraphicObjectExporter;
import animal.graphics.PTArc;
import animal.graphics.PTGraphicObject;

public class PTArcExporter
extends PTGraphicObjectExporter {
    @Override
    public void export(Language lang, PTGraphicObject ptgo, boolean isVisible, int offset, int duration, boolean timeUnitIsTicks) {
        PTArc shape = (PTArc)ptgo;
        if (PTArcExporter.getExportStatus(shape)) {
            lang.addLine("# previously exported: '" + shape.getNum(false) + "/" + shape.getObjectName());
        }
        Coordinates center = Node.convertToNode(shape.getCenter());
        Coordinates radius = Node.convertToNode(shape.getRadiusPoint());
        ArcProperties ap = new ArcProperties();
        this.installStandardProperties(ap, shape, isVisible);
        ap.set("filled", shape.isFilled());
        if (shape.isFilled()) {
            ap.set("fillColor", shape.getFillColor());
        }
        ap.set("angle", shape.getTotalAngle());
        ap.set("startAngle", shape.getStartAngle());
        ap.set("clockwise", shape.isClockwise());
        ap.set("counterclockwise", !shape.isClockwise());
        ap.set("closed", shape.isClosed());
        ap.set("fillColor", shape.isFilled());
        if (shape.isFilled()) {
            ap.set("filled", shape.getFillColor());
        }
        ap.set("bwArrow", shape.hasBWArrow());
        ap.set("fwArrow", shape.hasFWArrow());
        Timing t = this.createTiming(lang, offset, timeUnitIsTicks);
        Arc result = lang.newArc(center, radius, shape.getObjectName(), t, ap);
        hasBeenExported.put(shape.getNum(false), result);
    }
}

