/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectImporter;
import animal.graphics.PTIntArray;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import java.awt.Font;
import java.io.IOException;
import java.io.StreamTokenizer;

public class PTIntArrayImporter
extends PTGraphicObjectImporter {
    @Override
    public Object importFrom(int version, StreamTokenizer stok) {
        PTIntArray array;
        try {
            array = new PTIntArray();
            if (version > array.getFileVersion()) {
                ParseSupport.formatException2("fileVersionMismatch", new Object[]{String.valueOf(version), String.valueOf(array.getFileVersion()), stok.toString()});
            }
            ParseSupport.parseMandatoryWord(stok, "IntArray keyword 'size'", "size");
            int size = ParseSupport.parseInt(stok, "size", 0);
            array = new PTIntArray(size);
            ParseSupport.parseMandatoryWord(stok, "IntArray keyword 'entries'", "entries");
            ParseSupport.parseMandatoryChar(stok, "{", '{');
            int i = 0;
            while (i < size) {
                array.enterValue(i, ParseSupport.parseInt(stok, "IntArray[" + i + "]"));
                ++i;
            }
            ParseSupport.parseMandatoryChar(stok, "}", '}');
            ParseSupport.parseMandatoryWord(stok, "IntArray location", "location");
            array.setOrigin(ParseSupport.parseNode(stok, "location"));
            array.setBGColor(ParseSupport.parseColor(stok, "background color", "bgColor"));
            ParseSupport.parseMandatoryWord(stok, "IntArray keyword 'font'", "font");
            ParseSupport.parseMandatoryChar(stok, "IntArray keyword font '('", '(');
            String fontName = ParseSupport.parseWord(stok, "font name");
            ParseSupport.parseMandatoryChar(stok, "IntArray keyword font ','", ',');
            int fontSize = ParseSupport.parseInt(stok, "font size");
            ParseSupport.parseMandatoryChar(stok, "IntArray keyword font ')'", ')');
            Font font = new Font(fontName, 0, fontSize);
            array.setFont(font);
            array.setFontColor(ParseSupport.parseColor(stok, "IntArray font color", "fontColor"));
            array.setOutlineColor(ParseSupport.parseColor(stok, "IntArray outline color", "outlineColor"));
            array.setHighlightColor(ParseSupport.parseColor(stok, "IntArray highlight color", "highlightColor"));
            if (version >= 3) {
                array.setElemHighlightColor(ParseSupport.parseColor(stok, "IntArray element highlight color", "elementHighlightColor"));
            }
            if (version >= 2) {
                array.showIndices(ParseSupport.parseOptionalWord(stok, "Show cell indices?", "showIndices"));
            }
            ParseSupport.parseMandatoryWord(stok, "IntArray keyword 'depth'", "depth");
            array.setDepth(ParseSupport.parseInt(stok, "IntArray depth", 2));
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
            array = new PTIntArray();
        }
        return array;
    }
}

