/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectImporter;
import animal.graphics.PTGraph;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import java.awt.Font;
import java.io.IOException;
import java.io.StreamTokenizer;

public class PTGraphImporter
extends PTGraphicObjectImporter {
    @Override
    public Object importFrom(int version, StreamTokenizer stok) {
        PTGraph graph;
        try {
            graph = new PTGraph();
            if (version > graph.getFileVersion()) {
                ParseSupport.formatException2("fileVersionMismatch", new Object[]{String.valueOf(version), String.valueOf(graph.getFileVersion()), stok.toString()});
            }
            ParseSupport.parseMandatoryWord(stok, "StringArray keyword 'size'", "size");
            int size = ParseSupport.parseInt(stok, "size", 0);
            graph.setSize(size);
            ParseSupport.parseMandatoryWord(stok, "StringArray origin", "origin");
            graph.setOrigin(ParseSupport.parseNode(stok, "location"));
            ParseSupport.parseMandatoryWord(stok, "StringArray keyword 'nodes'", "nodes");
            ParseSupport.parseMandatoryChar(stok, "{", '{');
            int i = 0;
            while (i < size) {
                graph.enterValueNode(i, ParseSupport.parseText(stok, "Graph[" + i + "]"));
                graph.getPTTextNode(i).setLocation(ParseSupport.parseNode(stok, "Text location " + i));
                graph.getNode(i).setCenter(ParseSupport.parseNode(stok, "Node location " + i));
                graph.getNode(i).setRadius(ParseSupport.parseInt(stok, "Node radius " + i));
                ++i;
            }
            ParseSupport.parseMandatoryChar(stok, "}", '}');
            ParseSupport.parseMandatoryWord(stok, "StringArray keyword 'edges'", "edges");
            ParseSupport.parseMandatoryChar(stok, "{", '{');
            i = 0;
            while (i < size) {
                int j = 0;
                while (j < size) {
                    graph.enterValueEdge(i, j, ParseSupport.parseText(stok, "Graph[" + i + "," + j + "]"));
                    ++j;
                }
                ++i;
            }
            ParseSupport.parseMandatoryChar(stok, "}", '}');
            ParseSupport.parseMandatoryWord(stok, "StringArray keyword 'nodeFont'", "nodeFont");
            ParseSupport.parseMandatoryChar(stok, "StringArray keyword node font '('", '(');
            String fontName = ParseSupport.parseWord(stok, "node font name");
            ParseSupport.parseMandatoryChar(stok, "StringArray keyword node font ','", ',');
            int fontSize = ParseSupport.parseInt(stok, "font size");
            ParseSupport.parseMandatoryChar(stok, "StringArray keyword node font ')'", ')');
            Font font = new Font(fontName, 0, fontSize);
            graph.setNodeFont(font);
            ParseSupport.parseMandatoryWord(stok, "StringArray keyword 'edgeFont'", "edgeFont");
            ParseSupport.parseMandatoryChar(stok, "StringArray keyword edge font '('", '(');
            fontName = ParseSupport.parseWord(stok, "edge font name");
            ParseSupport.parseMandatoryChar(stok, "StringArray keyword edge font ','", ',');
            fontSize = ParseSupport.parseInt(stok, "font size");
            ParseSupport.parseMandatoryChar(stok, "StringArray keyword edge font ')'", ')');
            font = new Font(fontName, 0, fontSize);
            graph.setEdgeFont(font);
            graph.setBGColor(ParseSupport.parseColor(stok, "background color", "bgColor"));
            graph.setNodeFontColor(ParseSupport.parseColor(stok, "Graph node font color", "nodeFontColor"));
            graph.setEdgeFontColor(ParseSupport.parseColor(stok, "Graph edge font color", "edgeFontColor"));
            graph.setOutlineColor(ParseSupport.parseColor(stok, "Graph outline color", "outlineColor"));
            graph.setHighlightColor(ParseSupport.parseColor(stok, "Graph highlight color", "highlightColor"));
            graph.setElemHighlightColor(ParseSupport.parseColor(stok, "Graph element highlight color", "elementHighlightColor"));
            graph.setDirection(ParseSupport.parseOptionalWord(stok, "Direction?", "direction"));
            graph.setWeight(ParseSupport.parseOptionalWord(stok, "Weight?", "weight"));
            graph.setIndices(ParseSupport.parseOptionalWord(stok, "Show cell indices?", "showIndices"));
            ParseSupport.parseMandatoryWord(stok, "StringArray keyword 'depth'", "depth");
            graph.setDepth(ParseSupport.parseInt(stok, "StringArray depth", 2));
            graph.setEdges();
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
            graph = new PTGraph();
        }
        return graph;
    }
}

