/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.graphics;

import animal.editor.Editor;
import animal.editor.graphics.PolygonalShapeEditor;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTRectangle;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import translator.AnimalTranslator;
import translator.TranslatableGUIElement;

public class RectangleEditor
extends PolygonalShapeEditor
implements ItemListener,
ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -2413776784253970663L;

    @Override
    protected void buildGUI() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        Box contentBox = this.createCommonElements(generator);
        this.filledCB = generator.generateJCheckBox("GenericEditor.filled", null, this);
        this.filledCB.addItemListener(this);
        contentBox.add(this.filledCB);
        this.finishBoxes();
    }

    @Override
    public int pointsNeeded() {
        return 2;
    }

    @Override
    public boolean nextPoint(int num, Point p) {
        PTRectangle rectangle = (PTRectangle)this.getCurrentObject();
        if (num == 1) {
            rectangle.setStartNode(p.x, p.y);
        }
        if (num == 2) {
            Point firstNode = rectangle.getStartNode();
            rectangle.setSize(new Dimension(p.x - firstNode.x, p.y - firstNode.y));
        }
        return true;
    }

    @Override
    public int getMinDist(PTGraphicObject go, Point p) {
        PTRectangle pg = (PTRectangle)go;
        Point a = new Point(pg.getStartNode().x, pg.getStartNode().y);
        Rectangle boundingBox = pg.getBoundingBox();
        if (boundingBox.contains(p.x, p.y)) {
            return 0;
        }
        Point b = new Point(a.x + pg.getWidth(), a.y);
        int minDist = Integer.MAX_VALUE;
        int newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        b.translate(0, pg.getHeight());
        newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        a.translate(pg.getWidth(), pg.getHeight());
        newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        if ((newDist = MSMath.dist(p, a, pg.getStartNode())) < minDist) {
            minDist = newDist;
        }
        return minDist;
    }

    @Override
    public EditPoint[] getEditPoints(PTGraphicObject go) {
        PTRectangle pg = (PTRectangle)go;
        int width = pg.getWidth();
        int height = pg.getHeight();
        EditPoint[] result = new EditPoint[5];
        Point helper = pg.getStartNode();
        helper = new Point(helper.x + width, helper.y + height);
        result[0] = new EditPoint(2, helper);
        int x = pg.getStartNode().x;
        int y = pg.getStartNode().y;
        result[1] = new EditPoint(-2, new Point(x + width / 2, y));
        result[2] = new EditPoint(-3, new Point(x + width, y + height / 2));
        result[3] = new EditPoint(-4, new Point(x + width / 2, y + height));
        result[4] = new EditPoint(-5, new Point(x, y + height / 2));
        return result;
    }

    @Override
    public void setProperties(XProperties props) {
        this.colorChooser.setColor(props.getColorProperty("Rectangle.color", Color.black));
        this.depthBox.setSelectedItem(props.getProperty("Rectangle.depth", "16"));
        this.fillColorChooser.setColor(props.getColorProperty("Rectangle.color", Color.black));
        this.filledCB.setSelected(props.getBoolProperty("Rectangle.filled"));
    }

    @Override
    public void getProperties(XProperties props) {
        props.put("Rectangle.color", this.colorChooser.getColor());
        props.put((Object)"Rectangle.depth", this.depthBox.getSelectedItem());
        props.put("Rectangle.fillColor", this.fillColorChooser.getColor());
        props.put("Rectangle.filled", this.filledCB.isSelected());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        PTRectangle p = (PTRectangle)this.getCurrentObject();
        if (e.getSource() == this.filledCB && p != null) {
            p.setFilled(this.filledCB.isSelected());
        }
        Animation.get().doChange();
        this.repaintNow();
    }

    @Override
    public EditableObject createObject() {
        PTRectangle pg = new PTRectangle();
        this.storeAttributesInto(pg);
        return pg;
    }

    @Override
    protected void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTRectangle p = (PTRectangle)eo;
        p.setColor(this.colorChooser.getColor());
        p.setFilled(this.filledCB.isSelected());
        p.setFillColor(this.fillColorChooser.getColor());
    }

    @Override
    protected void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTRectangle p = (PTRectangle)eo;
        this.colorChooser.setColor(p.getColor());
        this.filledCB.setEnabled(true);
        this.filledCB.setSelected(p.isFilled());
        this.fillColorChooser.setColor(p.getFillColor());
    }

    @Override
    public Editor getSecondaryEditor(EditableObject go) {
        RectangleEditor result = new RectangleEditor();
        result.extractAttributesFrom(go);
        return result;
    }

    @Override
    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("RectangleEditor.statusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        PTRectangle p = (PTRectangle)this.getCurrentObject();
        if (p != null) {
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
            this.repaintNow();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        PTRectangle poly = (PTRectangle)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if ("color".equals(eventName)) {
            poly.setColor((Color)event.getNewValue());
        } else if ("fillColor".equals(eventName)) {
            poly.setFillColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    @Override
    public String getBasicType() {
        return "Rectangle";
    }
}

