/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.graphics;

import animal.editor.Editor;
import animal.editor.graphics.PolygonalShapeEditor;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolygon;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import translator.AnimalTranslator;
import translator.TranslatableGUIElement;

public class PolygonEditor
extends PolygonalShapeEditor
implements ItemListener,
ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -2413776784253970663L;

    @Override
    protected void buildGUI() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        Box contentBox = this.createCommonElements(generator);
        this.filledCB = generator.generateJCheckBox("GenericEditor.filled", null, this);
        this.filledCB.addItemListener(this);
        contentBox.add(this.filledCB);
        this.finishBoxes();
    }

    @Override
    public int pointsNeeded() {
        return -1;
    }

    @Override
    public boolean nextPoint(int num, Point p) {
        PTPolygon pl = (PTPolygon)this.getCurrentObject();
        pl.setNode(num - 1, new PTPoint(p));
        return true;
    }

    @Override
    public int getMinDist(PTGraphicObject go, Point p) {
        Polygon poly;
        PTPolygon pg = (PTPolygon)go;
        if (pg.isFilled() && (poly = pg.toPolygon()).contains(p)) {
            return 0;
        }
        Point b = pg.getNodeAsPoint(0);
        int minDist = Integer.MAX_VALUE;
        int i = 1;
        while (i < pg.getNodeCount()) {
            int newDist;
            Point a = b;
            if (!a.equals(b = pg.getNodeAsPoint(i)) && (newDist = MSMath.dist(p, a, b)) < minDist) {
                minDist = newDist;
            }
            ++i;
        }
        return minDist;
    }

    @Override
    public EditPoint[] getEditPoints(PTGraphicObject go) {
        PTPolygon pg = (PTPolygon)go;
        int pSize = pg.getNodeCount();
        int size = pSize * 2 - 1;
        EditPoint[] result = new EditPoint[size];
        int i = 0;
        while (i < pSize) {
            result[i] = new EditPoint(i + 1, pg.getNodeAsPoint(i));
            ++i;
        }
        Point b = pg.getNodeAsPoint(0);
        i = 1;
        while (i < pSize) {
            Point a = b;
            b = pg.getNodeAsPoint(i);
            result[i + pSize - 1] = new EditPoint(-i, new Point((a.x + b.x) / 2, (a.y + b.y) / 2));
            ++i;
        }
        return result;
    }

    @Override
    public void setProperties(XProperties props) {
        this.colorChooser.setColor(props.getColorProperty("Polygon.color", Color.black));
        this.depthBox.setSelectedItem(props.getProperty("Polygon.depth", "16"));
        this.fillColorChooser.setColor(props.getColorProperty("Polygon.fillColor", Color.black));
        this.filledCB.setSelected(props.getBoolProperty("Polygon.filled"));
    }

    @Override
    public void getProperties(XProperties props) {
        props.put("Polygon.color", this.colorChooser.getColor());
        props.put((Object)"Polygon.depth", this.depthBox.getSelectedItem());
        props.put("Polygon.fillColor", this.fillColorChooser.getColor());
        props.put("Polygon.filled", this.filledCB.isSelected());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        PTPolygon p = (PTPolygon)this.getCurrentObject();
        if (e.getSource() == this.filledCB && p != null) {
            p.setFilled(this.filledCB.isSelected());
        }
        Animation.get().doChange();
        this.repaintNow();
    }

    @Override
    public EditableObject createObject() {
        PTPolygon pg = new PTPolygon();
        this.storeAttributesInto(pg);
        return pg;
    }

    @Override
    protected void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTPolygon p = (PTPolygon)eo;
        p.setColor(this.colorChooser.getColor());
        p.setFillColor(this.fillColorChooser.getColor());
        p.setFilled(this.filledCB.isSelected());
        p.setObjectName(this.objectNameField.getText());
    }

    @Override
    protected void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTPolygon p = (PTPolygon)eo;
        this.colorChooser.setColor(p.getColor());
        this.fillColorChooser.setColor(p.getFillColor());
        this.filledCB.setSelected(p.isFilled());
        this.objectNameField.setText(p.getObjectName());
    }

    @Override
    public Editor getSecondaryEditor(EditableObject go) {
        PolygonEditor result = new PolygonEditor();
        result.extractAttributesFrom(go);
        return result;
    }

    @Override
    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("PolygonEditor.statusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        PTPolygon p = (PTPolygon)this.getCurrentObject();
        if (p != null) {
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
            this.repaintNow();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        PTPolygon poly = (PTPolygon)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if ("color".equals(eventName)) {
            poly.setColor((Color)event.getNewValue());
        } else if ("fillColor".equals(eventName)) {
            poly.setFillColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    @Override
    public String getBasicType() {
        return "Polygon";
    }
}

