/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.graphics;

import animal.editor.Editor;
import animal.editor.graphics.ArcBasedShapeEditor;
import animal.graphics.PTCircle;
import animal.graphics.PTGraphicObject;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import translator.AnimalTranslator;
import translator.TranslatableGUIElement;

public class CircleEditor
extends ArcBasedShapeEditor
implements ItemListener,
ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -2413776784253970663L;

    @Override
    protected void buildGUI() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        Box contentBox = this.createCommonElements(generator);
        this.filledCB = generator.generateJCheckBox("GenericEditor.filled", null, this);
        this.filledCB.addItemListener(this);
        contentBox.add(this.filledCB);
        this.finishBoxes();
    }

    @Override
    public int pointsNeeded() {
        return 2;
    }

    @Override
    public boolean nextPoint(int num, Point p) {
        PTCircle shape = (PTCircle)this.getCurrentObject();
        if (num == 1) {
            shape.setCenter(p.x, p.y);
        }
        if (num == 2) {
            shape.setRadius(Math.abs(p.x - shape.getCenter().x));
        }
        return true;
    }

    @Override
    public int getMinDist(PTGraphicObject go, Point p) {
        PTCircle pg = (PTCircle)go;
        Point a = new Point(pg.getCenter().x, pg.getCenter().y);
        Rectangle boundingBox = pg.getBoundingBox();
        if (boundingBox.contains(p.x, p.y)) {
            return 0;
        }
        Point b = new Point(a.x + pg.getRadius(), a.y);
        int minDist = Integer.MAX_VALUE;
        int newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        b.translate(0, pg.getRadius());
        newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        a.translate(pg.getRadius(), pg.getRadius());
        newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        if ((newDist = MSMath.dist(p, a, pg.getCenter())) < minDist) {
            minDist = newDist;
        }
        return minDist;
    }

    @Override
    public EditPoint[] getEditPoints(PTGraphicObject go) {
        PTCircle pg = (PTCircle)go;
        int radius = pg.getRadius();
        EditPoint[] result = new EditPoint[5];
        Point helper = pg.getCenter();
        int x = helper.x;
        int y = helper.y;
        int nr = 0;
        result[nr++] = new EditPoint(2, new Point(x + radius, y + radius));
        result[nr++] = new EditPoint(-1, new Point(x - radius, y));
        result[nr++] = new EditPoint(-2, new Point(x, y + radius));
        result[nr++] = new EditPoint(-3, new Point(x + radius, y));
        result[nr++] = new EditPoint(-4, new Point(x, y - radius));
        return result;
    }

    @Override
    public void setProperties(XProperties props) {
        this.colorChooser.setColor(props.getColorProperty("Circle.color", Color.black));
        this.depthBox.setSelectedItem(props.getProperty("Circle.depth", "16"));
        this.fillColorChooser.setColor(props.getColorProperty("Circle.fillColor", Color.black));
        this.filledCB.setSelected(props.getBoolProperty("Circle.filled"));
    }

    @Override
    public void getProperties(XProperties props) {
        props.put("Circle.color", this.colorChooser.getColor());
        props.put((Object)"Circle.depth", this.depthBox.getSelectedItem());
        props.put("Circle.fillColor", this.fillColorChooser.getColor());
        props.put("Circle.filled", this.filledCB.isSelected());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        PTCircle p = (PTCircle)this.getCurrentObject();
        if (e.getSource() == this.filledCB && p != null) {
            p.setFilled(this.filledCB.isSelected());
        }
        Animation.get().doChange();
        this.repaintNow();
    }

    @Override
    public EditableObject createObject() {
        PTCircle pg = new PTCircle();
        this.storeAttributesInto(pg);
        return pg;
    }

    @Override
    protected void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTCircle p = (PTCircle)eo;
        p.setColor(this.colorChooser.getColor());
        p.setFilled(this.filledCB.isSelected());
        p.setFillColor(this.fillColorChooser.getColor());
    }

    @Override
    protected void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTCircle p = (PTCircle)eo;
        this.colorChooser.setColor(p.getColor());
        this.filledCB.setEnabled(true);
        this.filledCB.setSelected(p.isFilled());
        this.fillColorChooser.setColor(p.getFillColor());
    }

    @Override
    public Editor getSecondaryEditor(EditableObject go) {
        CircleEditor result = new CircleEditor();
        result.extractAttributesFrom(go);
        return result;
    }

    @Override
    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("CircleEditor.statusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        PTCircle p = (PTCircle)this.getCurrentObject();
        if (p != null) {
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
            this.repaintNow();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        PTCircle poly = (PTCircle)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if ("color".equals(eventName)) {
            poly.setColor((Color)event.getNewValue());
        } else if ("fillColor".equals(eventName)) {
            poly.setFillColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    @Override
    public String getBasicType() {
        return "Circle";
    }
}

