/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.editor.Editor;
import animal.editor.SpecialSelector;
import animal.editor.animators.MoveEditor;
import animal.graphics.PTPolyline;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import translator.AnimalTranslator;

public class NodeSelector
extends SpecialSelector
implements ActionListener {
    private static final long serialVersionUID = -1713805631085640216L;
    JFrame displayFrame = new JFrame(AnimalTranslator.translateMessage("nodeSelectTitle"));
    JToggleButton[] selectedToggleButton;
    JPanel checkBoxPanel;
    PTPolyline polyline;
    private boolean[] selectedNodes;
    private int nrSelected = 0;
    AbstractButton okButton;
    AbstractButton applyButton;
    AbstractButton cancelButton;

    public NodeSelector(Editor callingEditor, boolean[] nodeMap, String methodBaseName, boolean enableMultipleMode) {
        super(callingEditor, methodBaseName, enableMultipleMode);
        int i;
        this.parentEditor = callingEditor;
        this.selectedNodes = nodeMap;
        this.baseMethodName = methodBaseName;
        this.displayFrame.getContentPane().setLayout(new BorderLayout());
        JTabbedPane tp = new JTabbedPane();
        int nrNodes = nodeMap.length;
        this.checkBoxPanel = new JPanel(new GridLayout(0, nrNodes < 3 ? nrNodes : nrNodes / 3));
        this.selectedToggleButton = new JCheckBox[nrNodes];
        this.selectedNodes = new boolean[nrNodes];
        if (enableMultipleMode) {
            i = 0;
            while (i < nrNodes) {
                this.selectedToggleButton[i] = new JCheckBox(String.valueOf(AnimalTranslator.translateMessage("node")) + " " + (i + 1), nodeMap[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < nrNodes) {
                this.selectedToggleButton[i] = new JRadioButton(String.valueOf(AnimalTranslator.translateMessage("node")) + " " + (i + 1), nodeMap[i]);
                ++i;
            }
        }
        i = 0;
        while (i < nrNodes) {
            if (nodeMap[i]) {
                ++this.nrSelected;
            }
            this.checkBoxPanel.add(this.selectedToggleButton[i]);
            ++i;
        }
        AnimalTranslator.getGUIBuilder().insertTranslatableTab("nodes", this.checkBoxPanel, tp);
        this.displayFrame.getContentPane().add((Component)tp, "Center");
        this.finish();
    }

    public void finish() {
        GridLayout gridLayout = new GridLayout(1, 0);
        JPanel p = new JPanel(gridLayout);
        this.okButton = AnimalTranslator.getGUIBuilder().generateJButton("GenericEditor.ok", null, false, this);
        p.add(this.okButton);
        this.applyButton = AnimalTranslator.getGUIBuilder().generateJButton("GenericEditor.apply", null, false, this);
        p.add(this.applyButton);
        this.cancelButton = AnimalTranslator.getGUIBuilder().generateJButton("GenericEditor.cancel", null, false, this);
        p.add(this.cancelButton);
        this.displayFrame.getContentPane().add((Component)p, "South");
        this.displayFrame.pack();
        this.displayFrame.setVisible(true);
    }

    private String currentMethod() {
        StringBuilder localBuffer = new StringBuilder(50);
        localBuffer.append(this.baseMethodName);
        int nrNodes = this.selectedNodes.length;
        int i = 0;
        while (i < nrNodes) {
            if (this.selectedToggleButton[i].isSelected()) {
                localBuffer.append(' ').append(i + 1);
            }
            ++i;
        }
        return localBuffer.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.apply()) {
                this.close();
            }
        } else if (e.getSource() == this.applyButton) {
            this.apply();
        } else if (e.getSource() == this.cancelButton) {
            this.close();
        }
    }

    boolean apply() {
        ((MoveEditor)this.parentEditor).setNewMethod(this.currentMethod());
        return true;
    }

    public void close() {
        this.displayFrame.setVisible(false);
        this.displayFrame.dispose();
    }
}

