/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.editor.Editor;
import animal.gui.AnimalMainWindow;
import animal.main.Animal;
import animal.main.Animation;
import animal.main.Link;
import animal.misc.EditableObject;
import animal.misc.ObjectSelectionButton;
import animal.misc.TextUtilities;
import animal.misc.XProperties;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import translator.AnimalTranslator;

public class LinkEditor
extends Editor
implements ItemListener {
    private static final long serialVersionUID = -327517124919975759L;
    private JLabel stepL;
    private JLabel nextStepL;
    private JRadioButton keyCB;
    private JRadioButton timeCB;
    private JRadioButton clickCB;
    private JTextField labelTF;
    private ObjectSelectionButton objectIDSB;
    private JTextField timeTF;
    private JTextField clickPromptTF;

    public LinkEditor() {
        super(AnimalMainWindow.getWindowCoordinator().getAnimationOverview(false));
        GridBagLayout gbl = new GridBagLayout();
        JPanel c = new JPanel(gbl);
        JLabel l = null;
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel p = new JPanel(new FlowLayout(0));
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbl.setConstraints(p, gbc);
        c.add(p);
        p.add(AnimalTranslator.getGUIBuilder().generateJLabel("GenericEditor.step"));
        this.stepL = AnimalTranslator.getGUIBuilder().generateJLabel("GenericEditor.end");
        p.add(this.stepL);
        p.add(AnimalTranslator.getGUIBuilder().generateJLabel("LinkEditor.nextStep"));
        this.nextStepL = AnimalTranslator.getGUIBuilder().generateJLabel("LinkEditor.endOfAnimation");
        p.add(this.nextStepL);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.keyCB = (JRadioButton)AnimalTranslator.getGUIBuilder().generateJToggleButton("LinkEditor.waitKey", null, null, true);
        this.keyCB.addItemListener(this);
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbl.setConstraints(this.keyCB, gbc);
        c.add(this.keyCB);
        buttonGroup.add(this.keyCB);
        this.timeCB = (JRadioButton)AnimalTranslator.getGUIBuilder().generateJToggleButton("LinkEditor.waitTime", null, null, true);
        this.timeCB.addItemListener(this);
        gbc.gridwidth = -1;
        gbl.setConstraints(this.timeCB, gbc);
        c.add(this.timeCB);
        buttonGroup.add(this.timeCB);
        this.timeTF = new JTextField(20);
        gbl.setConstraints(this.timeTF, gbc);
        c.add(this.timeTF);
        l = new JLabel("ms");
        gbc.gridwidth = 0;
        gbl.setConstraints(l, gbc);
        c.add(l);
        this.clickCB = (JRadioButton)AnimalTranslator.getGUIBuilder().generateJToggleButton("LinkEditor.waitObjectClick", null, null, true);
        this.clickCB.addItemListener(this);
        gbc.gridwidth = -1;
        gbl.setConstraints(this.clickCB, gbc);
        buttonGroup.add(this.clickCB);
        c.add(this.clickCB);
        this.objectIDSB = new ObjectSelectionButton(false);
        gbc.gridwidth = 0;
        gbl.setConstraints(this.objectIDSB, gbc);
        c.add(this.objectIDSB);
        buttonGroup.add(this.objectIDSB);
        l = AnimalTranslator.getGUIBuilder().generateJLabel("LinkEditor.clickPromptLabel");
        gbc.gridwidth = 1;
        gbl.setConstraints(l, gbc);
        c.add(l);
        this.clickPromptTF = new JTextField(20);
        gbc.gridwidth = 0;
        gbl.setConstraints(this.clickPromptTF, gbc);
        c.add(this.clickPromptTF);
        l = AnimalTranslator.getGUIBuilder().generateJLabel("LinkEditor.labelLabel");
        gbc.gridwidth = -1;
        gbl.setConstraints(l, gbc);
        c.add(l);
        this.labelTF = new JTextField(20);
        gbc.gridwidth = 0;
        gbl.setConstraints(this.labelTF, gbc);
        c.add(this.labelTF);
        p = new JPanel();
        Action theAction = TextUtilities.findTextFieldAction("cut-to-clipboard");
        p.add(AnimalTranslator.getGUIBuilder().generateActionButton("AbstractTextEditor.cut", theAction));
        theAction = TextUtilities.findTextFieldAction("copy-to-clipboard");
        p.add(AnimalTranslator.getGUIBuilder().generateActionButton("AbstractTextEditor.copy", theAction));
        theAction = TextUtilities.findTextFieldAction("paste-from-clipboard");
        p.add(AnimalTranslator.getGUIBuilder().generateActionButton("AbstractTextEditor.paste", theAction));
        c.add((Component)p, gbc);
        this.addLayer(c);
        this.finish();
    }

    @Override
    public void repaintNow() {
        AnimalMainWindow.getWindowCoordinator().getAnimationOverview(true).initList(false);
    }

    @Override
    public Editor getSecondaryEditor(EditableObject eo) {
        LinkEditor result = new LinkEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    @Override
    public void setProperties(XProperties props) {
    }

    @Override
    public void getProperties(XProperties props) {
    }

    @Override
    public void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        Link link = (Link)eo;
        this.stepL.setText(Animation.getStepString(link.getStep()));
        this.nextStepL.setText(Animation.getStepString(link.getNextStep()));
        this.setInt(this.timeTF, link.getTime());
        this.keyCB.setSelected(link.getMode() == 1);
        this.timeCB.setSelected(link.getMode() == 2);
        this.clickCB.setSelected(link.getMode() == 4);
        this.objectIDSB.setObjectNum(link.getTargetObjectID());
        this.labelTF.setText(link.getLinkLabel());
        this.clickPromptTF.setText(link.getClickPrompt());
    }

    @Override
    public void storeAttributesInto(EditableObject l) {
        super.storeAttributesInto(l);
        Link link = (Link)l;
        link.setTime(this.getInt(this.timeTF.getText(), 0));
        if (this.timeCB.isSelected()) {
            link.setMode(2);
        } else if (this.keyCB.isSelected()) {
            link.setMode(1);
        } else if (this.clickCB.isSelected()) {
            link.setMode(4);
        }
        link.setLinkLabel(this.labelTF.getText());
        int targetVal = this.objectIDSB.getObjectNum();
        link.setTargetObjectID(targetVal);
        link.setClickPrompt(this.clickPromptTF.getText());
        AnimalMainWindow.getWindowCoordinator().getTimeLineWindow(false).updateList(Animal.get().getAnimation());
    }

    @Override
    protected String isOK() {
        return super.isOK();
    }

    @Override
    public EditableObject createObject() {
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.timeTF.setEnabled(this.timeCB.isSelected());
    }
}

