/*
 * Decompiled with CFR 0.152.
 */
package animal.dialog;

import animal.main.Animal;
import animal.main.Animation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import translator.AnimalTranslator;

public class AnimInfoDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 391593064932584620L;
    private static AnimInfoDialog dialog = null;
    private JButton okButton;

    public AnimInfoDialog(Animal animal) {
        super(animal, AnimalTranslator.translateMessage("AnimInfo", null), false);
        JPanel internalPanel = new JPanel();
        Container contentPane = this.getContentPane();
        GridLayout grid = new GridLayout(0, 1);
        internalPanel.setLayout(grid);
        contentPane.setLayout(new BorderLayout());
        Font biggerFont = new Font("SansSerif", 1, 18);
        JLabel l = new JLabel(AnimalTranslator.translateMessage("AnimTitle"), null, 0);
        l.setFont(biggerFont);
        internalPanel.add(l);
        Animation anim = animal.getAnimation();
        String dummy = anim == null || anim.getTitle() == null ? "---" : anim.getTitle();
        internalPanel.add(new JLabel(dummy));
        l = new JLabel(AnimalTranslator.translateMessage("AnimAuthor", null), 0);
        l.setFont(biggerFont);
        internalPanel.add(l);
        dummy = anim == null || anim.getAuthor() == null ? "---" : anim.getAuthor();
        internalPanel.add(new JLabel(dummy));
        this.okButton = new JButton(AnimalTranslator.translateMessage("ok", null));
        this.okButton.setMnemonic(79);
        this.okButton.addActionListener(this);
        contentPane.add((Component)this.okButton, "South");
        contentPane.add((Component)internalPanel, "Center");
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AnimInfoDialog.this.windowClosing();
            }
        });
        dialog = this;
    }

    public static AnimInfoDialog getAnimInfoDialog(Animal animal) {
        if (dialog == null) {
            dialog = new AnimInfoDialog(animal);
        }
        return dialog;
    }

    @Override
    public void setVisible(boolean showIt) {
        if (!this.isVisible()) {
            this.setLocationRelativeTo(this.getParent());
        }
        super.setVisible(showIt);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.okButton) {
            this.windowClosing();
        }
    }

    public void windowClosing() {
        dialog = null;
        this.setVisible(false);
        this.dispose();
    }
}

