/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.TimedAnimator;
import animal.misc.AnimatedAlgorithm;
import animal.misc.MessageDisplay;
import animalscript.core.AnimalScriptParser;
import java.lang.reflect.Method;
import java.util.Hashtable;
import translator.AnimalTranslator;

public class MethodInvocator
extends TimedAnimator {
    public static final String TYPE_LABEL = "MethodInvocator";
    private static final long serialVersionUID = 5542833619518931027L;
    private boolean isConstructorInvocation = false;
    private int tag = 0;
    private String targetClassName = null;
    private String targetMethod = null;
    private static Hashtable<String, Object> externalObjectIDs = new Hashtable(503);

    public MethodInvocator() {
    }

    public MethodInvocator(int step, int objectNum, int totalTimeOrTicks, String method, String classOrMethodName, boolean isConstructor, int parameterTag) {
        this(step, new int[]{objectNum}, totalTimeOrTicks, method, classOrMethodName, isConstructor, parameterTag);
    }

    public MethodInvocator(int step, int[] objectNums, int totalTimeOrTicks, String method, String classOrMethodName, boolean isConstructor, int parameterTag) {
        super(step, objectNums, totalTimeOrTicks, method);
        if (isConstructor) {
            this.setClassName(classOrMethodName);
        } else {
            this.setMethodName(classOrMethodName);
        }
        this.setIsConstructorInvocation(isConstructor);
        this.tag = parameterTag;
    }

    @Override
    public void execute() {
        if (this.isConstructorInvocation) {
            String accessKey = String.valueOf(this.getObjectNums()[0]);
            if (externalObjectIDs.get(accessKey) == null) {
                try {
                    Class<?> c = Class.forName(this.targetClassName);
                    Object invocationTarget = c.newInstance();
                    externalObjectIDs.put(accessKey, invocationTarget);
                }
                catch (Exception e) {
                    MessageDisplay.errorMsg(AnimalTranslator.translateMessage("mthdInvFail", new String[]{e.getClass().getName(), e.getMessage()}), 4);
                }
            } else if (this.getMethod().equalsIgnoreCase("getAnimationCode")) {
                Object invocationTarget = externalObjectIDs.get(String.valueOf(this.getObjectNums()[0]));
                if (invocationTarget instanceof AnimatedAlgorithm) {
                    String animCode = ((AnimatedAlgorithm)invocationTarget).getAnimationCode(this.tag);
                    AnimalScriptParser asp = new AnimalScriptParser();
                    asp.programImport(animCode, false);
                }
            } else {
                try {
                    Object invocationTarget = externalObjectIDs.get(String.valueOf(this.getObjectNums()[0]));
                    Method method = invocationTarget.getClass().getDeclaredMethod(this.targetMethod, null);
                    method.invoke(invocationTarget, null);
                }
                catch (Exception e) {
                    MessageDisplay.errorMsg(AnimalTranslator.translateMessage("mthdInvFail", new String[]{e.getClass().getName(), e.getMessage()}), 4);
                }
            }
        }
        super.execute();
    }

    @Override
    public String getAnimatorName() {
        return TYPE_LABEL;
    }

    public static boolean insertObjectID(String objectID, Object targetObject) {
        if (externalObjectIDs.containsKey(objectID)) {
            return false;
        }
        externalObjectIDs.put(objectID, targetObject);
        return true;
    }

    public static Object getObject(String objectID) {
        return externalObjectIDs.get(objectID);
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public Object getProperty(double factor) {
        return new Integer(42);
    }

    public String getClassName() {
        return this.targetClassName;
    }

    @Override
    public String getMethod() {
        return this.isConstructorInvocation ? this.targetClassName : this.targetMethod;
    }

    public boolean isConstructorInvocation() {
        return this.isConstructorInvocation;
    }

    public void setIsConstructorInvocation(boolean isConstructor) {
        this.isConstructorInvocation = isConstructor;
    }

    public void setClassName(String className) {
        this.targetClassName = className;
    }

    public void setMethodName(String methodName) {
        this.targetMethod = methodName;
    }

    @Override
    public String getType() {
        return TYPE_LABEL;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{"MethodInvocation"};
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("invoke ");
        sb.append(this.isConstructorInvocation() ? " constructor " : "method ");
        sb.append(this.getMethod()).append(" on ").append(super.toString());
        return sb.toString();
    }
}

