/*
 * Decompiled with CFR 0.152.
 */
package algoanim.variables;

import algoanim.variables.VariableObserver;
import algoanim.variables.VariableTypes;
import java.util.Vector;

public abstract class Variable {
    private VariableTypes type;
    private Boolean isGlobal = false;
    private Vector<VariableObserver> observers = new Vector();

    public Variable(VariableTypes type) {
        this.type = type;
    }

    public VariableTypes getType() {
        return this.type;
    }

    public void setGlobal() {
        this.isGlobal = true;
    }

    public Boolean isGlobal() {
        return this.isGlobal;
    }

    public abstract void setValue(Variable var1);

    public abstract void setValue(Boolean var1);

    public abstract void setValue(Byte var1);

    public abstract void setValue(Double var1);

    public abstract void setValue(Float var1);

    public abstract void setValue(Integer var1);

    public abstract void setValue(Long var1);

    public abstract void setValue(Short var1);

    public abstract void setValue(String var1);

    public Class<?> getAssociatedClass() {
        return this.type.getAssociatedClass();
    }

    public abstract <T> T getValue(Class<T> var1);

    protected void setError(String value) {
        System.err.println("Unable to set '" + value + "', old value persists");
    }

    public abstract String toString();

    protected void update() {
        for (VariableObserver obs : this.observers) {
            obs.update();
        }
    }

    public void addObserver(VariableObserver obs) {
        this.observers.add(obs);
    }

    public void removeObserver(VariableObserver obs) {
        this.observers.remove(obs);
    }
}

