/*
 * Decompiled with CFR 0.152.
 */
package algoanim.variables;

import algoanim.variables.Variable;
import algoanim.variables.VariableTypes;

public class IntegerVariable
extends Variable {
    private static final Integer defaultValue = 0;
    private Integer value;

    public IntegerVariable() {
        this(defaultValue);
    }

    public IntegerVariable(Integer value) {
        super(VariableTypes.INTEGER);
        this.value = value;
    }

    @Override
    public <T> T getValue(Class<T> type) {
        T result = null;
        if (type == Boolean.class) {
            Boolean b = this.value != 0;
            result = type.cast(b);
        } else if (type == Byte.class) {
            Byte b = this.value.byteValue();
            result = type.cast(b);
        } else if (type == Double.class) {
            Double d = this.value.doubleValue();
            result = type.cast(d);
        } else if (type == Float.class) {
            Float f = Float.valueOf(this.value.floatValue());
            result = type.cast(f);
        } else if (type == Integer.class) {
            result = type.cast(this.value);
        } else if (type == Long.class) {
            Long l = this.value.longValue();
            result = type.cast(l);
        } else if (type == Short.class) {
            Short s = this.value.shortValue();
            result = type.cast(s);
        } else if (type == String.class) {
            String s = this.value.toString();
            result = type.cast(s);
        } else {
            System.err.println("cannot cast variable to: " + type);
        }
        return result;
    }

    @Override
    public void setValue(Boolean value) {
        if (value.booleanValue()) {
            this.setValue(1);
        } else {
            this.setValue(0);
        }
    }

    @Override
    public void setValue(Byte value) {
        this.setValue(value.intValue());
    }

    @Override
    public void setValue(Double value) {
        this.setValue(value.intValue());
    }

    @Override
    public void setValue(Float value) {
        this.setValue(value.intValue());
    }

    @Override
    public void setValue(Integer value) {
        this.value = value;
        this.update();
    }

    @Override
    public void setValue(Long value) {
        this.setValue(value.intValue());
    }

    @Override
    public void setValue(Short value) {
        this.setValue(value.intValue());
    }

    @Override
    public void setValue(String value) {
        block9: {
            try {
                this.setValue(Integer.parseInt(value));
            }
            catch (NumberFormatException eInt) {
                try {
                    this.setValue(Float.valueOf(Float.parseFloat(value)));
                }
                catch (NumberFormatException eFloat) {
                    try {
                        this.setValue(Double.parseDouble(value));
                    }
                    catch (NumberFormatException eDouble) {
                        if ("TRUE".equalsIgnoreCase(value) || "FALSE".equalsIgnoreCase(value)) {
                            try {
                                this.setValue(Boolean.parseBoolean(value));
                            }
                            catch (NumberFormatException eBool) {
                                this.setError(value);
                            }
                            break block9;
                        }
                        this.setError(value);
                    }
                }
            }
        }
    }

    @Override
    public void setValue(Variable var) {
        this.setValue(var.getValue(Integer.class));
    }

    public static void main(String[] args) {
        Double d1 = 0.3;
        Double d2 = 0.8;
        Integer i1 = new Double(d1 + d2).intValue();
        Integer i2 = d1.intValue() + d2.intValue();
        Integer i3 = 3;
        System.out.println("i1=" + i1 + ", i2=" + i2 + ", i3=" + i3);
        System.out.println(String.valueOf(new Float(2.1474836E9f).intValue()) + "/" + Integer.MAX_VALUE);
    }

    @Override
    public String toString() {
        return this.value.toString();
    }
}

