/*
 * Decompiled with CFR 0.152.
 */
package algoanim.primitives;

import algoanim.primitives.Primitive;
import algoanim.primitives.generators.VariablesGenerator;
import algoanim.util.DisplayOptions;
import algoanim.variables.Variable;
import algoanim.variables.VariableContext;
import java.util.HashMap;

public class Variables
extends Primitive {
    protected VariablesGenerator gen;
    protected VariableContext vars;
    protected HashMap<String, String> list;

    public Variables(VariablesGenerator gen, DisplayOptions display) {
        super(gen, display);
        this.gen = gen;
        this.vars = new VariableContext();
        this.list = this.vars.listContext();
    }

    public void setGlobal(String key) {
        this.vars.setGlobal(key);
        this.updateView();
    }

    public void openContext() {
        this.vars = this.vars.contextOpen();
        this.updateView();
    }

    public void closeContext() {
        this.vars = this.vars.contextClose();
        this.updateView();
    }

    public void declare(String type, String key) {
        this.vars.defineKey(type, key);
        this.updateView();
    }

    public void declare(String type, String key, String value) {
        this.vars.defineKey(type, key, value);
        this.updateView();
    }

    public void set(String key, String value) {
        this.vars.setValue(key, value);
        this.updateView();
    }

    public String get(String key) {
        return this.vars.getString(key);
    }

    public Variable getVariable(String key) {
        return this.vars.getVariable(key);
    }

    public void discard(String key) {
        this.vars.deleteKey(key);
        this.updateView();
    }

    protected void updateView() {
        HashMap<String, String> newList = this.vars.listContext();
        for (String key : this.list.keySet()) {
            if (newList.containsKey(key)) continue;
            this.gen.discard(key);
        }
        for (String key : newList.keySet()) {
            if (!this.list.containsKey(key)) {
                this.gen.declare(key, newList.get(key));
                continue;
            }
            if (this.list.get(key) == newList.get(key)) continue;
            this.gen.update(key, newList.get(key));
        }
        this.list = newList;
    }
}

