/*
 * Decompiled with CFR 0.152.
 */
package algoanim.primitives;

import algoanim.exceptions.LineNotExistsException;
import algoanim.primitives.Primitive;
import algoanim.primitives.generators.SourceCodeGenerator;
import algoanim.properties.SourceCodeProperties;
import algoanim.util.DisplayOptions;
import algoanim.util.Node;
import algoanim.util.Timing;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;

public class SourceCode
extends Primitive {
    protected SourceCodeProperties properties;
    protected SourceCodeGenerator generator;
    protected Node upperLeft;
    protected LinkedList<String> lines;
    protected HashMap<String, Integer> labelLines;
    protected HashMap<String, Integer> labelRows;
    protected Integer actRow;
    protected Vector<String> highlightedLabels;

    public SourceCode(SourceCodeGenerator generator, Node upperLeft, String name, DisplayOptions display, SourceCodeProperties properties) {
        super(generator, display);
        this.upperLeft = upperLeft;
        this.properties = properties;
        this.setName(name);
        this.generator = generator;
        this.lines = new LinkedList();
        this.labelLines = new HashMap();
        this.labelRows = new HashMap();
        this.actRow = 0;
        this.highlightedLabels = new Vector();
        generator.create(this);
    }

    @Override
    public void setName(String newName) {
        this.properties.setName(newName);
        super.setName(newName);
    }

    public void registerLabel(String label, int lineNo) {
        this.registerLabel(label, lineNo, 0);
    }

    public void registerLabel(String label, int lineNo, int rowNo) {
        if (label != null && lineNo >= 0 && rowNo >= 0) {
            this.labelLines.put(label, new Integer(lineNo));
            this.labelRows.put(label, new Integer(rowNo));
        }
    }

    public SourceCodeProperties getProperties() {
        return this.properties;
    }

    public Node getUpperLeft() {
        return this.upperLeft;
    }

    public int addCodeLine(String code, String label, int indentation, Timing delay) throws NullPointerException {
        if (code != null) {
            this.lines.add(code);
            this.generator.addCodeLine(this, code, label, indentation, delay);
            int thisLineNo = this.lines.size() - 1;
            this.actRow = 0;
            if (label != null) {
                this.registerLabel(label, thisLineNo);
            }
            return thisLineNo;
        }
        throw new NullPointerException("Please provide a code line.");
    }

    public int addCodeElement(String code, String label, int indentation, Timing delay) throws NullPointerException {
        if (code == null) {
            throw new NullPointerException("Please provide a code line.");
        }
        this.actRow = this.actRow + 1;
        int lineNo = this.lines.size() - 1;
        if (label != null) {
            this.registerLabel(label, lineNo, this.actRow);
        }
        this.generator.addCodeElement(this, code, label, indentation, this.actRow, delay);
        return lineNo;
    }

    public void highlight(String label) throws LineNotExistsException {
        this.highlight(label, false);
    }

    public void highlight(String label, boolean context) throws LineNotExistsException {
        this.highlight(label, context, null, null);
    }

    public void highlight(String label, boolean context, Timing delay, Timing duration) throws LineNotExistsException {
        Integer lineNo = this.labelLines.get(label);
        Integer rowNo = this.labelRows.get(label);
        if (lineNo == null || rowNo == null) {
            System.err.println("label not found: " + label);
        } else {
            this.highlight(lineNo, rowNo, context, delay, duration);
            if (!this.highlightedLabels.contains(label)) {
                this.highlightedLabels.add(label);
            }
        }
    }

    public void highlight(int lineNo) throws LineNotExistsException {
        this.highlight(lineNo, 0, false);
    }

    public void highlight(int lineNo, int colNo, boolean context) throws LineNotExistsException {
        this.highlight(lineNo, colNo, context, null, null);
    }

    public void highlight(int lineNo, int colNo, boolean context, Timing delay, Timing duration) throws LineNotExistsException {
        if (lineNo >= this.lines.size()) {
            throw new LineNotExistsException("lineNo \"" + lineNo + "\" too high");
        }
        this.generator.highlight(this, lineNo, colNo, context, delay, duration);
    }

    public void unhighlight(String label) throws LineNotExistsException {
        this.unhighlight(label, false);
    }

    public void unhighlight(String label, boolean context) throws LineNotExistsException {
        this.unhighlight(label, context, null, null);
    }

    public void unhighlight(String label, boolean context, Timing delay, Timing duration) throws LineNotExistsException {
        Integer lineNo = this.labelLines.get(label);
        Integer rowNo = this.labelRows.get(label);
        if (lineNo == null || rowNo == null || lineNo >= this.lines.size()) {
            throw new LineNotExistsException("lineNo \"" + lineNo + "\" too high");
        }
        this.generator.unhighlight(this, lineNo, rowNo, context, delay, duration);
        this.highlightedLabels.remove(label);
    }

    public void unhighlight(int lineNo) throws LineNotExistsException {
        this.unhighlight(lineNo, 0, false);
    }

    public void unhighlight(int lineNo, int colNo, boolean context) throws LineNotExistsException {
        this.unhighlight(lineNo, colNo, context, null, null);
    }

    public void unhighlight(int lineNo, int colNo, boolean context, Timing delay, Timing duration) throws LineNotExistsException {
        if (lineNo >= this.lines.size()) {
            throw new LineNotExistsException("lineNo \"" + lineNo + "\" too high");
        }
        this.generator.unhighlight(this, lineNo, colNo, context, delay, duration);
    }

    public void toggleHighlight(String label) {
        if (this.highlightedLabels.size() > 0) {
            Object[] labels = this.highlightedLabels.toArray();
            int i = 0;
            while (i < labels.length) {
                this.unhighlight((String)labels[i]);
                ++i;
            }
        }
        this.highlight(label);
    }

    public void toggleHighlight(String oldLabel, String newLabel) throws LineNotExistsException {
        this.toggleHighlight(oldLabel, false, newLabel);
    }

    public void toggleHighlight(String oldLabel, boolean switchToContextMode, String newLabel) throws LineNotExistsException {
        this.toggleHighlight(oldLabel, switchToContextMode, newLabel, null, null);
    }

    public void toggleHighlight(String oldLabel, boolean switchToContextMode, String newLabel, Timing delay, Timing duration) throws LineNotExistsException {
        this.unhighlight(oldLabel, switchToContextMode, delay, duration);
        this.highlight(newLabel, switchToContextMode, delay, duration);
    }

    public void toggleHighlight(int oldLine, int newLine) throws LineNotExistsException {
        this.toggleHighlight(oldLine, 0, false, newLine, 0, null, null);
    }

    public void toggleHighlight(int oldLine, int oldColumn, boolean switchToContextMode, int newLine, int newColumn) throws LineNotExistsException {
        this.toggleHighlight(oldLine, oldColumn, switchToContextMode, newLine, newColumn, null, null);
    }

    public void toggleHighlight(int oldLine, int oldColumn, boolean switchToContextMode, int newLine, int newColumn, Timing delay, Timing duration) throws LineNotExistsException {
        this.unhighlight(oldLine, oldColumn, switchToContextMode, delay, duration);
        this.highlight(newLine, newColumn, switchToContextMode, delay, duration);
    }
}

