/*
 * Decompiled with CFR 0.152.
 */
package algoanim.executors;

import algoanim.annotations.Annotation;
import algoanim.annotations.Executor;
import algoanim.executors.formulaparser.FormulaParser;
import algoanim.executors.formulaparser.ParseException;
import algoanim.executors.formulaparser.SimpleNode;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Variables;
import java.io.StringReader;
import java.util.Vector;

public class EvalExecutor
extends Executor {
    public EvalExecutor(Variables vars, SourceCode src) {
        super(vars, src);
    }

    @Override
    public boolean exec(Annotation anno) {
        if (anno.getName().equals("eval") && anno.getParameters().size() == 2) {
            Vector<String> params = anno.getParameters();
            String targetKey = params.get(0);
            FormulaParser parser = new FormulaParser(new StringReader(params.get(1)));
            try {
                SimpleNode root = parser.query();
                Double result = this.eval((SimpleNode)root.jjtGetChild(0));
                this.vars.set(targetKey, result.toString());
            }
            catch (ParseException e) {
                System.out.println(e);
            }
            return true;
        }
        return false;
    }

    public Double eval(SimpleNode node) {
        int id = node.id;
        SimpleNode lhs = null;
        SimpleNode rhs = null;
        if (id != 6 && id != 7) {
            lhs = (SimpleNode)node.jjtGetChild(0);
            rhs = (SimpleNode)node.jjtGetChild(1);
        }
        switch (id) {
            case 2: {
                return this.eval(lhs) + this.eval(rhs);
            }
            case 3: {
                return this.eval(lhs) - this.eval(rhs);
            }
            case 4: {
                return this.eval(lhs) * this.eval(rhs);
            }
            case 5: {
                return this.eval(lhs) / this.eval(rhs);
            }
            case 6: {
                return Double.parseDouble(node.getText());
            }
            case 7: {
                return Double.parseDouble(this.vars.get(node.getText()));
            }
        }
        throw new IllegalArgumentException("unknown node id [" + id + "]");
    }
}

