/*
 * Decompiled with CFR 0.152.
 */
package algoanim.annotations;

import algoanim.annotations.Annotation;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LineParser {
    private String line;
    private String labelChar;
    private int indent;
    private String code;
    private Vector<Annotation> props;

    public LineParser(String line) {
        this(line, "@");
    }

    public LineParser(String line, String labelChar) {
        this.line = line.replaceAll("\\s", " ");
        this.labelChar = labelChar;
        this.parseIndent();
        this.parseCode();
        this.parseProperties();
    }

    private void parseIndent() {
        this.indent = 0;
        while (this.indent < this.line.length() && this.line.charAt(this.indent) == ' ') {
            ++this.indent;
        }
    }

    private void parseCode() {
        Pattern p = Pattern.compile("([^" + this.labelChar + "]+)(" + this.labelChar + ".*)");
        Matcher m = p.matcher(this.line);
        this.code = m.find() ? m.group(1).trim() : "";
    }

    private void parseProperties() {
        this.props = new Vector();
        String value = "[a-zA-Z0-9,.\\-_ +*/()]+";
        String regexp = String.valueOf(this.labelChar) + "([a-zA-Z]+)(?:\\((\"" + value + "\"(, \"" + value + "\")*)?\\))?";
        Pattern p = Pattern.compile(regexp);
        Matcher m = p.matcher(this.line);
        while (m.find()) {
            String name = m.group(1);
            String options = m.group(2);
            Annotation prop = new Annotation(name);
            if (options != null) {
                String par_re = "\"(" + value + ")\"";
                Pattern par_p = Pattern.compile(par_re);
                Matcher par_m = par_p.matcher(options);
                while (par_m.find()) {
                    prop.addParameter(par_m.group(1));
                }
            }
            this.props.add(prop);
        }
    }

    public int getIndent() {
        return this.indent;
    }

    public String getCode() {
        return this.code;
    }

    public Vector<Annotation> getProperties() {
        return this.props;
    }

    public String getLabel() {
        int i = 0;
        while (i < this.props.size()) {
            if (this.props.get(i).getName().equals("label")) {
                return this.props.get(i).getParameters().get(0);
            }
            ++i;
        }
        return null;
    }

    public boolean isContinue() {
        int i = 0;
        while (i < this.props.size()) {
            if (this.props.get(i).getName().equals("continue")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        return "indentation: " + new Integer(this.indent) + "\ncode: " + this.code + "\nprops: " + this.props + "\ncontinued: " + this.isContinue() + "\nlabel: " + this.getLabel() + "\n";
    }

    public static void main(String[] args) {
        String line = "res = -3 * (a + (-b))/c;\t\t\t\t\t@label(\"calc\") @eval(\"res\", \"-(3 * 2) /  1.234 -var\")";
        System.out.println(String.valueOf(line) + new LineParser(line));
    }
}

