/*
 * Decompiled with CFR 0.152.
 */
package algoanim.animalscript;

import algoanim.animalscript.AnimalGenerator;
import algoanim.animalscript.AnimalScript;
import algoanim.primitives.StringMatrix;
import algoanim.primitives.generators.StringMatrixGenerator;
import algoanim.properties.MatrixProperties;
import algoanim.util.Timing;
import java.awt.Color;

public class AnimalStringMatrixGenerator
extends AnimalGenerator
implements StringMatrixGenerator {
    private static int count = 1;

    public AnimalStringMatrixGenerator(AnimalScript as) {
        super(as);
    }

    @Override
    public void create(StringMatrix aMatrix) {
        if (this.isNameUsed(aMatrix.getName()) || aMatrix.getName().equals("")) {
            aMatrix.setName("StringMatrix" + count);
            ++count;
        }
        this.lang.addItem(aMatrix);
        this.lang.nextStep();
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("grid \"").append(aMatrix.getName()).append("\" ");
        def.append(AnimalGenerator.makeNodeDef(aMatrix.getUpperLeft()));
        int nrRows = aMatrix.getNrRows();
        int nrCols = aMatrix.getNrCols();
        def.append(" lines ").append(nrRows).append(" columns ");
        def.append(nrCols).append(' ');
        MatrixProperties matrixProps = aMatrix.getProperties();
        if (matrixProps.get("color") != null) {
            def.append("color ");
            def.append(AnimalGenerator.makeColorDef(((Color)matrixProps.get("color")).getRed(), ((Color)matrixProps.get("color")).getGreen(), ((Color)matrixProps.get("color")).getBlue()));
            def.append(" ");
        }
        if (matrixProps.get("elementColor") != null) {
            def.append("textColor ").append(AnimalGenerator.makeColorDef(((Color)matrixProps.get("elementColor")).getRed(), ((Color)matrixProps.get("elementColor")).getGreen(), ((Color)matrixProps.get("elementColor")).getBlue()));
            def.append(" ");
        }
        if (matrixProps.get("fillColor") != null) {
            def.append("fillColor ").append(AnimalGenerator.makeColorDef(((Color)matrixProps.get("fillColor")).getRed(), ((Color)matrixProps.get("fillColor")).getGreen(), ((Color)matrixProps.get("fillColor")).getBlue()));
            def.append(" ");
        }
        if (matrixProps.get("elemHighlight") != null) {
            def.append("highlightTextColor ");
            def.append(AnimalGenerator.makeColorDef(((Color)matrixProps.get("elemHighlight")).getRed(), ((Color)matrixProps.get("elemHighlight")).getGreen(), ((Color)matrixProps.get("elemHighlight")).getBlue()));
            def.append(" ");
        }
        if (matrixProps.get("cellHighlight") != null) {
            def.append("highlightBackColor ");
            def.append(AnimalGenerator.makeColorDef(((Color)matrixProps.get("cellHighlight")).getRed(), ((Color)matrixProps.get("cellHighlight")).getGreen(), ((Color)matrixProps.get("cellHighlight")).getBlue()));
            def.append(" ");
        }
        if (matrixProps.get("depth") != null) {
            def.append("depth ");
            def.append(matrixProps.get("depth"));
            def.append(" ");
        }
        this.lang.addLine(def);
        int row = 0;
        while (row < nrRows) {
            int col = 0;
            while (col < nrCols) {
                StringBuilder sb = new StringBuilder(128);
                sb.append("setGridValue \"").append(aMatrix.getName());
                sb.append("[").append(row).append("][").append(col);
                sb.append("]\" \"").append(aMatrix.getElement(row, col));
                sb.append("\"");
                if (row == nrRows - 1 && col == nrCols - 1) {
                    sb.append(" refresh");
                }
                this.lang.addLine(sb.toString());
                ++col;
            }
            ++row;
        }
    }

    private void finishDefinition(StringBuilder sb, Timing delay, Timing duration) {
        sb.append(AnimalGenerator.makeDurationTimingDef(duration));
        sb.append(AnimalGenerator.makeOffsetTimingDef(delay));
        this.lang.addLine(sb.toString());
    }

    @Override
    public void put(StringMatrix intMatrix, int row, int col, String what, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("setGridValue \"").append(intMatrix.getName()).append("[");
        sb.append(row).append("][").append(col).append("]\" \"");
        sb.append(what).append("\" refresh ");
        this.finishDefinition(sb, delay, duration);
    }

    @Override
    public void swap(StringMatrix intMatrix, int sourceRow, int sourceCol, int targetRow, int targetCol, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("swapGridValues \"").append(intMatrix.getName()).append("[");
        sb.append(sourceRow).append("][").append(sourceCol);
        sb.append("]\" and \"").append(intMatrix.getName()).append("[");
        sb.append(targetRow).append("][").append(targetCol).append("]\" refresh ");
        this.finishDefinition(sb, delay, duration);
    }

    @Override
    public void highlightCell(StringMatrix intMatrix, int row, int col, Timing offset, Timing duration) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("highlightGridCell \"").append(intMatrix.getName());
        sb.append("[").append(row).append("][").append(col).append("]\" ");
        this.finishDefinition(sb, offset, duration);
    }

    @Override
    public void highlightCellColumnRange(StringMatrix intMatrix, int row, int startCol, int endCol, Timing offset, Timing duration) {
        if (startCol == 0 && endCol == intMatrix.getNrCols() - 1) {
            StringBuilder sb = new StringBuilder(512);
            sb.append("highlightGridCell \"").append(intMatrix.getName());
            sb.append("[").append(row).append("][]\" ");
            this.finishDefinition(sb, offset, duration);
        } else {
            int col = startCol;
            while (col <= endCol) {
                StringBuilder sb = new StringBuilder(512);
                sb.append("highlightGridCell \"").append(intMatrix.getName());
                sb.append("[").append(row).append("][").append(col).append("]\" ");
                this.finishDefinition(sb, offset, duration);
                ++col;
            }
        }
    }

    @Override
    public void highlightCellRowRange(StringMatrix intMatrix, int startRow, int endRow, int col, Timing offset, Timing duration) {
        if (startRow == 0 && endRow == intMatrix.getNrRows() - 1) {
            StringBuilder sb = new StringBuilder(512);
            sb.append("highlightGridCell \"").append(intMatrix.getName());
            sb.append("[][").append(col).append("]\" ");
            this.finishDefinition(sb, offset, duration);
        } else {
            int row = startRow;
            while (row <= endRow) {
                StringBuilder sb = new StringBuilder(512);
                sb.append("highlightGridCell \"").append(intMatrix.getName());
                sb.append("[").append(row).append("][").append(col).append("]\" ");
                this.finishDefinition(sb, offset, duration);
                ++row;
            }
        }
    }

    @Override
    public void highlightElem(StringMatrix intMatrix, int row, int col, Timing offset, Timing duration) {
        this.highlightCell(intMatrix, row, col, offset, duration);
    }

    @Override
    public void highlightElemColumnRange(StringMatrix intMatrix, int row, int startCol, int endCol, Timing offset, Timing duration) {
        this.highlightCellColumnRange(intMatrix, row, startCol, endCol, offset, duration);
    }

    @Override
    public void highlightElemRowRange(StringMatrix intMatrix, int startRow, int endRow, int col, Timing offset, Timing duration) {
        this.highlightCellColumnRange(intMatrix, startRow, endRow, col, offset, duration);
    }

    @Override
    public void unhighlightCell(StringMatrix intMatrix, int row, int col, Timing offset, Timing duration) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("unhighlightGridCell \"").append(intMatrix.getName());
        sb.append("[").append(row).append("][").append(col).append("]\" ");
        this.finishDefinition(sb, offset, duration);
    }

    @Override
    public void unhighlightCellColumnRange(StringMatrix intMatrix, int row, int startCol, int endCol, Timing offset, Timing duration) {
        if (startCol == 0 && endCol == intMatrix.getNrCols() - 1) {
            StringBuilder sb = new StringBuilder(512);
            sb.append("unhighlightGridCell \"").append(intMatrix.getName());
            sb.append("[").append(row).append("][]\" ");
            this.finishDefinition(sb, offset, duration);
        } else {
            int col = startCol;
            while (col <= endCol) {
                StringBuilder sb = new StringBuilder(512);
                sb.append("unhighlightGridCell \"").append(intMatrix.getName());
                sb.append("[").append(row).append("][").append(col).append("]\" ");
                this.finishDefinition(sb, offset, duration);
                ++col;
            }
        }
    }

    @Override
    public void unhighlightCellRowRange(StringMatrix intMatrix, int startRow, int endRow, int col, Timing offset, Timing duration) {
        if (startRow == 0 && endRow == intMatrix.getNrRows() - 1) {
            StringBuilder sb = new StringBuilder(512);
            sb.append("unhighlightGridCell \"").append(intMatrix.getName());
            sb.append("[][").append(col).append("]\" ");
            this.finishDefinition(sb, offset, duration);
        } else {
            int row = startRow;
            while (row <= endRow) {
                StringBuilder sb = new StringBuilder(512);
                sb.append("unhighlightGridCell \"").append(intMatrix.getName());
                sb.append("[").append(row).append("][").append(col).append("]");
                this.finishDefinition(sb, offset, duration);
                ++row;
            }
        }
    }

    @Override
    public void unhighlightElem(StringMatrix intMatrix, int row, int col, Timing offset, Timing duration) {
        this.unhighlightCell(intMatrix, row, col, offset, duration);
    }

    @Override
    public void unhighlightElemColumnRange(StringMatrix intMatrix, int row, int startCol, int endCol, Timing offset, Timing duration) {
        this.unhighlightCellColumnRange(intMatrix, row, startCol, endCol, offset, duration);
    }

    @Override
    public void unhighlightElemRowRange(StringMatrix intMatrix, int row, int startCol, int endCol, Timing offset, Timing duration) {
        this.unhighlightCellRowRange(intMatrix, row, startCol, endCol, offset, duration);
    }
}

