/*
 * Decompiled with CFR 0.152.
 */
package algoanim.animalscript;

import algoanim.animalscript.AnimalGenerator;
import algoanim.animalscript.AnimalScript;
import algoanim.primitives.Rect;
import algoanim.primitives.generators.Language;
import algoanim.primitives.generators.RectGenerator;
import algoanim.properties.RectProperties;
import java.awt.Color;

public class AnimalRectGenerator
extends AnimalGenerator
implements RectGenerator {
    private static int count = 1;

    public AnimalRectGenerator(Language aLang) {
        super(aLang);
    }

    @Override
    public void create(Rect arect) {
        if (this.isNameUsed(arect.getName()) || arect.getName() == "") {
            arect.setName("Rect" + count);
            ++count;
        }
        this.lang.addItem(arect);
        StringBuilder str = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        str.append("rectangle \"").append(arect.getName()).append("\" ");
        str.append(AnimalGenerator.makeNodeDef(arect.getUpperLeft()));
        str.append(" ").append(AnimalGenerator.makeNodeDef(arect.getLowerRight()));
        RectProperties props = arect.getProperties();
        if (props.get("color") != null) {
            str.append(" color ");
            str.append(AnimalGenerator.makeColorDef(((Color)props.get("color")).getRed(), ((Color)props.get("color")).getGreen(), ((Color)props.get("color")).getBlue()));
        }
        if (props.get("depth") != null) {
            str.append(" depth " + ((Integer)props.get("depth")).toString());
        }
        if (props.get("filled") != null && ((Boolean)props.get("filled")).booleanValue()) {
            str.append(" filled");
            if (props.get("fillColor") != null) {
                str.append(" fillColor ");
                str.append(AnimalGenerator.makeColorDef(((Color)props.get("fillColor")).getRed(), ((Color)props.get("fillColor")).getGreen(), ((Color)props.get("fillColor")).getBlue()));
            }
        }
        str.append(AnimalGenerator.makeDisplayOptionsDef(arect.getDisplayOptions(), props));
        this.lang.addLine(str);
    }
}

