/*
 * Decompiled with CFR 0.152.
 */
package algoanim.animalscript;

import algoanim.animalscript.AnimalGenerator;
import algoanim.animalscript.AnimalScript;
import algoanim.primitives.IntArray;
import algoanim.primitives.generators.IntArrayGenerator;
import algoanim.properties.ArrayProperties;
import algoanim.util.ArrayDisplayOptions;
import algoanim.util.Timing;
import java.awt.Color;

public class AnimalIntArrayGenerator
extends AnimalGenerator
implements IntArrayGenerator {
    private static int count = 1;

    public AnimalIntArrayGenerator(AnimalScript as) {
        super(as);
    }

    @Override
    public void create(IntArray anArray) {
        ArrayDisplayOptions ado;
        if (this.isNameUsed(anArray.getName()) || anArray.getName() == "") {
            anArray.setName("IntArray" + count);
            ++count;
        }
        this.lang.addItem(anArray);
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("array \"").append(anArray.getName()).append("\" ");
        def.append(AnimalGenerator.makeNodeDef(anArray.getUpperLeft()));
        def.append(' ');
        ArrayProperties ap = anArray.getProperties();
        if (ap.get("color") != null) {
            def.append("color " + AnimalGenerator.makeColorDef(((Color)ap.get("color")).getRed(), ((Color)ap.get("color")).getGreen(), ((Color)ap.get("color")).getBlue()) + " ");
        }
        if (ap.get("fillColor") != null) {
            def.append("fillColor " + AnimalGenerator.makeColorDef(((Color)ap.get("fillColor")).getRed(), ((Color)ap.get("fillColor")).getGreen(), ((Color)ap.get("fillColor")).getBlue()) + " ");
        }
        if (ap.get("elementColor") != null) {
            def.append("elementColor " + AnimalGenerator.makeColorDef(((Color)ap.get("elementColor")).getRed(), ((Color)ap.get("elementColor")).getGreen(), ((Color)ap.get("elementColor")).getBlue()) + " ");
        }
        if (ap.get("elemHighlight") != null) {
            def.append("elemHighlight " + AnimalGenerator.makeColorDef(((Color)ap.get("elemHighlight")).getRed(), ((Color)ap.get("elemHighlight")).getGreen(), ((Color)ap.get("elemHighlight")).getBlue()) + " ");
        }
        if (ap.get("cellHighlight") != null) {
            def.append("cellHighlight " + AnimalGenerator.makeColorDef(((Color)ap.get("cellHighlight")).getRed(), ((Color)ap.get("cellHighlight")).getGreen(), ((Color)ap.get("cellHighlight")).getBlue()) + " ");
        }
        if (ap.get("vertical") != null && ((Boolean)ap.get("vertical")).booleanValue()) {
            def.append("vertical ");
        } else {
            def.append("horizontal ");
        }
        def.append("length ").append(anArray.getLength()).append(' ');
        int i = 0;
        while (i < anArray.getLength()) {
            def.append("\"" + anArray.getData(i) + "\" ");
            ++i;
        }
        if (ap.get("depth") != null) {
            def.append("depth " + ap.get("depth") + " ");
        }
        if ((ado = (ArrayDisplayOptions)anArray.getDisplayOptions()) == null && (Boolean)ap.get("cascaded") == Boolean.TRUE) {
            def.append(" cascaded");
        }
        if (ado != null) {
            Timing o = ado.getOffset();
            if (o != null) {
                def.append(" " + AnimalGenerator.makeOffsetTimingDef(o));
            }
            if (ado.getCascaded()) {
                def.append(" cascaded");
                Timing d = ado.getDuration();
                if (d != null) {
                    def.append(AnimalGenerator.makeDurationTimingDef(d));
                }
            }
        }
        this.lang.addLine(def);
    }

    @Override
    public void swap(IntArray iap, int what, int with, Timing delay, Timing duration) {
        String def = "arraySwap on \"" + iap.getName() + "\" position " + what + " with " + with;
        def = String.valueOf(def) + " " + AnimalGenerator.makeOffsetTimingDef(delay);
        def = String.valueOf(def) + " " + AnimalGenerator.makeDurationTimingDef(duration);
        this.lang.addLine(def);
    }

    @Override
    public void put(IntArray iap, int where, int what, Timing delay, Timing duration) {
        String def = "arrayPut \"" + what + "\" on \"" + iap.getName() + "\" position " + where;
        def = String.valueOf(def) + " " + AnimalGenerator.makeOffsetTimingDef(delay);
        def = String.valueOf(def) + " " + AnimalGenerator.makeDurationTimingDef(duration);
        this.lang.addLine(def);
    }

    @Override
    public void highlightCell(IntArray ia, int from, int to, Timing offset, Timing duration) {
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("highlightArrayCell on \"");
        def.append(ia.getName());
        def.append("\"");
        def.append(" from " + from + " to " + to);
        def.append(AnimalGenerator.makeOffsetTimingDef(offset));
        def.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(def);
    }

    @Override
    public void highlightCell(IntArray ia, int position, Timing offset, Timing duration) {
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("highlightArrayCell on \"");
        def.append(ia.getName());
        def.append("\"");
        def.append(" position " + position);
        def.append(AnimalGenerator.makeOffsetTimingDef(offset));
        def.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(def);
    }

    @Override
    public void highlightElem(IntArray ia, int from, int to, Timing offset, Timing duration) {
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("highlightArrayElem on \"");
        def.append(ia.getName());
        def.append("\"");
        def.append(" from " + from + " to " + to);
        def.append(AnimalGenerator.makeOffsetTimingDef(offset));
        def.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(def);
    }

    @Override
    public void highlightElem(IntArray ia, int position, Timing offset, Timing duration) {
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("highlightArrayElem on \"");
        def.append(ia.getName());
        def.append("\"");
        def.append(" position " + position);
        def.append(AnimalGenerator.makeOffsetTimingDef(offset));
        def.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(def);
    }

    @Override
    public void unhighlightCell(IntArray ia, int from, int to, Timing offset, Timing duration) {
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("unhighlightArrayCell on \"");
        def.append(ia.getName());
        def.append("\"");
        def.append(" from " + from + " to " + to);
        def.append(AnimalGenerator.makeOffsetTimingDef(offset));
        def.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(def);
    }

    @Override
    public void unhighlightCell(IntArray ia, int position, Timing offset, Timing duration) {
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("unhighlightArrayCell on \"");
        def.append(ia.getName());
        def.append("\"");
        def.append(" position " + position);
        def.append(AnimalGenerator.makeOffsetTimingDef(offset));
        def.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(def);
    }

    @Override
    public void unhighlightElem(IntArray ia, int from, int to, Timing offset, Timing duration) {
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("unhighlightArrayElem on \"");
        def.append(ia.getName());
        def.append("\"");
        def.append(" from " + from + " to " + to);
        def.append(AnimalGenerator.makeOffsetTimingDef(offset));
        def.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(def);
    }

    @Override
    public void unhighlightElem(IntArray ia, int position, Timing offset, Timing duration) {
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("unhighlightArrayElem on \"");
        def.append(ia.getName());
        def.append("\"");
        def.append(" position " + position);
        def.append(AnimalGenerator.makeOffsetTimingDef(offset));
        def.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(def);
    }
}

