/*
 * Decompiled with CFR 0.152.
 */
package algoanim.animalscript;

import algoanim.exceptions.IllegalDirectionException;
import algoanim.primitives.Polygon;
import algoanim.primitives.Polyline;
import algoanim.primitives.Primitive;
import algoanim.primitives.Rect;
import algoanim.primitives.Square;
import algoanim.primitives.Triangle;
import algoanim.primitives.generators.Generator;
import algoanim.primitives.generators.Language;
import algoanim.properties.AnimationProperties;
import algoanim.util.Coordinates;
import algoanim.util.DisplayOptions;
import algoanim.util.Hidden;
import algoanim.util.Node;
import algoanim.util.Offset;
import algoanim.util.Timing;
import java.awt.Color;

public abstract class AnimalGenerator
extends Generator {
    public AnimalGenerator(Language aLang) {
        super(aLang);
    }

    public static String makeNodeDef(Node n) {
        StringBuilder sb = new StringBuilder(40);
        if (n instanceof Offset) {
            Offset o = (Offset)n;
            int mode = o.getReferenceMode();
            if (mode == 1 || mode == 4) {
                sb.append("offset (").append(o.getX()).append(", ").append(o.getY());
                sb.append(") from \"");
                if (mode == 1) {
                    sb.append(o.getRef().getName());
                } else {
                    sb.append(o.getBaseID());
                }
                sb.append("\" ").append(o.getDirection());
            } else if (o.getReferenceMode() == 2) {
                Node baseNode = o.getNode();
                if (baseNode instanceof Coordinates) {
                    Coordinates c = (Coordinates)baseNode;
                    sb.append('(').append(o.getX()).append(c.getX()).append(", ");
                    sb.append(o.getY()).append(c.getY()).append(')');
                } else {
                    sb.append('(').append(o.getX()).append(", ").append(o.getY());
                    sb.append(')');
                    System.err.println("Offset based on an instance of " + baseNode.getClass().getName() + " not supported");
                }
            }
        } else if (n instanceof Coordinates) {
            Coordinates c = (Coordinates)n;
            sb.append('(').append(c.getX()).append(", ");
            sb.append(c.getY()).append(')');
        }
        return sb.toString();
    }

    public static String makeColorDef(int r, int g, int b) {
        StringBuilder sb = new StringBuilder(40);
        sb.append('(').append(r % 256).append(", ");
        sb.append(g % 256).append(", ").append(b % 256).append(')');
        return sb.toString();
    }

    public static String makeColorDef(Color aColor) {
        if (aColor == null) {
            return "(0, 0, 0)";
        }
        return AnimalGenerator.makeColorDef(aColor.getRed(), aColor.getGreen(), aColor.getBlue());
    }

    public static String makeOffsetTimingDef(Timing delay) {
        if (delay == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(30);
        sb.append(" after ").append(delay.getDelay()).append(" ");
        sb.append(delay.getUnit());
        return sb.toString();
    }

    public static String makeHiddenDef(AnimationProperties props) {
        boolean isHidden = false;
        if (props != null) {
            isHidden = (Boolean)props.get("hidden");
        }
        return isHidden ? " hidden" : "";
    }

    public static String makeDurationTimingDef(Timing duration) {
        if (duration == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(30);
        sb.append(" within ").append(duration.getDelay());
        sb.append(" ").append(duration.getUnit());
        return sb.toString();
    }

    public static String makeDisplayOptionsDef(DisplayOptions d) {
        if (d instanceof Hidden) {
            return " hidden";
        }
        if (d instanceof Timing) {
            return AnimalGenerator.makeOffsetTimingDef((Timing)d);
        }
        return "";
    }

    public static String makeDisplayOptionsDef(DisplayOptions d, AnimationProperties props) {
        StringBuilder sb = new StringBuilder(32);
        if (d instanceof Hidden) {
            sb.append(" hidden");
        } else if (d instanceof Timing) {
            sb.append(AnimalGenerator.makeOffsetTimingDef((Timing)d));
        }
        if (!(d instanceof Hidden)) {
            sb.append(AnimalGenerator.makeHiddenDef(props));
        }
        return sb.toString();
    }

    @Override
    public void exchange(Primitive p, Primitive q) {
        StringBuilder sb = new StringBuilder(30);
        sb.append("exchange \"").append(p.getName()).append("\" \"");
        sb.append(q.getName()).append("\"");
        this.lang.addLine(sb);
    }

    @Override
    public void hide(Primitive q, Timing t) {
        StringBuilder sb = new StringBuilder(30);
        sb.append("hide \"").append(q.getName()).append("\" ");
        sb.append(AnimalGenerator.makeOffsetTimingDef(t));
        this.lang.addLine(sb);
    }

    @Override
    public void rotate(Primitive p, Primitive around, int degrees, Timing t, Timing d) {
        if (p instanceof Polygon || p instanceof Rect || p instanceof Triangle || p instanceof Square) {
            StringBuilder sb = new StringBuilder(30);
            sb.append("rotate \"").append(p.getName()).append("\" around \"");
            sb.append(String.valueOf(around.getName()) + "\" degrees ").append(degrees % 360);
            sb.append(AnimalGenerator.makeOffsetTimingDef(t));
            sb.append(" ").append(AnimalGenerator.makeDurationTimingDef(d));
            this.lang.addLine(sb);
        }
    }

    @Override
    public void rotate(Primitive p, Node center, int degrees, Timing t, Timing d) {
        if (p instanceof Polyline || p instanceof Square || p instanceof Rect || p instanceof Triangle || p instanceof Polygon) {
            StringBuilder def = new StringBuilder("rotate \"");
            def.append(p.getName());
            def.append("\" center ");
            def.append(AnimalGenerator.makeNodeDef(center));
            def.append(" ");
            if (degrees != 0) {
                def.append(" degrees ");
                def.append(degrees % 360);
            }
            def.append(AnimalGenerator.makeOffsetTimingDef(t));
            def.append(AnimalGenerator.makeDurationTimingDef(d));
            this.lang.addLine(def);
        }
    }

    @Override
    public void show(Primitive p, Timing t) {
        StringBuilder sb = new StringBuilder(30);
        sb.append("show \"").append(p.getName()).append("\" ");
        sb.append(AnimalGenerator.makeOffsetTimingDef(t));
        this.lang.addLine(sb);
    }

    @Override
    public void moveVia(Primitive elem, String direction, String moveType, Primitive via, Timing delay, Timing d) throws IllegalDirectionException {
        if (!this.lang.isValidDirection(direction)) {
            throw new IllegalDirectionException(direction);
        }
        StringBuilder sb = new StringBuilder(30);
        sb.append("move \"").append(elem.getName()).append("\"");
        if (direction != null) {
            sb.append(" corner ").append(direction);
        }
        if (moveType != null) {
            sb.append(" type \"").append(moveType).append("\"");
        }
        sb.append(" via \"").append(via.getName()).append("\" ");
        sb.append(AnimalGenerator.makeOffsetTimingDef(delay)).append(" ");
        sb.append(AnimalGenerator.makeDurationTimingDef(d));
        this.lang.addLine(sb);
    }

    @Override
    public void moveTo(Primitive p, String direction, String moveType, Node target, Timing delay, Timing duration) throws IllegalDirectionException {
        if (!this.lang.isValidDirection(direction)) {
            throw new IllegalDirectionException(direction);
        }
        StringBuilder sb = new StringBuilder(30);
        sb.append("move \"").append(p.getName()).append("\"");
        if (direction != null) {
            sb.append(" corner ").append(direction);
        }
        if (moveType != null) {
            sb.append(" type \"").append(moveType).append("\"");
        }
        sb.append(" to ").append(AnimalGenerator.makeNodeDef(target));
        sb.append(" ").append(AnimalGenerator.makeOffsetTimingDef(delay));
        sb.append(" ").append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(sb);
    }

    @Override
    public void moveBy(Primitive p, String moveType, int dx, int dy, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder();
        sb.append("move \"").append(p.getName()).append("\"");
        if (moveType != null) {
            sb.append(" type \"").append(moveType).append("\"");
        }
        sb.append(" along line (0, 0) (").append(dx).append(", ").append(dy);
        sb.append(") ").append(AnimalGenerator.makeOffsetTimingDef(delay));
        sb.append(" ").append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(sb);
    }

    @Override
    public void changeColor(Primitive elem, String colorType, Color newColor, Timing delay, Timing d) {
        StringBuilder sb = new StringBuilder(30);
        sb.append("color \"").append(elem.getName()).append("\"");
        if (colorType != null && colorType.length() > 0) {
            sb.append(" type \"").append(colorType).append("\"");
        }
        sb.append(" ");
        sb.append(AnimalGenerator.makeColorDef(newColor.getRed(), newColor.getGreen(), newColor.getBlue()));
        sb.append(" ").append(AnimalGenerator.makeOffsetTimingDef(delay));
        sb.append(" ").append(AnimalGenerator.makeDurationTimingDef(d));
        this.lang.addLine(sb);
    }
}

