/*
 * Decompiled with CFR 0.152.
 */
import algoanim.animalscript.AnimalScript;
import algoanim.primitives.IntMatrix;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.MatrixProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.util.Coordinates;
import java.awt.Color;
import java.awt.Font;

public class WarshallP {
    private Language lang;
    Text param0;
    Text param11;
    Text param22;
    Text param33;
    Text param44;
    Text param55;
    private static final String DESCRIPTION = "Warshall";
    private static final String SOURCE_CODE = "Warshall";

    public WarshallP(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void calcReachability(int[][] w) {
        MatrixProperties adjMatrixProperties = new MatrixProperties();
        adjMatrixProperties.set("fillColor", Color.WHITE);
        adjMatrixProperties.set("elemHighlight", Color.RED);
        adjMatrixProperties.set("elementColor", Color.BLACK);
        Coordinates upperLeftIntMatrix = new Coordinates(10, 10);
        IntMatrix adjMatrix = this.lang.newIntMatrix(upperLeftIntMatrix, w, "Erreichbarkeitsmatrix", null, adjMatrixProperties);
        this.lang.nextStep();
        SourceCodeProperties scProps = new SourceCodeProperties();
        scProps.set("contextColor", Color.BLUE);
        scProps.set("font", new Font("Monospaced", 0, 12));
        scProps.set("highlightColor", Color.RED);
        scProps.set("color", Color.BLACK);
        SourceCode sc = this.lang.newSourceCode(new Coordinates(40, 140), "sourceCode", null, scProps);
        sc.addCodeLine("public void warshall(int[][]a) {", null, 0, null);
        sc.addCodeLine("for(int k=0; k<a.length; k++) {", null, 1, null);
        sc.addCodeLine("for(int i= 0; i<a.length; i++) {", null, 2, null);
        sc.addCodeLine("if(a[i][k]==1){", null, 3, null);
        sc.addCodeLine("for(int j=0; j<a.length; j++){", null, 4, null);
        sc.addCodeLine("if(a[k][j]==1) {", null, 5, null);
        sc.addCodeLine("a[i][j]=1 }", null, 5, null);
        sc.addCodeLine(" }", null, 4, null);
        sc.addCodeLine("}", null, 3, null);
        sc.addCodeLine(" }", null, 2, null);
        sc.addCodeLine("}", null, 1, null);
        sc.addCodeLine(" }", null, 0, null);
        this.lang.nextStep();
        this.lang.newText(new Coordinates(350, 200), "k = ", "textk", null);
        this.param0 = this.lang.newText(new Coordinates(380, 200), "", "text0", null);
        this.lang.newText(new Coordinates(350, 225), "j = ", "textj", null);
        this.param11 = this.lang.newText(new Coordinates(380, 200), "", "text11", null);
        this.lang.newText(new Coordinates(350, 250), "i = ", "texti", null);
        this.param22 = this.lang.newText(new Coordinates(380, 200), "", "text22", null);
        this.lang.newText(new Coordinates(500, 200), "a[i][k] = ", "textik", null);
        this.param33 = this.lang.newText(new Coordinates(545, 200), "", "text33", null);
        this.lang.newText(new Coordinates(500, 225), "a[k][j] = ", "textkj", null);
        this.param44 = this.lang.newText(new Coordinates(545, 200), "", "text44", null);
        this.lang.newText(new Coordinates(500, 250), "a[i][j] = ", "textij", null);
        this.param55 = this.lang.newText(new Coordinates(545, 200), "", "text55", null);
        this.lang.nextStep();
        this.warshall(adjMatrix, sc);
    }

    private void warshall(IntMatrix w, SourceCode source) {
        source.highlight(0, 0, false);
        this.lang.nextStep();
        source.toggleHighlight(0, 0, false, 1, 0);
        int numberOfNodes = w.getNrCols();
        int transitnode = 0;
        while (transitnode < numberOfNodes) {
            this.param0.setText(Integer.toString(transitnode), null, null);
            source.highlight(2);
            this.lang.nextStep();
            int sourcenode = 0;
            while (sourcenode < numberOfNodes) {
                this.param11.setText(Integer.toString(sourcenode), null, null);
                source.toggleHighlight(2, 3);
                this.param33.setText(Integer.toString(w.getElement(sourcenode, transitnode)), null, null);
                w.highlightElem(sourcenode, transitnode, null, null);
                source.highlight(4);
                this.lang.nextStep();
                if (w.getElement(sourcenode, transitnode) == 1) {
                    source.unhighlight(3);
                    source.unhighlight(4);
                    w.highlightElemRowRange(transitnode, transitnode, 3, null, null);
                    source.highlight(5);
                    int targetnode = 0;
                    while (targetnode < numberOfNodes) {
                        this.param22.setText(Integer.toString(targetnode), null, null);
                        this.param44.setText(Integer.toString(w.getElement(transitnode, targetnode)), null, null);
                        w.highlightElem(transitnode, targetnode, null, null);
                        this.lang.nextStep();
                        if (w.getElement(transitnode, targetnode) == 1) {
                            this.param55.setText(Integer.toString(w.getElement(sourcenode, targetnode)), null, null);
                            w.put(sourcenode, targetnode, 1, null, null);
                            this.lang.nextStep();
                        }
                        ++targetnode;
                    }
                    source.unhighlight(5);
                }
                ++sourcenode;
            }
            ++transitnode;
        }
    }

    protected String getAlgorithmDescription() {
        return "Warshall";
    }

    protected String getAlgorithmCode() {
        return "Warshall";
    }

    public String getName() {
        return "Warshall";
    }

    public String getDescription() {
        return "Warshall";
    }

    public String getCodeExample() {
        return "Warshall";
    }

    public static void main(String[] args) {
        AnimalScript l = new AnimalScript("Warshall Animation", "Patrick Fongue, Matthias Prager, Daniel Staesche", 640, 480);
        WarshallP s = new WarshallP(l);
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[4];
        nArray[2] = 1;
        nArray[3] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[3] = 1;
        nArrayArray[2] = nArray3;
        nArrayArray[3] = new int[4];
        int[][] w = nArrayArray;
        s.calcReachability(w);
        System.out.println(l);
    }
}

