/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import translator.ExtendedResourceBundle;
import translator.TranslatableGUIElement;

public class Translator {
    public static final Locale DEFAULT_LOCALE = new Locale("en", "US");
    private Locale currentLocale = new Locale("en", "US");
    private MessageFormat messageFormat = new MessageFormat("");
    private String resourceBaseName = "AnimalResources";
    private Hashtable<String, ExtendedResourceBundle> resources = new Hashtable(17);
    private TranslatableGUIElement generator = null;
    private Hashtable<String, String> unknownResources = new Hashtable(41);

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public TranslatableGUIElement getGenerator() {
        if (this.generator == null) {
            this.generator = new TranslatableGUIElement(this);
        }
        return this.generator;
    }

    public ExtendedResourceBundle getResourceBundle() {
        return this.resources.get(this.currentLocale.toString());
    }

    public void listUnknownResources() {
        StringBuilder buffer = new StringBuilder(5000);
        Enumeration<String> keys = this.unknownResources.keys();
        if (keys.hasMoreElements()) {
            buffer.append("Unknown resources in format 'resource name -- locale':").append("\n");
        }
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            buffer.append((Object)key).append(": ").append(this.unknownResources.get(key));
            buffer.append("\n");
        }
        if (buffer.length() > 0) {
            System.out.print(buffer.toString());
        }
    }

    public void setTranslatorLocale(Locale targetLocale) {
        if (targetLocale != null) {
            this.messageFormat.setLocale(targetLocale);
            String localeCode = targetLocale.toString();
            if (!this.resources.containsKey(localeCode)) {
                ExtendedResourceBundle resourceBundle = new ExtendedResourceBundle(String.valueOf(this.resourceBaseName) + "." + localeCode);
                resourceBundle.setTranslator(this);
                this.resources.put(localeCode, resourceBundle);
            }
            this.currentLocale = targetLocale;
            this.getGenerator().translateGUIElements();
        }
    }

    public void setResourceBaseName(String resourceName) {
        this.resourceBaseName = resourceName;
    }

    public Translator() {
        try {
            throw new IllegalArgumentException("Please do not use the empty constructor for Translator instances!");
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return;
        }
    }

    public Translator(String resourceName, Locale targetLocale) {
        this.setResourceBaseName(resourceName);
        this.setTranslatorLocale(targetLocale);
    }

    public String translateMessageWithoutParameterExpansion(String messageKey) {
        String messageSource = this.getResourceBundle().getMessage(messageKey, true);
        if (messageSource != null) {
            return messageSource;
        }
        if (this.unknownResources.containsKey(messageKey)) {
            String entry = this.unknownResources.get(messageKey);
            if (entry.indexOf(this.currentLocale.getCountry()) == -1) {
                this.unknownResources.put(messageKey, String.valueOf(this.unknownResources.get(messageKey)) + ", " + this.currentLocale.getCountry());
            }
        } else {
            this.unknownResources.put(messageKey, this.currentLocale.getCountry());
        }
        return "Invalid Message Key '" + messageKey + "'";
    }

    public String translateMessage(String messageKey) {
        return this.translateMessage(messageKey, null, true);
    }

    public String translateMessage(String messageKey, Object[] messageParams) {
        return this.translateMessage(messageKey, messageParams, true);
    }

    public String translateMessage(String messageKey, Object[] messageParams, boolean warnOnError) {
        String messageSource = this.getResourceBundle().getMessage(messageKey, warnOnError);
        if (messageSource != null) {
            try {
                this.messageFormat.applyPattern(messageSource);
            }
            catch (IllegalArgumentException illegal) {
                System.err.println(String.valueOf(illegal.toString()) + " for key '" + messageKey + "'");
            }
            return this.messageFormat.format(messageParams);
        }
        if (this.unknownResources.containsKey(messageKey)) {
            String entry = this.unknownResources.get(messageKey);
            if (entry.indexOf(this.currentLocale.getCountry()) == -1) {
                this.unknownResources.put(messageKey, String.valueOf(this.unknownResources.get(messageKey)) + ", " + this.currentLocale.getCountry());
            }
        } else {
            this.unknownResources.put(messageKey, this.currentLocale.getCountry());
        }
        return "Invalid Message Key '" + messageKey + "'";
    }
}

