/*
 * Decompiled with CFR 0.152.
 */
package translator;

import animal.misc.MessageDisplay;
import components.ArrayInputTable;
import components.ColorChooserComboBox;
import components.FontChooserComboBox;
import components.IntegerTextField;
import components.IntegerTextFieldEx;
import components.MatrixInputTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.MenuElement;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import translator.ExtendedAction;
import translator.ExtendedActionButton;
import translator.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslatableGUIElement {
    private String GRAPHICS_PATH = "/graphics/";
    private Hashtable<String, Object> translatableElements = new Hashtable(1023);
    private Translator translator = null;
    private Class<?> animalImageDummy;

    public TranslatableGUIElement(Translator t) {
        this.translator = t;
    }

    public ImageIcon getImageIcon(String name) {
        URL url;
        if (name == null || name.length() == 0) {
            return null;
        }
        ImageIcon icon = null;
        if (this.animalImageDummy == null) {
            try {
                this.animalImageDummy = Class.forName("graphics.AnimalImageDummy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.animalImageDummy != null) {
            ClassLoader cl = this.animalImageDummy.getClassLoader();
            if (cl != null) {
                url = cl.getResource("graphics/" + name);
                if (url != null && (icon = new ImageIcon(url)) != null) {
                    return icon;
                }
            } else {
                System.err.println("@TGUI: ClassLoader failed, null!");
            }
        }
        if ((url = this.animalImageDummy != null ? this.animalImageDummy.getResource(String.valueOf(this.GRAPHICS_PATH) + name) : this.getClass().getResource(String.valueOf(this.GRAPHICS_PATH) + name)) == null) {
            MessageDisplay.errorMsg("iconNotFound", String.valueOf(name) + "@TGUI: ", 8);
        } else {
            icon = new ImageIcon(url);
            if (icon == null) {
                MessageDisplay.errorMsg("iconNotFound", String.valueOf(name) + "@TGUI: ", 8);
            } else if (icon.getImageLoadStatus() == 4) {
                MessageDisplay.errorMsg("iconNotFound", String.valueOf(name) + "@TGUI: ", 8);
            }
        }
        return icon;
    }

    public void setGraphicsPath(String path) {
        this.GRAPHICS_PATH = path;
    }

    public void setTranslator(Translator t) {
        this.translator = t;
    }

    private Translator getTranslator() {
        return this.translator;
    }

    public ExtendedAction generateAction(String key, Object[] params, Object invocationTargetObject, Object[] args, boolean isButton) {
        ExtendedAction theAction = new ExtendedAction(isButton ? null : this.getTranslator().translateMessage(String.valueOf(key) + ".label", params), this.getTranslator().translateMessage(String.valueOf(key) + ".iconName", params), this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText", params), this.getTranslator().translateMessage(String.valueOf(key) + ".targetCall", params), invocationTargetObject, args, this.getTranslator());
        return theAction;
    }

    public ExtendedActionButton generateActionButton(String key, Action theAction) {
        return this.generateActionButton(key, null, theAction);
    }

    public ExtendedActionButton generateActionButton(String key, Object[] params, Action theAction) {
        String labelString = this.getTranslator().translateMessage(String.valueOf(key) + ".label", params);
        String mnemonicString = this.getTranslator().translateMessage(String.valueOf(key) + ".mnemonic");
        char mnemonic = mnemonicString != null ? mnemonicString.charAt(0) : key.charAt(0);
        ExtendedActionButton theButton = new ExtendedActionButton(theAction, mnemonic);
        theButton.setText(labelString);
        theButton.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText", params));
        if (theButton != null) {
            this.registerComponent(key, theButton);
        }
        return theButton;
    }

    public AbstractButton generateJButton(String key) {
        return this.generateJButton(key, null, false, null);
    }

    public AbstractButton generateJButton(String key, Object[] params, boolean isToggleButton) {
        return this.generateJButton(key, params, isToggleButton, null);
    }

    public AbstractButton generateJButton(String key, Object[] params, boolean isToggleButton, ActionListener listener) {
        String translatedMessage = this.getTranslator().translateMessage(String.valueOf(key) + ".label", params);
        AbstractButton localButton = null;
        if (translatedMessage != null) {
            String iconName = this.getTranslator().translateMessage(String.valueOf(key) + ".iconName", params);
            localButton = !isToggleButton ? (iconName != null && iconName.length() > 0 ? new JButton(this.getImageIcon(iconName)) : new JButton(translatedMessage)) : (iconName != null ? new JToggleButton(this.getImageIcon(iconName)) : new JToggleButton(translatedMessage));
            String mnemonicString = this.getTranslator().translateMessage(String.valueOf(key) + ".mnemonic", params, true);
            localButton.setMnemonic(mnemonicString != null ? mnemonicString.charAt(0) : translatedMessage.charAt(0));
            localButton.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText", params, true));
        }
        if (localButton != null) {
            this.registerComponent(key, localButton);
            if (listener != null) {
                localButton.addActionListener(listener);
            }
        }
        return localButton;
    }

    public JCheckBox generateJCheckBox(String key) {
        return (JCheckBox)this.generateJToggleButton(key, null, null, false);
    }

    public JCheckBox generateJCheckBox(String key, Object[] params, ActionListener listener) {
        return (JCheckBox)this.generateJToggleButton(key, params, listener, false);
    }

    public JToggleButton generateJToggleButton(String key, Object[] params, ActionListener listener, boolean isRadioButton) {
        String translatedMessage = this.getTranslator().translateMessage(String.valueOf(key) + ".label", params);
        AbstractButton localButton = null;
        if (translatedMessage != null) {
            String iconName = this.getTranslator().translateMessage(String.valueOf(key) + ".iconName", params);
            localButton = isRadioButton ? (iconName != null && iconName.length() > 0 ? new JRadioButton(this.getImageIcon(iconName)) : new JRadioButton(translatedMessage)) : (iconName != null && iconName.length() > 0 ? new JCheckBox(this.getImageIcon(iconName)) : new JCheckBox(translatedMessage));
            String mnemonicString = this.getTranslator().translateMessage(String.valueOf(key) + ".mnemonic", params, true);
            localButton.setMnemonic(mnemonicString != null ? mnemonicString.charAt(0) : translatedMessage.charAt(0));
            localButton.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText", params, true));
        }
        if (localButton != null) {
            this.registerComponent(key, localButton);
            if (listener != null) {
                localButton.addActionListener(listener);
            }
        }
        return localButton;
    }

    public JComboBox generateJComboBox(String key, Object[] params, String[] labels) {
        return this.generateJComboBox(key, params, labels, labels[0]);
    }

    public JComboBox generateJComboBox(String key, Object[] params, String[] labels, String selectedItem) {
        JComboBox<String> internalComboBox = new JComboBox<String>();
        if (selectedItem == null) {
            selectedItem = labels[0];
        }
        internalComboBox.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText", params));
        int i = 0;
        int n = labels.length;
        while (i < n) {
            internalComboBox.addItem(labels[i]);
            ++i;
        }
        internalComboBox.setSelectedItem(selectedItem);
        this.registerComponent(key, internalComboBox);
        return internalComboBox;
    }

    public ArrayInputTable generateArrayInputTable(String key) {
        ArrayInputTable internalArrayInputTable = new ArrayInputTable();
        internalArrayInputTable.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
        internalArrayInputTable.setLocalHeaderString(this.getTranslator().translateMessage("element"));
        this.registerComponent(key, internalArrayInputTable);
        return internalArrayInputTable;
    }

    public ArrayInputTable generateArrayInputTable(String key, int numElements) {
        ArrayInputTable internalArrayInputTable = new ArrayInputTable(numElements);
        internalArrayInputTable.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
        internalArrayInputTable.setLocalHeaderString(this.getTranslator().translateMessage("element"));
        this.registerComponent(key, internalArrayInputTable);
        return internalArrayInputTable;
    }

    public ArrayInputTable generateArrayInputTable(String key, int[] newValues) {
        ArrayInputTable internalArrayInputTable = new ArrayInputTable(newValues);
        internalArrayInputTable.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
        internalArrayInputTable.setLocalHeaderString(this.getTranslator().translateMessage("element"));
        this.registerComponent(key, internalArrayInputTable);
        return internalArrayInputTable;
    }

    public ArrayInputTable generateArrayInputTable(String key, String[] newValues) {
        ArrayInputTable internalArrayInputTable = new ArrayInputTable(newValues);
        internalArrayInputTable.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
        internalArrayInputTable.setLocalHeaderString(this.getTranslator().translateMessage("element"));
        this.registerComponent(key, internalArrayInputTable);
        return internalArrayInputTable;
    }

    public ColorChooserComboBox generateColorChooserComboBox(String key) {
        ColorChooserComboBox internalComboBox = new ColorChooserComboBox();
        String[] strKeys = internalComboBox.getTranslatorKeys();
        String[] strLocal = new String[strKeys.length];
        int i = 0;
        while (i < strKeys.length) {
            strLocal[i] = this.getTranslator().translateMessage(strKeys[i]);
            ++i;
        }
        internalComboBox.setLocalStrings(strLocal);
        internalComboBox.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
        this.registerComponent(key, internalComboBox);
        return internalComboBox;
    }

    public ColorChooserComboBox generateColorChooserComboBox(String key, Color colorSelected) {
        ColorChooserComboBox internalComboBox = new ColorChooserComboBox(colorSelected);
        String[] strKeys = internalComboBox.getTranslatorKeys();
        String[] strLocal = new String[strKeys.length];
        int i = 0;
        while (i < strKeys.length) {
            strLocal[i] = this.getTranslator().translateMessage(strKeys[i]);
            ++i;
        }
        internalComboBox.setLocalStrings(strLocal);
        internalComboBox.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
        this.registerComponent(key, internalComboBox);
        return internalComboBox;
    }

    public ColorChooserComboBox generateColorChooserComboBox(String key, String strSelected) {
        ColorChooserComboBox internalComboBox = new ColorChooserComboBox(strSelected);
        String[] strKeys = internalComboBox.getTranslatorKeys();
        String[] strLocal = new String[strKeys.length];
        int i = 0;
        while (i < strKeys.length) {
            strLocal[i] = this.getTranslator().translateMessage(strKeys[i]);
            ++i;
        }
        internalComboBox.setLocalStrings(strLocal);
        internalComboBox.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
        this.registerComponent(key, internalComboBox);
        return internalComboBox;
    }

    public FontChooserComboBox generateFontChooserComboBox(String key) {
        FontChooserComboBox internalComboBox = new FontChooserComboBox();
        internalComboBox.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
        this.registerComponent(key, internalComboBox);
        return internalComboBox;
    }

    public JFrame generateJFrame(String key) {
        JFrame newFrame = new JFrame(key);
        this.registerComponent(key, newFrame);
        return newFrame;
    }

    public FontChooserComboBox generateFontChooserComboBox(String key, String selected) {
        FontChooserComboBox internalComboBox = new FontChooserComboBox(selected);
        internalComboBox.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
        this.registerComponent(key, internalComboBox);
        return internalComboBox;
    }

    public IntegerTextField generateIntegerTextField(String key) {
        IntegerTextField internalIntegerTextField = new IntegerTextField();
        internalIntegerTextField.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
        this.registerComponent(key, internalIntegerTextField);
        return internalIntegerTextField;
    }

    public IntegerTextField generateIntegerTextField(String key, String text) {
        IntegerTextField internalIntegerTextField = new IntegerTextField(text);
        internalIntegerTextField.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
        this.registerComponent(key, internalIntegerTextField);
        return internalIntegerTextField;
    }

    public IntegerTextFieldEx generateIntegerTextFieldEx(String key) {
        IntegerTextFieldEx internalIntegerTextField = new IntegerTextFieldEx();
        internalIntegerTextField.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
        this.registerComponent(key, internalIntegerTextField);
        return internalIntegerTextField;
    }

    public IntegerTextFieldEx generateIntegerTextFieldEx(String key, String text) {
        IntegerTextFieldEx internalIntegerTextField = new IntegerTextFieldEx(text);
        internalIntegerTextField.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
        this.registerComponent(key, internalIntegerTextField);
        return internalIntegerTextField;
    }

    public MatrixInputTable generateMatrixInputTable(String key) {
        MatrixInputTable internalMatrixInputTable = new MatrixInputTable();
        internalMatrixInputTable.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
        internalMatrixInputTable.setLocalHeaderString(this.getTranslator().translateMessage("column"));
        this.registerComponent(key, internalMatrixInputTable);
        return internalMatrixInputTable;
    }

    public MatrixInputTable generateMatrixInputTable(String key, int numRows, int numColumns) {
        MatrixInputTable internalMatrixInputTable = new MatrixInputTable(numRows, numColumns);
        internalMatrixInputTable.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
        internalMatrixInputTable.setLocalHeaderString(this.getTranslator().translateMessage("column"));
        this.registerComponent(key, internalMatrixInputTable);
        return internalMatrixInputTable;
    }

    public MatrixInputTable generateMatrixInputTable(String key, int[][] newValues) {
        MatrixInputTable internalMatrixInputTable = new MatrixInputTable(newValues);
        internalMatrixInputTable.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
        internalMatrixInputTable.setLocalHeaderString(this.getTranslator().translateMessage("column"));
        this.registerComponent(key, internalMatrixInputTable);
        return internalMatrixInputTable;
    }

    public JPopupMenu generateJPopupMenu(String key) {
        JPopupMenu popup = new JPopupMenu(key);
        this.registerComponent(key, popup);
        return popup;
    }

    public JLabel generateJLabel(String key) {
        return this.generateJLabel(key, null);
    }

    public JLabel generateJLabel(String key, Object[] params) {
        String translatedMessage = this.getTranslator().translateMessage(key, params);
        JLabel localLabel = null;
        if (translatedMessage != null) {
            localLabel = new JLabel(translatedMessage);
        }
        if (localLabel != null) {
            this.registerComponent(key, localLabel);
        }
        return localLabel;
    }

    public JList generateJList(String key, Object[] params, Object[] labels, int selectionMode, ListSelectionListener listener, int selectedIndex) {
        JList<Object> internalList = new JList<Object>();
        internalList.setSelectionMode(selectionMode);
        internalList.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText", params));
        internalList.setListData(labels);
        if (selectedIndex != -1) {
            internalList.setSelectedIndex(selectedIndex);
        }
        internalList.addListSelectionListener(listener);
        this.registerComponent(key, internalList);
        return internalList;
    }

    public JMenu generateJMenu(String key) {
        return this.generateJMenu(key, null);
    }

    public JMenu generateJMenu(String key, Object[] params) {
        String translatedMessage = this.getTranslator().translateMessage(String.valueOf(key) + ".label", params);
        JMenu localMenu = null;
        if (translatedMessage != null) {
            localMenu = new JMenu(translatedMessage);
            String mnemonicString = this.getTranslator().translateMessage(String.valueOf(key) + ".mnemonic", params, true);
            localMenu.setMnemonic(mnemonicString != null ? mnemonicString.charAt(0) : translatedMessage.charAt(0));
            localMenu.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText", params, true));
        }
        if (localMenu != null) {
            this.registerComponent(key, localMenu);
        }
        return localMenu;
    }

    public JMenuItem generateJMenuItem(String key) {
        return this.generateJMenuItem(key, null, false);
    }

    public JMenuItem generateJMenuItem(String key, boolean useIcon) {
        return this.generateJMenuItem(key, null, true);
    }

    public JMenuItem generateJMenuItem(String key, Object[] params) {
        return this.generateJMenuItem(key, params, true);
    }

    public JMenuItem generateJMenuItem(String key, Object[] params, boolean useIcon) {
        String translatedMessage = this.getTranslator().translateMessage(String.valueOf(key) + ".label", params);
        JMenuItem localMenuItem = null;
        if (translatedMessage != null) {
            String iconName;
            localMenuItem = new JMenuItem(translatedMessage);
            String mnemonicString = this.getTranslator().translateMessage(String.valueOf(key) + ".mnemonic", params, true);
            localMenuItem.setMnemonic(mnemonicString != null && mnemonicString.length() > 0 ? mnemonicString.charAt(0) : translatedMessage.charAt(0));
            localMenuItem.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText", params, true));
            if (useIcon && (iconName = this.getTranslator().translateMessage(String.valueOf(key) + ".iconName", params)) != null) {
                localMenuItem.setIcon(this.getImageIcon(iconName));
            }
        }
        if (localMenuItem != null) {
            this.registerComponent(key, localMenuItem);
        }
        return localMenuItem;
    }

    public JPanel generateBorderedJPanel(String key) {
        return this.generateBorderedJPanel(key, null);
    }

    public JPanel generateBorderedJPanel(String key, Object[] params) {
        String borderTitle = this.getTranslator().translateMessage(key, params);
        JPanel targetPanel = new JPanel();
        targetPanel.setBorder(new TitledBorder(null, borderTitle, 4, 2));
        this.registerComponent(key, targetPanel);
        return targetPanel;
    }

    public Border generateTitledBorder(String key) {
        return this.generateBorder(key, null);
    }

    public Border generateBorder(String key, Object[] params) {
        TitledBorder border = BorderFactory.createTitledBorder(this.getTranslator().translateMessage(key, params));
        return border;
    }

    public Box generateBorderedBox(int alignment, String key) {
        return this.generateBorderedBox(alignment, key, null);
    }

    public Box generateBorderedBox(int alignment, String key, Object[] params) {
        String borderTitle = this.getTranslator().translateMessage(key, params);
        Box box = new Box(alignment);
        box.setBorder(new TitledBorder(null, borderTitle, 4, 2));
        this.registerComponent(key, box);
        return box;
    }

    public JSlider generateJSlider(String key, Object[] params, int min, int max, ChangeListener listener) {
        return this.generateJSlider(key, params, min, max, min, (max - min) / 5, (max - min) / 20, false, listener);
    }

    public JSlider generateJSlider(String key, Object[] params, int min, int max, int defaultValue, boolean snapMode, ChangeListener listener) {
        return this.generateJSlider(key, params, min, max, defaultValue, (max - min) / 5, (max - min) / 20, snapMode, listener);
    }

    public JSlider generateJSlider(String key, Object[] params, int min, int max, int defaultValue, int majorSpacing, int minorSpacing, boolean snapMode, ChangeListener listener) {
        JSlider slider = new JSlider(min, max, defaultValue);
        slider.addChangeListener(listener);
        slider.setLabelTable(slider.createStandardLabels(majorSpacing));
        slider.setPaintTicks(true);
        slider.setMajorTickSpacing(majorSpacing);
        slider.setMinorTickSpacing(minorSpacing);
        slider.setPaintLabels(true);
        slider.setSnapToTicks(snapMode);
        String toolTipText = this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText", params);
        if (toolTipText != null) {
            slider.setToolTipText(toolTipText);
            this.registerComponent(key, slider);
        }
        return slider;
    }

    public JTextField generateJTextField(String key, Object[] params, int width, String defaultText) {
        if (width < 0) {
            width = 3;
        }
        JTextField textField = new JTextField(width);
        textField.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText", params));
        if (defaultText != null) {
            textField.setText(defaultText);
        } else {
            textField.setText(this.getTranslator().translateMessage(String.valueOf(key) + ".default", params));
        }
        this.registerComponent(key, textField);
        return textField;
    }

    public void insertTranslatableTab(String tabKey, Component component, JTabbedPane tabbedPane) {
        this.insertTranslatableTab(tabKey, null, component, tabbedPane);
    }

    public void insertTranslatableTab(String tabKey, Object[] params, Component component, JTabbedPane tabbedPane) {
        if (tabbedPane != null && component != null) {
            String label = this.getTranslator().translateMessage(tabKey, params);
            if (label == null) {
                label = tabKey;
            }
            tabbedPane.addTab(label, component);
            this.registerComponent(tabKey, tabbedPane);
        }
    }

    public JMenuItem generateToggleableJMenuItem(String key, Object[] params, boolean isCheckBox) {
        return this.generateToggleableJMenuItem(key, params, isCheckBox, false);
    }

    public JMenuItem generateToggleableJMenuItem(String key, Object[] params, boolean isCheckBox, boolean isSelected) {
        String translatedMessage = this.getTranslator().translateMessage(String.valueOf(key) + ".label", params);
        JMenuItem localMenuItem = null;
        if (translatedMessage != null) {
            String iconName = this.getTranslator().translateMessage(String.valueOf(key) + ".iconName", params);
            localMenuItem = iconName != null ? (isCheckBox ? new JCheckBoxMenuItem(translatedMessage, this.getImageIcon(iconName)) : new JRadioButtonMenuItem(translatedMessage, this.getImageIcon(iconName))) : (isCheckBox ? new JCheckBoxMenuItem(translatedMessage) : new JRadioButtonMenuItem(translatedMessage));
            String mnemonicString = this.getTranslator().translateMessage(String.valueOf(key) + ".mnemonic", params, true);
            localMenuItem.setMnemonic(mnemonicString != null ? mnemonicString.charAt(0) : translatedMessage.charAt(0));
            localMenuItem.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText", params, true));
            localMenuItem.setSelected(isSelected);
        }
        if (localMenuItem != null) {
            this.registerComponent(key, localMenuItem);
        }
        return localMenuItem;
    }

    public AbstractButton insertToMenu(String key, Object[] params, Object invocationTargetObject, Object[] args, JMenu menu) {
        return this.insertMenuToolBar(key, params, invocationTargetObject, args, menu, null);
    }

    public AbstractButton insertToPopupMenu(String key, Object[] params, Object invocationTargetObject, Object[] args, JPopupMenu menu) {
        return this.insertMenuToolBar(key, params, invocationTargetObject, args, menu, null);
    }

    public AbstractButton insertToToolBar(String key, Object[] params, Object invocationTargetObject, Object[] args, JToolBar toolBar) {
        return this.insertMenuToolBar(key, params, invocationTargetObject, args, null, toolBar);
    }

    public AbstractButton insertToMenuAndToolBar(String key, Object[] params, Object invocationTargetObject, Object[] args, JMenu menu, JToolBar toolBar) {
        return this.insertMenuToolBar(key, params, invocationTargetObject, args, menu, toolBar);
    }

    public AbstractButton insertToMenuAndToolBar(String key, Object[] params, Object invocationTargetObject, Object[] args, JPopupMenu menu, JToolBar toolBar) {
        return this.insertMenuToolBar(key, params, invocationTargetObject, args, menu, toolBar);
    }

    private AbstractButton insertMenuToolBar(String key, Object[] params, Object invocationTargetObject, Object[] args, MenuElement menu, JToolBar toolBar) {
        String translatedMessage = this.getTranslator().translateMessage(String.valueOf(key) + ".label", params);
        String mnemonicString = this.getTranslator().translateMessage(String.valueOf(key) + ".mnemonic", params, true);
        ExtendedAction theAction = null;
        AbstractButton wrapper = null;
        if (menu != null && (menu instanceof JMenu || menu instanceof JPopupMenu)) {
            theAction = this.generateAction(key, params, invocationTargetObject, args, false);
            wrapper = menu instanceof JMenu ? ((JMenu)menu).add(theAction) : ((JPopupMenu)menu).add(theAction);
            wrapper.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText", params));
            wrapper.setMnemonic(mnemonicString != null ? mnemonicString.charAt(0) : translatedMessage.charAt(0));
            this.registerComponent(String.valueOf(key) + ".item", wrapper);
        }
        if (toolBar != null) {
            theAction = this.generateAction(key, params, invocationTargetObject, args, true);
            wrapper = toolBar.add(theAction);
            wrapper.setMnemonic(mnemonicString != null ? mnemonicString.charAt(0) : translatedMessage.charAt(0));
            this.registerComponent(String.valueOf(key) + ".button", wrapper);
        }
        return wrapper;
    }

    private void registerComponent(String key, Component component) {
        if (this.translatableElements.containsKey(key)) {
            Object o = this.translatableElements.get(key);
            if (o instanceof Vector) {
                Vector v = (Vector)o;
                if (!v.contains(component)) {
                    v.addElement(component);
                }
            } else {
                Vector<Component> v = new Vector<Component>(50, 15);
                v.addElement(component);
                this.translatableElements.put(key, v);
            }
        } else {
            this.translatableElements.put(key, component);
        }
    }

    public void translateGUIElements() {
        Enumeration<String> e = this.translatableElements.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Object currentElement = this.translatableElements.get(key);
            if (currentElement == null) continue;
            if (currentElement instanceof JComponent) {
                this.updateComponent(key, (JComponent)currentElement);
                continue;
            }
            if (!(currentElement instanceof Vector)) continue;
            this.updateVectorElements(key, (Vector)currentElement);
        }
    }

    private void updateComponent(String key, Component component) {
        if (component != null) {
            if (component instanceof AbstractButton) {
                AbstractButton element;
                String value;
                if (key.endsWith(".item") || key.endsWith(".button")) {
                    key = key.substring(0, key.lastIndexOf(46));
                }
                if ((value = (element = (AbstractButton)component).getText()) != null && value.length() > 0) {
                    element.setText(this.getTranslator().translateMessage(String.valueOf(key) + ".label"));
                }
                if ((value = this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText")) != null) {
                    element.setToolTipText(value);
                }
                if ((value = this.getTranslator().translateMessage(String.valueOf(key) + ".mnemonic")) != null && value.length() > 0) {
                    element.setMnemonic(value.charAt(0));
                }
            } else if (component instanceof ExtendedActionButton) {
                ExtendedActionButton element = (ExtendedActionButton)component;
                String value = element.getText();
                if (value != null && value.length() > 0) {
                    element.setText(this.getTranslator().translateMessage(String.valueOf(key) + ".label"));
                }
                if ((value = this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText")) != null) {
                    element.setToolTipText(value);
                }
                if ((value = this.getTranslator().translateMessage(String.valueOf(key) + ".mnemonic")) != null && value.length() > 0) {
                    element.setMnemonic(value.charAt(0));
                }
            } else if (component instanceof JLabel) {
                ((JLabel)component).setText(this.getTranslator().translateMessage(key));
            } else if (component instanceof JTabbedPane) {
                JTabbedPane pane = (JTabbedPane)component;
                int indexOfTab = pane.indexOfTab(key);
                String newLabel = this.getTranslator().translateMessage(key);
                if (newLabel == null || newLabel.length() == 0) {
                    newLabel = key;
                }
                if (indexOfTab != -1) {
                    pane.setTitleAt(indexOfTab, newLabel);
                }
            } else if (component instanceof ArrayInputTable) {
                ArrayInputTable ait = (ArrayInputTable)component;
                ait.setLocalHeaderString(this.getTranslator().translateMessage("element"));
                ait.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
            } else if (component instanceof ColorChooserComboBox) {
                ColorChooserComboBox cc = (ColorChooserComboBox)component;
                String[] strKeys = cc.getTranslatorKeys();
                String[] strLocal = new String[strKeys.length];
                int i = 0;
                while (i < strKeys.length) {
                    strLocal[i] = this.getTranslator().translateMessage(strKeys[i]);
                    ++i;
                }
                cc.setLocalStrings(strLocal);
                cc.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
            } else if (component instanceof MatrixInputTable) {
                MatrixInputTable mit = (MatrixInputTable)component;
                mit.setLocalHeaderString(this.getTranslator().translateMessage("column"));
                mit.setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
            } else if (component instanceof JComponent) {
                ((JComponent)component).setToolTipText(this.getTranslator().translateMessage(String.valueOf(key) + ".toolTipText"));
            }
        }
    }

    private void updateVectorElements(String key, Vector<Object> elements) {
        int nrElements = elements == null ? -1 : elements.size();
        Object currentElement = null;
        int elemPos = 0;
        while (elemPos < nrElements) {
            currentElement = elements.elementAt(elemPos);
            if (currentElement instanceof JComponent) {
                this.updateComponent(key, (JComponent)currentElement);
            }
            ++elemPos;
        }
    }
}

