/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import translator.Debug;

public class ResourceLocator {
    private static ResourceLocator locator = null;

    public static ResourceLocator getResourceLocator() {
        if (locator == null) {
            locator = new ResourceLocator();
        }
        return locator;
    }

    public InputStream getResourceStream(String resourceName) {
        return this.getResourceStream(resourceName, null, false, null);
    }

    public InputStream getResourceStream(String resourceName, String extension) {
        return this.getResourceStream(resourceName, extension, false, null);
    }

    public InputStream getResourceStream(String resourceName, boolean runsAsApplet, URL codeBaseName) {
        return this.getResourceStream(resourceName, null, runsAsApplet, codeBaseName);
    }

    public InputStream getResourceStream(String resourceName, String extension, String directoryName) {
        String filename = null;
        filename = directoryName == null ? resourceName : (directoryName.endsWith(File.separator) ? String.valueOf(directoryName) + resourceName : String.valueOf(directoryName) + File.separator + resourceName);
        InputStream inStream = this.getResourceStream(filename, extension);
        if (inStream == null && directoryName != null) {
            inStream = this.getResourceStream(resourceName, extension);
        }
        return inStream;
    }

    public InputStream getResourceStream(String resourceName, String extension, boolean runsAsApplet, URL codeBase) {
        InputStream inputStream;
        block9: {
            inputStream = null;
            StringBuilder filenameBuffer = new StringBuilder(255);
            if (runsAsApplet && codeBase != null) {
                filenameBuffer.append(codeBase.toString());
            }
            filenameBuffer.append(resourceName);
            if (extension != null) {
                filenameBuffer.append('.').append(extension);
            }
            String filename = filenameBuffer.toString();
            inputStream = this.getClass().getResourceAsStream("/" + filename);
            if (inputStream == null) {
                inputStream = ClassLoader.getSystemResourceAsStream(filename);
            }
            if (runsAsApplet && inputStream == null) {
                try {
                    URL targetURL = new URL(filename);
                    inputStream = targetURL.openStream();
                }
                catch (IOException ioExceptionApplet) {
                    Debug.printlnMessage("Sorry, the applet cannot open the resource file for " + filename);
                }
            }
            if (inputStream == null) {
                try {
                    inputStream = new FileInputStream(filename);
                }
                catch (IOException ioExceptionLocal) {
                    if (inputStream != null) break block9;
                    Debug.printlnMessage("Class, ClassLoader and local file IO cannot allocate file `" + filename + "'");
                }
            }
        }
        return inputStream;
    }
}

